/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validation.constraints.impl;

import java.util.regex.Matcher;
import java.util.regex.PatternSyntaxException;
import javax.validation.ConstraintDeclarationException;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.constraints.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternValidator
implements ConstraintValidator<Pattern, String> {
    private java.util.regex.Pattern pattern;

    @Override
    public void initialize(Pattern parameters) {
        Pattern.Flag[] flags = parameters.flags();
        int intFlag = 0;
        for (Pattern.Flag flag : flags) {
            intFlag |= flag.getValue();
        }
        try {
            this.pattern = java.util.regex.Pattern.compile(parameters.regexp(), intFlag);
        }
        catch (PatternSyntaxException e) {
            throw new ConstraintDeclarationException("Invalid regular expression.", e);
        }
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext constraintValidatorContext) {
        if (value == null) {
            return true;
        }
        Matcher m = this.pattern.matcher(value);
        return m.matches();
    }
}

