/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport;

import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.impl.transport.CorbaConnectionCacheBase;
import com.sun.corba.ee.impl.transport.CorbaInboundConnectionCacheProbeProvider;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.transport.CorbaAcceptor;
import com.sun.corba.ee.spi.transport.CorbaConnection;
import com.sun.corba.ee.spi.transport.CorbaInboundConnectionCache;
import java.util.ArrayList;
import java.util.Collection;

public class CorbaInboundConnectionCacheImpl
extends CorbaConnectionCacheBase
implements CorbaInboundConnectionCache {
    protected Collection<CorbaConnection> connectionCache;
    private CorbaInboundConnectionCacheProbeProvider pp = new CorbaInboundConnectionCacheProbeProvider();

    public CorbaInboundConnectionCacheImpl(ORB orb, CorbaAcceptor acceptor) {
        super(orb, acceptor.getConnectionCacheType(), acceptor.getMonitoringName());
        this.connectionCache = new ArrayList<CorbaConnection>();
    }

    @Override
    public CorbaConnection get(CorbaAcceptor acceptor) {
        throw this.wrapper.methodShouldNotBeCalled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(CorbaAcceptor acceptor, CorbaConnection connection) {
        if (this.orb.transportDebugFlag) {
            this.dprint(".put: " + acceptor + " " + connection);
        }
        Object object = this.backingStore();
        synchronized (object) {
            this.connectionCache.add(connection);
            connection.setConnectionCache(this);
            this.dprintStatistics();
            this.pp.connectionOpenedEvent(acceptor.toString(), connection.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(CorbaConnection connection) {
        if (this.orb.transportDebugFlag) {
            this.dprint(".remove: " + connection);
        }
        Object object = this.backingStore();
        synchronized (object) {
            this.connectionCache.remove(connection);
            this.dprintStatistics();
            this.pp.connectionClosedEvent(connection.toString());
        }
    }

    @Override
    public Collection values() {
        return this.connectionCache;
    }

    @Override
    protected Object backingStore() {
        return this.connectionCache;
    }

    @Override
    protected void dprint(String msg) {
        ORBUtility.dprint("CorbaInboundConnectionCacheImpl", msg);
    }
}

