/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport;

import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.impl.transport.CorbaConnectionCacheBase;
import com.sun.corba.ee.impl.transport.CorbaOutboundConnectionCacheProbeProvider;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.transport.CorbaConnection;
import com.sun.corba.ee.spi.transport.CorbaContactInfo;
import com.sun.corba.ee.spi.transport.CorbaOutboundConnectionCache;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class CorbaOutboundConnectionCacheImpl
extends CorbaConnectionCacheBase
implements CorbaOutboundConnectionCache {
    protected Map<CorbaContactInfo, CorbaConnection> connectionCache;
    private CorbaOutboundConnectionCacheProbeProvider pp = new CorbaOutboundConnectionCacheProbeProvider();

    public CorbaOutboundConnectionCacheImpl(ORB orb, CorbaContactInfo contactInfo) {
        super(orb, contactInfo.getConnectionCacheType(), contactInfo.getMonitoringName());
        this.connectionCache = new HashMap<CorbaContactInfo, CorbaConnection>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CorbaConnection get(CorbaContactInfo contactInfo) {
        if (this.orb.transportDebugFlag) {
            this.dprint(".get: " + contactInfo + " " + ((Object)contactInfo).hashCode());
        }
        Object object = this.backingStore();
        synchronized (object) {
            this.dprintStatistics();
            return this.connectionCache.get(contactInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(CorbaContactInfo contactInfo, CorbaConnection connection) {
        if (this.orb.transportDebugFlag) {
            this.dprint(".put: " + contactInfo + " " + ((Object)contactInfo).hashCode() + " " + connection);
        }
        Object object = this.backingStore();
        synchronized (object) {
            this.connectionCache.put(contactInfo, connection);
            connection.setConnectionCache(this);
            this.pp.connectionOpenedEvent(contactInfo.toString(), connection.toString());
            this.dprintStatistics();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(CorbaContactInfo contactInfo) {
        if (this.orb.transportDebugFlag) {
            this.dprint(".remove: " + contactInfo + " " + ((Object)contactInfo).hashCode());
        }
        Object object = this.backingStore();
        synchronized (object) {
            if (contactInfo != null) {
                CorbaConnection connection = this.connectionCache.remove(contactInfo);
                this.pp.connectionClosedEvent(contactInfo.toString(), connection.toString());
            }
            this.dprintStatistics();
        }
    }

    @Override
    public Collection values() {
        return this.connectionCache.values();
    }

    @Override
    protected Object backingStore() {
        return this.connectionCache;
    }

    public String toString() {
        return "CorbaOutboundConnectionCacheImpl[" + this.connectionCache + "]";
    }

    @Override
    protected void dprint(String msg) {
        ORBUtility.dprint("CorbaOutboundConnectionCacheImpl", msg);
    }
}

