/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.embedded;

import com.sun.enterprise.util.i18n.StringManager;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class DomainXmlTransformer {
    private File in;
    private File out;
    private final XMLEventFactory xmlEventFactory = XMLEventFactory.newInstance();
    private final XMLOutputFactory xof = XMLOutputFactory.newInstance();
    private Logger _logger = Logger.getAnonymousLogger("com.sun.logging.enterprise.system.container.ejb.LogStrings");
    private static final String NETWORK_LISTENERS = "network-listeners";
    private static final String IIOP_LISTENER = "iiop-listener";
    private static final String LAZY_INIT_ATTR = "lazy-init";
    private static final String PROTOCOLS = "protocols";
    private static final String APPLICATIONS = "applications";
    private static final String JMS_HOST = "jms-host";
    private static final StringManager localStrings = StringManager.getManager(DomainXmlTransformer.class);

    public DomainXmlTransformer(File domainXml) {
        this.in = domainXml;
    }

    public DomainXmlTransformer(File domainXml, Logger logger) {
        this.in = domainXml;
        this._logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public File transform() {
        block43: {
            FileInputStream fis = null;
            FileOutputStream fos = null;
            XMLEventReader parser = null;
            XMLEventWriter writer = null;
            XMLInputFactory xif = XMLInputFactory.class.getClassLoader() == null ? XMLInputFactory.newInstance() : XMLInputFactory.newInstance(XMLInputFactory.class.getName(), XMLInputFactory.class.getClassLoader());
            fis = new FileInputStream(this.in);
            this.out = File.createTempFile("domain", "xml");
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.fine("[DomainXmlTransformer] Creating temp domain file: " + this.out);
            }
            this.out.deleteOnExit();
            fos = new FileOutputStream(this.out);
            parser = xif.createXMLEventReader(fis);
            writer = this.xof.createXMLEventWriter(fos);
            while (parser.hasNext()) {
                String name;
                XMLEvent event = parser.nextEvent();
                if (event.isStartElement() && ((name = event.asStartElement().getName().getLocalPart()).equals(NETWORK_LISTENERS) || name.equals(JMS_HOST) || name.equals(PROTOCOLS) || name.equals(IIOP_LISTENER) || name.equals(APPLICATIONS))) {
                    if (name.equals(IIOP_LISTENER) || name.equals(JMS_HOST)) {
                        StartElement newStartEvent = this.getAdjustedStartEvent(event, LAZY_INIT_ATTR);
                        writer.add(newStartEvent);
                    } else {
                        writer.add(event);
                    }
                    if (this._logger.isLoggable(Level.FINE)) {
                        this._logger.fine("[DomainXmlTransformer] Skipping details of: " + name);
                    }
                    event = this.getEndEventFor(parser, name);
                }
                if (this._logger.isLoggable(Level.FINEST)) {
                    this._logger.finest("[DomainXmlTransformer] Processing: " + event);
                }
                writer.add(event);
            }
            writer.flush();
            writer.close();
            Object var10_11 = null;
            try {
                if (parser != null) {
                    parser.close();
                }
            }
            catch (Exception e2) {
                // empty catch block
            }
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception e2) {
                // empty catch block
            }
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception e2) {
                // empty catch block
            }
            try {
                if (fos != null) {
                    fos.close();
                }
                break block43;
            }
            catch (Exception e2) {}
            break block43;
            {
                catch (Exception e) {
                    this._logger.log(Level.SEVERE, "ejb.embedded.tmp_file_create_error", e.getMessage());
                    this._logger.log(Level.FINE, e.getMessage(), e);
                    File file = null;
                    Object var10_12 = null;
                    try {
                        if (parser != null) {
                            parser.close();
                        }
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    try {
                        if (fos != null) {
                            fos.close();
                        }
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    return file;
                }
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                try {
                    if (parser != null) {
                        parser.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.fine("[DomainXmlTransformer] Created temp domain file: " + this.out);
        }
        return this.out;
    }

    private XMLEvent getEndEventFor(XMLEventReader parser, String name) throws XMLStreamException, EOFException {
        while (parser.hasNext()) {
            XMLEvent event = parser.nextEvent();
            if (!event.isEndElement() || !event.asEndElement().getName().getLocalPart().equals(name)) continue;
            if (this._logger.isLoggable(Level.FINEST)) {
                this._logger.finest("[DomainXmlTransformer] END: " + name);
            }
            return event;
        }
        throw new EOFException(localStrings.getString("ejb.embedded.no_matching_end_element", (Object)name));
    }

    private StartElement getEmptyStartEvent(XMLEvent event) {
        StartElement oldStartEvent = event.asStartElement();
        return this.xmlEventFactory.createStartElement(oldStartEvent.getName(), null, oldStartEvent.getNamespaces());
    }

    private StartElement getAdjustedStartEvent(XMLEvent event, String skipValue) {
        HashSet<Attribute> attributes = new HashSet<Attribute>();
        Iterator<Attribute> i = event.asStartElement().getAttributes();
        while (i.hasNext()) {
            Attribute a = i.next();
            if (a.getName().getLocalPart().equals(skipValue)) continue;
            attributes.add(a);
        }
        StartElement oldStartEvent = event.asStartElement();
        return this.xmlEventFactory.createStartElement(oldStartEvent.getName(), attributes.iterator(), oldStartEvent.getNamespaces());
    }
}

