/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http;

import com.sun.grizzly.async.AsyncQueueWriteUnit;
import com.sun.grizzly.async.AsyncQueueWriter;
import com.sun.grizzly.async.AsyncWriteCallbackHandler;
import com.sun.grizzly.async.ByteBufferCloner;
import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.tcp.FileOutputBuffer;
import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.tcp.http11.InternalOutputBuffer;
import com.sun.grizzly.util.ByteBufferFactory;
import com.sun.grizzly.util.OutputWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.FileChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SocketChannelOutputBuffer
extends InternalOutputBuffer
implements FileOutputBuffer {
    protected static Logger logger = SelectorThread.logger();
    protected static final int DEFAULT_BUFFER_POOL_SIZE = 16384;
    protected static int maxBufferPoolSize = 16384;
    protected static Queue<ByteBuffer> bufferPool = new ArrayBlockingQueue<ByteBuffer>(maxBufferPoolSize);
    protected final ByteBufferCloner asyncHttpByteBufferCloner = new ByteBufferClonerImpl();
    private static final AsyncWriteCallbackHandler asyncHttpWriteCallbackHandler = new AsyncWriteCallbackHandlerImpl();
    protected Channel channel;
    protected SelectionKey selectionKey;
    protected boolean isAsyncHttpWriteEnabled;
    protected AsyncQueueWriter asyncQueueWriter;
    protected ByteBuffer outputByteBuffer;
    protected static final ByteBuffer ACK = ByteBuffer.wrap("HTTP/1.1 100 Continue\r\n\r\n".getBytes());
    protected static int maxBufferedBytes = 262144;
    protected boolean discardBytes = false;

    public SocketChannelOutputBuffer(Response response, int sendBufferSize, boolean useSocketBuffer) {
        super(response, sendBufferSize, useSocketBuffer);
        if (sendBufferSize > maxBufferedBytes) {
            maxBufferedBytes = sendBufferSize;
        }
        if (!useSocketBuffer) {
            this.outputStream = new NIOOutputStream();
            this.outputByteBuffer = this.createByteBuffer(sendBufferSize);
        }
    }

    protected ByteBuffer createByteBuffer(int size) {
        return ByteBuffer.allocate(size);
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public SelectionKey getSelectionKey() {
        return this.selectionKey;
    }

    public void setSelectionKey(SelectionKey selectionKey) {
        this.selectionKey = selectionKey;
        this.channel = selectionKey.channel();
    }

    public boolean isAsyncHttpWriteEnabled() {
        return this.isAsyncHttpWriteEnabled;
    }

    public void setAsyncHttpWriteEnabled(boolean isAsyncHttpWriteEnabled) {
        this.isAsyncHttpWriteEnabled = isAsyncHttpWriteEnabled;
    }

    protected AsyncQueueWriter getAsyncQueueWriter() {
        return this.asyncQueueWriter;
    }

    protected void setAsyncQueueWriter(AsyncQueueWriter asyncQueueWriter) {
        this.asyncQueueWriter = asyncQueueWriter;
    }

    public void sendAck() throws IOException {
        if (!this.committed) {
            this.flushChannel(ACK.slice());
        }
    }

    public void realWriteBytes(byte[] cbuf, int off, int len) throws IOException {
        if (this.discardBytes) {
            return;
        }
        if (len > 0) {
            if (!this.useSocketBuffer) {
                int remaining = this.outputByteBuffer.remaining();
                if (len > remaining) {
                    if (this.outputByteBuffer.capacity() >= maxBufferedBytes) {
                        this.outputByteBuffer.put(cbuf, off, remaining);
                        this.flushBuffer();
                        this.realWriteBytes(cbuf, off + remaining, len - remaining);
                        return;
                    }
                    int size = Math.max(this.outputByteBuffer.capacity() * 2, len + this.outputByteBuffer.position());
                    ByteBuffer tmp = ByteBuffer.allocate(size);
                    this.outputByteBuffer.flip();
                    tmp.put(this.outputByteBuffer);
                    this.outputByteBuffer = tmp;
                }
                this.outputByteBuffer.put(cbuf, off, len);
            } else {
                this.flushChannel(ByteBuffer.wrap(cbuf, off, len));
            }
        }
    }

    public void flushChannel(ByteBuffer bb) throws IOException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("flushChannel isAsyncHttpWriteEnabled=" + this.isAsyncHttpWriteEnabled + " bb=" + bb);
        }
        if (this.discardBytes) {
            return;
        }
        if (SelectorThread.isEnableNioLogging()) {
            ByteBuffer dd = bb.duplicate();
            int length = dd.limit();
            byte[] dump = new byte[length];
            dd.get(dump, 0, length);
            logger.info(new String(dump));
        }
        if (!this.isAsyncHttpWriteEnabled) {
            OutputWriter.flushChannel((SelectableChannel)((SocketChannel)this.channel), (ByteBuffer)bb);
            bb.clear();
        } else if (this.asyncQueueWriter != null) {
            Future future = this.asyncQueueWriter.write(this.selectionKey, bb, asyncHttpWriteCallbackHandler, null, this.asyncHttpByteBufferCloner);
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("async flushChannel isDone=" + future.isDone());
            }
            if (!bb.hasRemaining()) {
                bb.clear();
            }
        } else {
            logger.warning("HTTP async write is enabled, but AsyncWriter is null.");
        }
    }

    public boolean isSupportFileSend() {
        return this.response.getChannel() != null;
    }

    public long sendFile(FileChannel fileChannel, long position, long length) throws IOException {
        return fileChannel.transferTo(position, length, (WritableByteChannel)this.channel);
    }

    public void flush() throws IOException {
        super.flush();
        this.flushBuffer();
    }

    public void endRequest() throws IOException {
        super.endRequest();
        this.flushBuffer();
    }

    public void flushBuffer() throws IOException {
        if (!this.useSocketBuffer && this.outputByteBuffer.position() != 0) {
            this.outputByteBuffer.flip();
            this.flushChannel(this.outputByteBuffer);
            this.outputByteBuffer.clear();
        }
    }

    public void recycle() {
        this.discardBytes = false;
        this.response.recycle();
        this.socketBuffer.recycle();
        this.pos = 0;
        this.lastActiveFilter = -1;
        this.committed = false;
        this.finished = false;
        if (this.outputByteBuffer != null) {
            this.outputByteBuffer.clear();
        }
        this.channel = null;
    }

    public void reset() {
        super.reset();
        this.outputByteBuffer.clear();
    }

    public void discardUpstreamBytes() {
        try {
            this.flush();
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "", ex);
        }
        this.discardBytes = true;
    }

    private static ByteBuffer createByteBuffer(int size, boolean isDirect) {
        return ByteBufferFactory.allocateView((int)size, (boolean)isDirect);
    }

    public static int getMaxBufferedBytes() {
        return maxBufferedBytes;
    }

    public static void setMaxBufferedBytes(int aMaxBufferedBytes) {
        maxBufferedBytes = aMaxBufferedBytes;
    }

    public static void setMaxBufferPoolSize(int size) {
        int poolSize;
        int n = poolSize = size >= 0 ? size : 16384;
        if (maxBufferPoolSize == poolSize) {
            return;
        }
        maxBufferPoolSize = poolSize;
        bufferPool = new ArrayBlockingQueue<ByteBuffer>(maxBufferPoolSize);
    }

    public static int getMaxBufferPoolSize() {
        return maxBufferPoolSize;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class AsyncWriteCallbackHandlerImpl
    implements AsyncWriteCallbackHandler {
        protected AsyncWriteCallbackHandlerImpl() {
        }

        public void onWriteCompleted(SelectionKey key, AsyncQueueWriteUnit writtenRecord) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("onWriteCompleted isCloned=" + writtenRecord.isCloned());
            }
            if (writtenRecord.isCloned()) {
                this.releaseAsyncWriteUnit(writtenRecord);
            }
        }

        public void onException(Exception exception, SelectionKey key, ByteBuffer buffer, Queue<AsyncQueueWriteUnit> remainingQueue) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("onException key=" + key + " exception=" + exception);
            }
            this.returnBuffer(buffer);
            for (AsyncQueueWriteUnit unit : remainingQueue) {
                this.releaseAsyncWriteUnit(unit);
            }
        }

        protected boolean releaseAsyncWriteUnit(AsyncQueueWriteUnit unit) {
            return this.returnBuffer(unit.getByteBuffer());
        }

        protected boolean returnBuffer(ByteBuffer buffer) {
            buffer.clear();
            int size = buffer.capacity();
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("return buffer buffer=" + buffer + " maxSize=" + maxBufferedBytes);
            }
            if (size <= maxBufferedBytes) {
                boolean wasReturned = bufferPool.offer(buffer);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("return buffer to pool. result=" + wasReturned);
                }
                return wasReturned;
            }
            return false;
        }
    }

    protected final class ByteBufferClonerImpl
    implements ByteBufferCloner {
        protected ByteBufferClonerImpl() {
        }

        public ByteBuffer clone(ByteBuffer originalByteBuffer) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("clone buffer=" + originalByteBuffer + " maxBufferedBytes=" + maxBufferedBytes);
            }
            int size = originalByteBuffer.remaining();
            ByteBuffer clone = null;
            if (size <= maxBufferedBytes) {
                clone = bufferPool.poll();
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("clone buffer from pool=" + clone);
            }
            if (clone == null || clone.remaining() < size) {
                int allocateSize = Math.max(size, maxBufferedBytes / 2);
                clone = SocketChannelOutputBuffer.createByteBuffer(allocateSize, originalByteBuffer.isDirect());
            }
            if (originalByteBuffer == SocketChannelOutputBuffer.this.outputByteBuffer) {
                SocketChannelOutputBuffer.this.outputByteBuffer = clone;
                SocketChannelOutputBuffer.this.outputByteBuffer.limit(SocketChannelOutputBuffer.this.outputByteBuffer.position());
                clone = originalByteBuffer;
            } else {
                clone.put(originalByteBuffer);
                clone.flip();
            }
            return clone;
        }
    }

    private final class NIOOutputStream
    extends OutputStream {
        private NIOOutputStream() {
        }

        public void write(byte[] b, int off, int len) throws IOException {
            SocketChannelOutputBuffer.this.realWriteBytes(b, off, len);
        }

        public void write(int b) throws IOException {
            this.write((byte)b);
        }

        public void write(byte b) throws IOException {
            if (!SocketChannelOutputBuffer.this.outputByteBuffer.hasRemaining()) {
                ByteBuffer tmp = ByteBuffer.allocate(SocketChannelOutputBuffer.this.outputByteBuffer.capacity() * 2);
                SocketChannelOutputBuffer.this.outputByteBuffer.flip();
                tmp.put(SocketChannelOutputBuffer.this.outputByteBuffer);
                SocketChannelOutputBuffer.this.outputByteBuffer = tmp;
            }
            SocketChannelOutputBuffer.this.outputByteBuffer.put(b);
        }
    }
}

