/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http;

import com.sun.grizzly.http.HttpWorkerThread;
import com.sun.grizzly.http.ThreadPoolStatistic;
import com.sun.grizzly.util.DefaultThreadPool;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class StatsThreadPool
extends DefaultThreadPool {
    protected int port;
    protected transient ThreadPoolStatistic threadPoolStat;

    public StatsThreadPool() {
        this(DEFAULT_MAX_TASKS_QUEUED);
    }

    public StatsThreadPool(int maxTasksCount) {
        this(DEFAULT_MIN_THREAD_COUNT, DEFAULT_MAX_THREAD_COUNT, maxTasksCount, DEFAULT_IDLE_THREAD_KEEPALIVE_TIMEOUT, TimeUnit.MILLISECONDS);
    }

    public StatsThreadPool(int corePoolSize, int maximumPoolSize, int maxTasksCount, long keepAliveTime, TimeUnit unit) {
        this("Grizzly", corePoolSize, maximumPoolSize, maxTasksCount, keepAliveTime, unit);
    }

    public StatsThreadPool(String name, int corePoolSize, int maximumPoolSize, int maxTasksCount, long keepAliveTime, TimeUnit unit) {
        super(name, corePoolSize, maximumPoolSize, keepAliveTime, unit, null, new LinkedBlockingQueue(maxTasksCount));
        this.setThreadFactory(new HttpWorkerThreadFactory());
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setStatistic(ThreadPoolStatistic threadPoolStatistic) {
        this.threadPoolStat = threadPoolStatistic;
    }

    public ThreadPoolStatistic getStatistic() {
        return this.threadPoolStat;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(512);
        builder.append("StatsThreadPool[");
        this.injectToStringAttributes(builder);
        builder.append(']');
        return builder.toString();
    }

    protected void injectToStringAttributes(StringBuilder sb) {
        super.injectToStringAttributes(sb);
        sb.append(", port=").append(this.port);
    }

    protected class HttpWorkerThreadFactory
    implements ThreadFactory {
        protected HttpWorkerThreadFactory() {
        }

        public Thread newThread(final Runnable r) {
            return AccessController.doPrivileged(new PrivilegedAction<Thread>(){

                @Override
                public Thread run() {
                    HttpWorkerThread thread = new HttpWorkerThread((ExecutorService)((Object)StatsThreadPool.this), StatsThreadPool.this.name + "-" + StatsThreadPool.this.port + "-WorkerThread(" + StatsThreadPool.this.workerThreadCounter.getAndIncrement() + ")", r, StatsThreadPool.this.initialByteBufferSize);
                    ((Thread)((Object)thread)).setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)((Object)StatsThreadPool.this));
                    ((Thread)((Object)thread)).setPriority(StatsThreadPool.this.priority);
                    ((Thread)((Object)thread)).setContextClassLoader(HttpWorkerThreadFactory.class.getClassLoader());
                    return thread;
                }
            });
        }
    }
}

