/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.enterprise.iiop.api;

import java.nio.channels.SelectableChannel;
import java.rmi.Remote;
import java.util.Properties;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.api.naming.GlassfishNamingManager;
import org.glassfish.enterprise.iiop.api.GlassFishORBFactory;
import org.glassfish.enterprise.iiop.api.ORBLazyServiceInitializer;
import org.glassfish.enterprise.iiop.api.ProtocolManager;
import org.glassfish.internal.api.ORBLocator;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;
import org.omg.CORBA.ORB;
import org.omg.PortableInterceptor.ServerRequestInfo;

@Service
public class GlassFishORBHelper
implements PostConstruct,
ORBLocator {
    @Inject
    private Habitat habitat;
    @Inject
    private ProcessEnvironment processEnv;
    private GlassFishORBFactory orbFactory;
    private volatile ORB orb;
    private volatile ProtocolManager protocolManager;
    private ORBLazyServiceInitializer lazyServiceInitializer;
    private SelectableChannelDelegate selectableChannelDelegate;

    public void postConstruct() {
        this.orbFactory = (GlassFishORBFactory)this.habitat.getByContract(GlassFishORBFactory.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ORB getORB() {
        if (this.orb == null) {
            GlassFishORBHelper glassFishORBHelper = this;
            synchronized (glassFishORBHelper) {
                if (this.orb == null) {
                    try {
                        Properties props = new Properties();
                        this.orb = this.orbFactory.createORB(props);
                        if (this.processEnv.getProcessType() == ProcessEnvironment.ProcessType.Server) {
                            ProtocolManager tempProtocolManager = (ProtocolManager)this.habitat.getByContract(ProtocolManager.class);
                            tempProtocolManager.initialize(this.orb);
                            tempProtocolManager.initializeNaming();
                            tempProtocolManager.initializePOAs();
                            this.protocolManager = tempProtocolManager;
                            GlassfishNamingManager namingManager = (GlassfishNamingManager)this.habitat.getByContract(GlassfishNamingManager.class);
                            Remote remoteSerialProvider = namingManager.initializeRemoteNamingSupport(this.orb);
                            this.protocolManager.initializeRemoteNaming(remoteSerialProvider);
                        }
                    }
                    catch (Exception e) {
                        this.orb = null;
                        this.protocolManager = null;
                        throw new RuntimeException("Orb initialization erorr", e);
                    }
                }
            }
        }
        return this.orb;
    }

    public void setSelectableChannelDelegate(SelectableChannelDelegate d) {
        this.selectableChannelDelegate = d;
    }

    public SelectableChannelDelegate getSelectableChannelDelegate() {
        return this.selectableChannelDelegate;
    }

    public ProtocolManager getProtocolManager() {
        if (this.processEnv.getProcessType() != ProcessEnvironment.ProcessType.Server) {
            return null;
        }
        if (this.protocolManager == null) {
            this.getORB();
        }
        return this.protocolManager;
    }

    public boolean isORBInitialized() {
        return this.orb != null;
    }

    public int getOTSPolicyType() {
        return this.orbFactory.getOTSPolicyType();
    }

    public int getCSIv2PolicyType() {
        return this.orbFactory.getCSIv2PolicyType();
    }

    public Properties getCSIv2Props() {
        return this.orbFactory.getCSIv2Props();
    }

    public void setCSIv2Prop(String name, String value) {
        this.orbFactory.setCSIv2Prop(name, value);
    }

    public int getORBInitialPort() {
        return this.orbFactory.getORBInitialPort();
    }

    public String getORBHost(ORB orb) {
        return this.orbFactory.getORBHost(orb);
    }

    public int getORBPort(ORB orb) {
        return this.orbFactory.getORBPort(orb);
    }

    public boolean isEjbCall(ServerRequestInfo sri) {
        return this.orbFactory.isEjbCall(sri);
    }

    public static interface SelectableChannelDelegate {
        public void handleRequest(SelectableChannel var1);
    }
}

