/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.mejb.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.management.AttributeList;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.j2ee.Management;
import javax.management.j2ee.ManagementHome;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;
import org.glassfish.external.amx.AMXGlassfish;

public class MEJBTest {
    private final Management mMEJB;

    public MEJBTest(Management mejb) {
        this.mMEJB = mejb;
    }

    private void test() {
        try {
            this._test();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        MEJBTest.println("DONE with MEJB test.");
    }

    private void testMBean(ObjectName objectName) throws Exception {
        MEJBTest.println("");
        MEJBTest.println("" + objectName);
        Management mejb = this.mMEJB;
        MBeanInfo info = mejb.getMBeanInfo(objectName);
        String[] attrNames = MEJBTest.getAttributeNames(info.getAttributes());
        MEJBTest.println("attributes: " + MEJBTest.toString(MEJBTest.newListFromArray(attrNames), ", "));
        AttributeList list = mejb.getAttributes(objectName, attrNames);
        for (String attrName : attrNames) {
            try {
                Object value = mejb.getAttribute(objectName, attrName);
            }
            catch (Exception e) {
                MEJBTest.println("Attribute failed: " + attrName);
            }
        }
    }

    private void _test() throws Exception {
        Management mejb = this.mMEJB;
        String defaultDomain = mejb.getDefaultDomain();
        MEJBTest.println("MEJB default domain = " + defaultDomain + ", MBeanCount = " + mejb.getMBeanCount());
        String domain = AMXGlassfish.DEFAULT.amxJMXDomain();
        ObjectName pattern = MEJBTest.newObjectName(domain + ":*");
        Set items = mejb.queryNames(pattern, null);
        MEJBTest.println("Queried " + pattern + ", got mbeans: " + items.size());
        for (ObjectName objectName : items) {
            if (!mejb.isRegistered(objectName)) continue;
            this.testMBean(objectName);
        }
        MEJBTest.println("Listener are not supported, skipping.");
    }

    public static String toString(Collection<?> c, String delim) {
        StringBuffer buf = new StringBuffer();
        for (Object item : c) {
            buf.append("" + item);
            buf.append(delim);
        }
        if (c.size() != 0) {
            buf.setLength(buf.length() - delim.length());
        }
        return buf.toString();
    }

    public static <T> List<T> newListFromArray(T[] items) {
        ArrayList<T> list = new ArrayList<T>();
        for (int i = 0; i < items.length; ++i) {
            list.add(items[i]);
        }
        return list;
    }

    public static String[] getAttributeNames(MBeanAttributeInfo[] infos) {
        String[] names = new String[infos.length];
        for (int i = 0; i < infos.length; ++i) {
            names[i] = infos[i].getName();
        }
        return names;
    }

    static ObjectName newObjectName(String name) {
        try {
            return new ObjectName(name);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static void main(String[] args) {
        try {
            String mejbName = "java:global/mejb/MEJBBean";
            String username = "admin";
            String password = "changeit";
            System.out.println("Authenticating with \"admin\", \"changeit\"");
            Properties props = new Properties();
            props.setProperty("java.naming.factory.initial", "com.sun.enterprise.naming.SerialInitContextFactory");
            props.setProperty("org.omg.CORBA.ORBInitialHost", "localhost");
            props.setProperty("org.omg.CORBA.ORBInitialPort", "3700");
            props.setProperty("java.naming.security.principal", "admin");
            props.setProperty("java.naming.security.credentials", "changeit");
            InitialContext initial = new InitialContext(props);
            MEJBTest.println("Looking up: java:global/mejb/MEJBBean");
            Object objref = initial.lookup("java:global/mejb/MEJBBean");
            ManagementHome home = (ManagementHome)PortableRemoteObject.narrow((Object)objref, ManagementHome.class);
            try {
                ManagementHome home2 = (ManagementHome)objref;
            }
            catch (Exception e) {
                MEJBTest.println("WARNING: (ManagementHome)PortableRemoteObject.narrow(objref, ManagementHome.class) works, but (ManagementHome)objref does not!");
            }
            Management mejb = home.create();
            MEJBTest.println("Got the MEJB");
            new MEJBTest(mejb).test();
            MEJBTest.println("Calling mejb.remove()");
            mejb.remove();
        }
        catch (Exception ex) {
            System.err.println("Caught an unexpected exception!");
            ex.printStackTrace();
        }
        MEJBTest.println("Exiting main() forcibly");
        System.exit(-1);
    }

    private static final void println(Object o) {
        System.out.println("" + o);
    }

    private static final class NotifListener
    implements NotificationListener {
        @Override
        public void handleNotification(Notification notif, Object handback) {
            System.out.println("NotifListener: " + notif);
        }
    }
}

