/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.v3.admin.V2DottedNameSupport;
import com.sun.enterprise.v3.common.PropsFileActionReporter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Proxy;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.external.statistics.Statistic;
import org.glassfish.external.statistics.Stats;
import org.glassfish.external.statistics.impl.StatisticImpl;
import org.glassfish.flashlight.MonitoringRuntimeDataRegistry;
import org.glassfish.flashlight.datatree.TreeNode;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.types.Property;

@Service(name="get")
@Scoped(value=PerLookup.class)
public class GetCommand
extends V2DottedNameSupport
implements AdminCommand {
    @Inject
    Domain domain;
    @Param(optional=true, defaultValue="false", shortName="m")
    Boolean monitor;
    @Param(primary=true)
    String pattern;
    @Inject(optional=true)
    private MonitoringRuntimeDataRegistry mrdr;
    private final String DOTTED_NAME = ".dotted-name";

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            PropsFileActionReporter reporter = (PropsFileActionReporter)report;
            reporter.useMainChildrenAttribute(true);
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        if (this.monitor.booleanValue()) {
            this.getMonitorAttributes(report);
            return;
        }
        if (!(this.pattern.equals("*") || this.pattern.lastIndexOf(".") != -1 && this.pattern.lastIndexOf(".") != this.pattern.length() - 1)) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage("Missing expected dotted name part");
            return;
        }
        V2DottedNameSupport.TreeNode[] parentNodes = this.getAliasedParent(this.domain, this.pattern);
        HashMap<Dom, String> dottedNames = new HashMap<Dom, String>();
        for (V2DottedNameSupport.TreeNode parentNode : parentNodes) {
            dottedNames.putAll(this.getAllDottedNodes(parentNode.node));
        }
        String prefix = "";
        if (!this.pattern.startsWith(parentNodes[0].relativeName)) {
            prefix = this.pattern.substring(0, this.pattern.indexOf(parentNodes[0].relativeName));
        }
        this.pattern = parentNodes[0].relativeName;
        Map<Dom, String> matchingNodes = this.getMatchingNodes(dottedNames, this.pattern);
        if (matchingNodes.isEmpty() && this.pattern.lastIndexOf(46) != -1) {
            matchingNodes = this.getMatchingNodes(dottedNames, this.pattern.substring(0, this.pattern.lastIndexOf(".")));
        }
        if (matchingNodes.isEmpty()) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage("Attribute \"" + this.pattern.substring(this.pattern.lastIndexOf(".") + 1, this.pattern.length()) + "\" not found.");
            return;
        }
        List<Map.Entry> matchingNodesSorted = this.sortNodesByDottedName(matchingNodes);
        boolean foundMatch = false;
        for (Map.Entry node : matchingNodesSorted) {
            if (Property.class.getName().equals(((Dom)node.getKey()).model.targetTypeName)) {
                if (!this.matches((String)node.getValue(), this.pattern)) continue;
                ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                part.setChildrenType("DottedName");
                part.setMessage(prefix + (String)node.getValue() + "=" + ((Dom)node.getKey()).attribute("value"));
                foundMatch = true;
                continue;
            }
            Map<String, String> attributes = this.getNodeAttributes((Dom)node.getKey(), this.pattern);
            TreeMap<String, String> attributesSorted = new TreeMap<String, String>(attributes);
            for (Map.Entry<String, String> name : attributesSorted.entrySet()) {
                String finalDottedName = (String)node.getValue() + "." + name.getKey();
                if (!this.matches(finalDottedName, this.pattern)) continue;
                ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                part.setChildrenType("DottedName");
                part.setMessage(prefix + (String)node.getValue() + "." + name.getKey() + "=" + name.getValue());
                foundMatch = true;
            }
        }
        if (!foundMatch) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage("No object found matching " + this.pattern);
        }
    }

    private String encode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return value;
        }
    }

    private void getMonitorAttributes(ActionReport report) {
        TreeNode parent;
        if (this.pattern == null || this.pattern.equals("")) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage("match pattern is invalid or null");
            return;
        }
        if (this.mrdr == null) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage("monitoring facility not installed");
            return;
        }
        TreeNode tn = this.mrdr.get("server");
        if (tn == null) {
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            return;
        }
        TreeMap map = new TreeMap();
        ArrayList<TreeNode> ltn = tn.getNodes(this.pattern);
        boolean singleStat = false;
        if ((ltn == null || ltn.isEmpty()) && (parent = tn.getPossibleParentNode(this.pattern)) != null) {
            ltn = new ArrayList<TreeNode>(1);
            ltn.add(parent);
            singleStat = true;
        }
        if (!singleStat) {
            this.pattern = null;
        }
        for (TreeNode tn1 : this.sortTreeNodesByCompletePathName((List<TreeNode>)ltn)) {
            if (tn1.hasChildNodes()) continue;
            this.insertNameValuePairs(map, tn1, this.pattern);
        }
        for (Object obj : map.keySet()) {
            ActionReport.MessagePart part = report.getTopMessagePart().addChild();
            part.setMessage(obj + " = " + map.get(obj));
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private void insertNameValuePairs(TreeMap map, TreeNode tn1, String exactMatch) {
        String name = tn1.getCompletePathName();
        Object value = tn1.getValue();
        if (tn1.getParent() != null) {
            map.put(tn1.getParent().getCompletePathName() + ".dotted-name", tn1.getParent().getCompletePathName());
        }
        if (value instanceof Stats) {
            for (Statistic s : ((Stats)value).getStatistics()) {
                this.addStatisticInfo(s, name + "." + s.getName(), map);
            }
        } else if (value instanceof Statistic) {
            this.addStatisticInfo(value, name, map);
        } else {
            map.put(name, value);
        }
        if (exactMatch != null) {
            Object val = map.get(exactMatch);
            map.clear();
            if (val != null) {
                map.put(exactMatch, val);
            }
        }
    }

    private void addStatisticInfo(Object value, String name, TreeMap map) {
        Map statsMap = Proxy.isProxyClass(value.getClass()) ? ((StatisticImpl)Proxy.getInvocationHandler(value)).getStaticAsMap() : ((StatisticImpl)value).getStaticAsMap();
        for (String attrName : statsMap.keySet()) {
            Object attrValue = statsMap.get(attrName);
            map.put(name + "-" + attrName, attrValue);
        }
    }
}

