/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl.monitor.stats;

import org.glassfish.external.probe.provider.annotations.ProbeListener;
import org.glassfish.external.probe.provider.annotations.ProbeParam;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.external.statistics.impl.CountStatisticImpl;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;

@AMXMetadata(type="thread-pool-mon", group="monitoring")
@ManagedObject
@Description(value="Thread Pool Statistics")
public class ThreadPoolStatsProvider {
    private final String name;
    private final CountStatisticImpl totalExecutedTasksCount = new CountStatisticImpl("TotalExecutedTasksCount", "count", "Total number of tasks, which were executed by the thread-pool");
    private final CountStatisticImpl currentThreadPoolSize = new CountStatisticImpl("CurrentThreadPoolSize", "count", "Current number of threads running by the thread-pool");
    private final CountStatisticImpl numberOfActiveThreads = new CountStatisticImpl("NumberOfActiveThreads", "count", "Number of threads, which are currently executing tasks");

    public ThreadPoolStatsProvider(String name) {
        this.name = name;
    }

    @ManagedAttribute(id="totalexecutedtasks")
    @Description(value="Total number of tasks, which were executed by the thread-pool")
    public CountStatistic getTotalExecutedTasksCount() {
        return this.totalExecutedTasksCount;
    }

    @ManagedAttribute(id="currentthreadpoolsize")
    @Description(value="Current number of threads running by the thread-pool")
    public CountStatistic getCurrentThreadPoolSize() {
        return this.currentThreadPoolSize;
    }

    @ManagedAttribute(id="numberofactivethreads")
    @Description(value="Number of threads, which are currently executing tasks")
    public CountStatistic getNumberOfActiveThreads() {
        return this.numberOfActiveThreads;
    }

    @ProbeListener(value="glassfish:kernel:thread-pool:newThreadsAllocatedEvent")
    public void newThreadsAllocatedEvent(@ProbeParam(value="threadPoolName") String threadPoolName, @ProbeParam(value="increment") int increment, @ProbeParam(value="startThread") boolean startThread) {
        if (this.name.equals(threadPoolName)) {
            this.currentThreadPoolSize.increment();
        }
    }

    @ProbeListener(value="glassfish:kernel:thread-pool:threadDispatchedFromPoolEvent")
    public void threadDispatchedFromPoolEvent(@ProbeParam(value="threadPoolName") String threadPoolName, @ProbeParam(value="threadId") String threadId) {
        if (this.name.equals(threadPoolName)) {
            this.numberOfActiveThreads.increment();
        }
    }

    @ProbeListener(value="glassfish:kernel:thread-pool:threadReturnedToPoolEvent")
    public void threadReturnedToPoolEvent(@ProbeParam(value="threadPoolName") String threadPoolName, @ProbeParam(value="threadId") String threadId) {
        if (this.name.equals(threadPoolName)) {
            this.totalExecutedTasksCount.increment();
            this.numberOfActiveThreads.decrement();
        }
    }
}

