/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.handlers;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import com.sun.webui.jsf.component.Calendar;
import com.sun.webui.jsf.component.DropDown;
import com.sun.webui.jsf.component.Field;
import com.sun.webui.jsf.component.Hyperlink;
import com.sun.webui.jsf.model.Option;
import com.sun.webui.jsf.model.OptionGroup;
import com.sun.webui.jsf.model.UploadedFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.V3AMX;
import org.glassfish.admingui.util.SunOptionUtil;

public class WoodstockHandler {
    private Option[] jumpMenuOptions = null;

    public static void uploadFileToTempDir(HandlerContext handlerCtx) {
        UploadedFile uploadedFile = (UploadedFile)handlerCtx.getInputValue("file");
        File tmpFile = null;
        String uploadTmpFile = "";
        if (uploadedFile != null) {
            int index;
            String name = uploadedFile.getOriginalName();
            int lastIndex = name.lastIndexOf("\\");
            if (lastIndex != -1) {
                name = name.substring(lastIndex + 1, name.length());
            }
            if ((index = name.indexOf(".")) <= 0) {
                String mesg = GuiUtil.getMessage((String)"msg.deploy.nullArchiveError");
                GuiUtil.handleError((HandlerContext)handlerCtx, (String)mesg);
                return;
            }
            String suffix = name.substring(index);
            String prefix = name.substring(0, index);
            handlerCtx.setOutputValue("origPath", (Object)prefix);
            try {
                if (prefix.length() <= 2) {
                    prefix = prefix + new Random().nextInt(100000);
                }
                tmpFile = File.createTempFile(prefix, suffix);
                tmpFile.deleteOnExit();
                uploadedFile.write(tmpFile);
                uploadTmpFile = tmpFile.getCanonicalPath();
            }
            catch (IOException ioex) {
                try {
                    uploadTmpFile = tmpFile.getAbsolutePath();
                }
                catch (Exception ex) {}
            }
            catch (Exception ex) {
                GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
            }
        }
        handlerCtx.setOutputValue("uploadedTempFile", (Object)uploadTmpFile);
    }

    public static void setDisableConnectionPoolTableField(HandlerContext handlerCtx) {
        String methodValue = (String)handlerCtx.getInputValue("methodValue");
        DropDown tableDD = (DropDown)handlerCtx.getInputValue("tableDD");
        Field validationField = (Field)handlerCtx.getInputValue("validationField");
        if ("table".equals(methodValue)) {
            tableDD.setDisabled(false);
            validationField.setDisabled(true);
        } else if ("custom-validation".equals(methodValue)) {
            tableDD.setDisabled(true);
            validationField.setDisabled(false);
        } else {
            tableDD.setDisabled(true);
            validationField.setDisabled(true);
        }
    }

    public static void createHyperlinkArray(HandlerContext handlerCtx) {
        FacesContext ctx = handlerCtx.getFacesContext();
        ExternalContext extCtx = ctx.getExternalContext();
        Map reqParams = extCtx.getRequestParameterValuesMap();
        String[] linkText = (String[])reqParams.get("text");
        String[] linkUrl = (String[])reqParams.get("urls");
        if (linkText == null) {
            return;
        }
        int len = linkText.length;
        Hyperlink[] arr = new Hyperlink[len];
        String url = null;
        String ctxPath = extCtx.getRequestContextPath();
        int ctxPathSize = ctxPath.length();
        for (int idx = 0; idx < len; ++idx) {
            arr[idx] = new Hyperlink();
            arr[idx].setId("bcLnk" + idx);
            arr[idx].setRendererType("com.sun.webui.jsf.Hyperlink");
            arr[idx].setText((Object)linkText[idx]);
            url = linkUrl[idx];
            if (url.startsWith(ctxPath)) {
                url = url.substring(ctxPathSize);
            }
            arr[idx].setUrl(url);
        }
        handlerCtx.setOutputValue("links", (Object)arr);
    }

    public static void dummyHyperlinkArray(HandlerContext handlerCtx) {
        Hyperlink[] arr = new Hyperlink[]{new Hyperlink()};
        arr[0].setText((Object)">");
        handlerCtx.setOutputValue("links", (Object)arr);
    }

    public static void StringArrayToSelectItemArray(HandlerContext handlerCtx) {
        String[] stringArray = (String[])handlerCtx.getInputValue("stringArray");
        handlerCtx.setOutputValue("item", (Object)SunOptionUtil.getOptions(stringArray));
    }

    public static void StringToSelectItemArray(HandlerContext handlerCtx) {
        String string = (String)handlerCtx.getInputValue("string");
        if (string.startsWith("[")) {
            string = string.substring(1);
        }
        if (string.endsWith("]")) {
            string = string.substring(0, string.length() - 1);
        }
        String[] stringArray = string.split(",");
        handlerCtx.setOutputValue("item", (Object)SunOptionUtil.getOptions(stringArray));
    }

    public static void selectItemArrayToStrArray(HandlerContext handlerCtx) {
        SelectItem[] item = (SelectItem[])handlerCtx.getInputValue("item");
        if (item == null || item.length == 0) {
            handlerCtx.setOutputValue("strAry", (Object)new String[0]);
            return;
        }
        String[] strAry = new String[item.length];
        for (int i = 0; i < item.length; ++i) {
            strAry[i] = (String)item[i].getValue();
        }
        handlerCtx.setOutputValue("strAry", (Object)strAry);
    }

    public static void getDatePattern(HandlerContext handlerCtx) {
        Calendar calendar = (Calendar)handlerCtx.getInputValue("calendarComponent");
        String pattern = calendar.getDateFormatPattern();
        if (!(pattern != null && pattern.length() != 0 || (pattern = calendar.getDatePicker().getDateFormatPattern()) != null && pattern.length() != 0)) {
            pattern = "MM/dd/yyyy";
        }
        handlerCtx.setOutputValue("pattern", (Object)pattern);
    }

    public void populateServerMonitorDropDown(HandlerContext handlerCtx) {
        String name;
        List vsList = (List)handlerCtx.getInputValue("VSList");
        List threadList = (List)handlerCtx.getInputValue("ThreadSystemList");
        ArrayList<Object> menuList = new ArrayList<Object>();
        menuList.add(new Option((Object)"", ""));
        ListIterator vs = vsList.listIterator();
        while (vs.hasNext()) {
            Option[] groupedOptions1 = new Option[]{};
            OptionGroup jumpGroup1 = new OptionGroup();
            ArrayList<Option> optionList = new ArrayList<Option>();
            name = (String)vs.next();
            jumpGroup1.setLabel(name);
            optionList.add(new Option((Object)name, name));
            String listeners = (String)V3AMX.getAttribute((Object)("amx:pp=/domain/configs/config[server-config]/http-service,type=virtual-server,name=" + name), (String)"NetworkListeners");
            if (listeners != null) {
                StringTokenizer tokens = new StringTokenizer(listeners, ",");
                while (tokens.hasMoreTokens()) {
                    String token = tokens.nextToken().trim();
                    optionList.add(new Option((Object)token, token));
                }
                groupedOptions1 = optionList.toArray(new Option[optionList.size()]);
            }
            jumpGroup1.setOptions(groupedOptions1);
            menuList.add(jumpGroup1);
        }
        ArrayList<Option> tList = new ArrayList<Option>();
        Option[] groupedOptions2 = new Option[]{};
        ListIterator tl = threadList.listIterator();
        tList.add(new Option((Object)"thread-system", "thead-system"));
        while (tl.hasNext()) {
            name = (String)tl.next();
            tList.add(new Option((Object)name, name));
        }
        groupedOptions2 = tList.toArray(new Option[tList.size()]);
        OptionGroup jumpGroup2 = new OptionGroup();
        jumpGroup2.setLabel("thread-system");
        jumpGroup2.setOptions(groupedOptions2);
        menuList.add(jumpGroup2);
        this.jumpMenuOptions = menuList.toArray(new Option[menuList.size()]);
        handlerCtx.setOutputValue("MonitorList", (Object)this.jumpMenuOptions);
    }

    public void populateResourceMonitorDropDown(HandlerContext handlerCtx) {
        List rList = (List)handlerCtx.getInputValue("ResourceList");
        ArrayList<OptionGroup> menuList = new ArrayList<OptionGroup>();
        ArrayList<Option> resList = new ArrayList<Option>();
        Option[] groupedOptions1 = new Option[]{};
        String firstItem = null;
        if (rList != null) {
            ListIterator rl = rList.listIterator();
            while (rl.hasNext()) {
                String name = (String)rl.next();
                resList.add(new Option((Object)name, name));
                if (firstItem != null) continue;
                firstItem = name;
            }
        }
        groupedOptions1 = resList.toArray(new Option[resList.size()]);
        OptionGroup jumpGroup1 = new OptionGroup();
        jumpGroup1.setLabel("resources");
        jumpGroup1.setOptions(groupedOptions1);
        menuList.add(jumpGroup1);
        this.jumpMenuOptions = menuList.toArray(new Option[menuList.size()]);
        handlerCtx.setOutputValue("MonitorList", (Object)this.jumpMenuOptions);
        handlerCtx.setOutputValue("FirstItem", (Object)firstItem);
    }

    public void populateApplicationsMonitorDropDown(HandlerContext handlerCtx) {
        OptionGroup bmOptions;
        OptionGroup bpOptions;
        OptionGroup bcOptions;
        OptionGroup ejbTimerOptions;
        List aList = (List)handlerCtx.getInputValue("AppsList");
        ArrayList<OptionGroup> menuList = new ArrayList<OptionGroup>();
        ArrayList<Option> appsList = new ArrayList<Option>();
        Option[] groupedOptions1 = new Option[]{};
        String firstItem = null;
        if (aList != null) {
            ListIterator al = aList.listIterator();
            while (al.hasNext()) {
                String name = (String)al.next();
                appsList.add(new Option((Object)name, name));
                if (firstItem != null) continue;
                firstItem = name;
            }
        }
        groupedOptions1 = appsList.toArray(new Option[appsList.size()]);
        OptionGroup jumpGroup1 = new OptionGroup();
        jumpGroup1.setLabel("applications");
        jumpGroup1.setOptions(groupedOptions1);
        menuList.add(jumpGroup1);
        OptionGroup ejbAppOptions = WoodstockHandler.setEjbGroupOptions("ejb-application-mon", "ejb-application-info");
        if (ejbAppOptions != null) {
            menuList.add(ejbAppOptions);
        }
        if ((ejbTimerOptions = WoodstockHandler.setEjbGroupOptions("ejb-timed-object-mon", "ejb-timer")) != null) {
            menuList.add(ejbTimerOptions);
        }
        if ((bcOptions = WoodstockHandler.setEjbGroupOptions("bean-cache-mon", "bean-cache")) != null) {
            menuList.add(bcOptions);
        }
        if ((bpOptions = WoodstockHandler.setEjbGroupOptions("bean-pool-mon", "bean-pool")) != null) {
            menuList.add(bpOptions);
        }
        if ((bmOptions = WoodstockHandler.setEjbGroupOptions("bean-method-mon", "bean-methods")) != null) {
            menuList.add(bmOptions);
        }
        this.jumpMenuOptions = menuList.toArray(new Option[menuList.size()]);
        handlerCtx.setOutputValue("MonitorList", (Object)this.jumpMenuOptions);
        handlerCtx.setOutputValue("FirstItem", (Object)firstItem);
    }

    public static OptionGroup setEjbGroupOptions(String type, String label) {
        List nameList = V3AMX.getProxyListByType((String)type);
        if (nameList != null && nameList.size() != 0) {
            ArrayList<Option> nList = new ArrayList<Option>();
            ListIterator nl = nameList.listIterator();
            while (nl.hasNext()) {
                String name = (String)nl.next();
                nList.add(new Option((Object)name, name));
            }
            Option[] groupedOptions = new Option[]{};
            groupedOptions = nList.toArray(new Option[nList.size()]);
            OptionGroup jumpGroup = new OptionGroup();
            jumpGroup.setLabel(label);
            jumpGroup.setOptions(groupedOptions);
            return jumpGroup;
        }
        return null;
    }

    public static Boolean doesAppProxyExit(String name, String type) {
        List proxyList = V3AMX.getProxyListByType((String)type);
        boolean proxyexist = false;
        if (proxyList != null && proxyList.size() != 0) {
            ListIterator li = proxyList.listIterator();
            while (li.hasNext()) {
                String pname = (String)li.next();
                if (!pname.startsWith(name)) continue;
                proxyexist = true;
            }
        }
        return proxyexist;
    }
}

