/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jts.admin.cli;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.i18n.StringManager;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.transaction.api.ResourceRecoveryManager;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="recover-transactions")
@Scoped(value=PerLookup.class)
@I18n(value="recover.transactions")
public class RecoverTransactions
implements AdminCommand {
    private static StringManager localStrings = StringManager.getManager(RecoverTransactions.class);
    @Param(name="transactionlogdir", optional=true)
    String transactionLogDir;
    @Param(name="destination", optional=true)
    String destinationServer;
    @Param(name="server_name", primary=true)
    String serverToRecover;
    @Inject
    ResourceRecoveryManager recoveryManager;
    @Inject
    ServerContext _serverContext;
    @Inject
    Domain domain;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        if (this.domain.getServerNamed(this.serverToRecover) == null) {
            report.setMessage(localStrings.getString("recover.transactions.serverBeRecoveredIsNotKnown", (Object)this.serverToRecover));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
        if (this.isServerRunning(this.serverToRecover)) {
            if (this.destinationServer != null && !this.serverToRecover.equals(this.destinationServer)) {
                report.setMessage(localStrings.getString("recover.transactions.runningServerBeRecoveredFromAnotherServer", (Object)this.serverToRecover, (Object)this.destinationServer));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            }
            if (this.transactionLogDir != null) {
                report.setMessage(localStrings.getString("recover.transactions.logDirShouldNotBeSpecifiedForSelfRecovery"));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            }
        } else if (this.destinationServer == null) {
            report.setMessage(localStrings.getString("recover.transactions.noDestinationServer"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        } else if (!this.isServerRunning(this.destinationServer)) {
            report.setMessage(localStrings.getString("recover.transactions.destinationServerIsNotAlive", (Object)this.serverToRecover));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        } else if (this.transactionLogDir == null) {
            report.setMessage(localStrings.getString("recover.transactions.logDirNotSpecifiedForDelegatedRecovery"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
        if (this.destinationServer == null) {
            this.destinationServer = this.serverToRecover;
        }
        try {
            boolean result = !this.destinationServer.equals(this._serverContext.getInstanceName()) ? this.recoveryManager.recoverIncompleteTx(true, this.transactionLogDir) : this.recoveryManager.recoverIncompleteTx(false, null);
            if (!result) {
                throw new IllegalStateException();
            }
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (Exception e) {
            report.setMessage(localStrings.getString("recover.transactions.failed"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
    }

    private boolean isServerRunning(String serverName) {
        return true;
    }
}

