/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.layout;

import com.sun.jsftemplating.el.PageSessionResolver;
import com.sun.jsftemplating.layout.LayoutDefinitionException;
import com.sun.jsftemplating.layout.LayoutDefinitionManager;
import com.sun.jsftemplating.layout.ViewRootUtil;
import com.sun.jsftemplating.layout.descriptors.LayoutComponent;
import com.sun.jsftemplating.layout.descriptors.LayoutComposition;
import com.sun.jsftemplating.layout.descriptors.LayoutDefine;
import com.sun.jsftemplating.layout.descriptors.LayoutDefinition;
import com.sun.jsftemplating.layout.descriptors.LayoutElement;
import com.sun.jsftemplating.layout.descriptors.LayoutFacet;
import com.sun.jsftemplating.layout.descriptors.LayoutInsert;
import com.sun.jsftemplating.layout.descriptors.Resource;
import com.sun.jsftemplating.util.LogUtil;
import com.sun.jsftemplating.util.SimplePatternMatcher;
import com.sun.jsftemplating.util.TypeConversion;
import com.sun.jsftemplating.util.TypeConverter;
import com.sun.jsftemplating.util.UIComponentTypeConversion;
import com.sun.jsftemplating.util.fileStreamer.FacesStreamerContext;
import com.sun.jsftemplating.util.fileStreamer.FileStreamer;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.faces.FactoryFinder;
import javax.faces.application.StateManager;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutViewHandler
extends ViewHandler {
    public static final String AJAX_REQ_KEY = "ajaxReq";
    public static final String RESTORE_VIEW_ID = "_resViewID";
    public static final String DEFAULT_RESOURCE_PREFIX = "/resource";
    public static final String RESOURCE_PREFIX = "com.sun.jsftemplating.RESOURCE_PREFIX";
    private Set<String> _resourcePrefix = null;
    private ViewHandler _oldViewHandler = null;
    static final String AJAX_REQ_TARGET_KEY = "_ajaxReqTarget";
    private static final String VIEW_MAPPINGS = "com.sun.jsftemplating.VIEW_MAPPINGS";
    private static final TypeConversion UICOMPONENT_TYPE_CONVERSION = new UIComponentTypeConversion();
    private Collection<SimplePatternMatcher> _viewMappings = null;
    public static final String ENCODING_TYPE = "com.sun.jsftemplating.ENCODING";

    public LayoutViewHandler(ViewHandler oldViewHandler) {
        this._oldViewHandler = oldViewHandler;
        LayoutDefinitionManager.clearGlobalComponentTypes(null);
        LayoutDefinitionManager.clearGlobalHandlerDefinitions(null);
        LayoutDefinitionManager.clearGlobalResources(null);
    }

    public UIViewRoot createView(FacesContext context, String viewId) {
        String path = this.getResourcePath(viewId);
        if (path != null) {
            return LayoutViewHandler.serveResource(context, path);
        }
        if (!this.isMappedView(viewId)) {
            UIViewRoot viewRoot = this._oldViewHandler.createView(context, viewId);
            return viewRoot;
        }
        Locale locale = null;
        String renderKitId = null;
        if (context.getViewRoot() != null) {
            UIViewRoot oldViewRoot = context.getViewRoot();
            LayoutDefinition oldLD = ViewRootUtil.getLayoutDefinition(oldViewRoot);
            if (oldLD != null && oldViewRoot.getViewId().equals(viewId)) {
                oldLD.setInitPageExecuted(context, Boolean.FALSE);
            }
            locale = context.getViewRoot().getLocale();
            renderKitId = context.getViewRoot().getRenderKitId();
        }
        UIViewRoot viewRoot = this._oldViewHandler.createView(context, viewId);
        viewRoot.setViewId(viewId);
        ViewRootUtil.setLayoutDefinitionKey(viewRoot, viewId);
        if (locale == null) {
            locale = this.calculateLocale(context);
        }
        viewRoot.setLocale(locale);
        if (renderKitId == null) {
            renderKitId = this.calculateRenderKitId(context);
        }
        viewRoot.setRenderKitId(renderKitId);
        UIViewRoot currentViewRoot = context.getViewRoot();
        context.setViewRoot(viewRoot);
        LayoutDefinition def = null;
        try {
            def = ViewRootUtil.getLayoutDefinition(viewRoot);
        }
        catch (LayoutDefinitionException ex) {
            if (LogUtil.configEnabled()) {
                LogUtil.config("JSFT0005", viewId);
                if (LogUtil.finestEnabled()) {
                    LogUtil.finest("File (" + viewId + ") not found!", ex);
                }
            }
            if (currentViewRoot != null) {
                context.setViewRoot(currentViewRoot);
            }
            return this._oldViewHandler.createView(context, viewId);
        }
        catch (RuntimeException ex) {
            if (currentViewRoot != null) {
                context.setViewRoot(currentViewRoot);
            }
            throw ex;
        }
        viewRoot = context.getViewRoot();
        if (def != null && !context.getResponseComplete()) {
            Iterator<Resource> it = def.getResources().iterator();
            Resource resource = null;
            while (it.hasNext()) {
                resource = it.next();
                resource.getFactory().getResource(context, resource);
            }
            if (LayoutDefinitionManager.isDebug(context)) {
                LayoutViewHandler.getClientIdMap(context).clear();
            }
            LayoutViewHandler.buildUIComponentTree(context, (UIComponent)viewRoot, def);
        }
        if (currentViewRoot != null) {
            context.setViewRoot(currentViewRoot);
        }
        return viewRoot;
    }

    private boolean isMappedView(String viewId) {
        if (this._viewMappings == null) {
            String initParam = (String)FacesContext.getCurrentInstance().getExternalContext().getInitParameterMap().get(VIEW_MAPPINGS);
            this._viewMappings = SimplePatternMatcher.parseMultiPatternString(initParam, ";");
        }
        if (this._viewMappings.isEmpty()) {
            return true;
        }
        for (SimplePatternMatcher mapping : this._viewMappings) {
            if (!mapping.matches(viewId)) continue;
            return true;
        }
        return false;
    }

    public static UIViewRoot serveResource(FacesContext context, String path) {
        UIViewRoot root;
        block11: {
            context.responseComplete();
            root = new UIViewRoot();
            root.setRenderKitId("dummy");
            FacesStreamerContext fsContext = new FacesStreamerContext(context);
            fsContext.setAttribute("filePath", path);
            Object obj = context.getExternalContext().getResponse();
            HttpServletResponse resp = null;
            if (obj instanceof HttpServletResponse) {
                resp = (HttpServletResponse)obj;
                long mod = fsContext.getContentSource().getLastModified(fsContext);
                if (mod != -1L) {
                    long ifModifiedSince = ((HttpServletRequest)context.getExternalContext().getRequest()).getDateHeader("If-Modified-Since");
                    if (ifModifiedSince < mod / 1000L * 1000L) {
                        resp.setDateHeader("Last-Modified", mod);
                    } else {
                        resp.setStatus(304);
                        return root;
                    }
                }
            }
            try {
                FileStreamer.getFileStreamer(context).streamContent(fsContext);
            }
            catch (FileNotFoundException ex) {
                if (LogUtil.infoEnabled()) {
                    LogUtil.info("JSFT0004", path);
                }
                if (resp != null) {
                    try {
                        resp.sendError(404);
                    }
                    catch (IOException ioEx) {}
                }
            }
            catch (IOException ex) {
                if (!LogUtil.infoEnabled()) break block11;
                LogUtil.info("JSFT0004", path);
                if (!LogUtil.fineEnabled()) break block11;
                LogUtil.fine("Resource (" + path + ") not available!", ex);
            }
        }
        return root;
    }

    public static String getEncoding(FacesContext ctx) {
        if (ctx == null) {
            return null;
        }
        String encType = null;
        UIViewRoot root = ctx.getViewRoot();
        Map<String, Serializable> map = PageSessionResolver.getPageSession(ctx, root);
        if (map != null) {
            encType = (String)((Object)map.get(ENCODING_TYPE));
        }
        if (encType == null || encType.equals("")) {
            encType = ctx.getExternalContext().getInitParameter(ENCODING_TYPE);
        }
        if (encType == null || encType.equals("")) {
            ExternalContext extCtx = ctx.getExternalContext();
            try {
                ServletRequest request = (ServletRequest)extCtx.getRequest();
                encType = request.getCharacterEncoding();
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (encType == null || encType.equals("")) {
                encType = "UTF-8";
            }
        }
        return encType;
    }

    public String getResourcePath(String viewId) {
        ExternalContext extCtx = FacesContext.getCurrentInstance().getExternalContext();
        String servletPath = extCtx.getRequestServletPath();
        Iterator<String> it = this.getResourcePrefixes().iterator();
        while (it.hasNext()) {
            if (!servletPath.equals(it.next())) continue;
            return extCtx.getRequestPathInfo();
        }
        return null;
    }

    public Set<String> getResourcePrefixes() {
        if (this._resourcePrefix == null) {
            HashSet<String> set = new HashSet<String>();
            String initParam = (String)FacesContext.getCurrentInstance().getExternalContext().getInitParameterMap().get(RESOURCE_PREFIX);
            if (initParam != null) {
                for (String token : initParam.split(",")) {
                    set.add(token.trim());
                }
            }
            set.add(DEFAULT_RESOURCE_PREFIX);
            this._resourcePrefix = set;
        }
        return this._resourcePrefix;
    }

    public void setResourcePrefixes(Set<String> prefix) {
        this._resourcePrefix = prefix;
    }

    public static void buildUIComponentTree(FacesContext context, UIComponent parent, LayoutElement elt) {
        Iterator<LayoutElement> it = elt.getChildLayoutElements().iterator();
        UIComponent child = null;
        while (it.hasNext()) {
            LayoutElement childElt = it.next();
            if (childElt instanceof LayoutFacet) {
                if (((LayoutFacet)childElt).isRendered()) continue;
                LayoutViewHandler.buildUIComponentTree(context, parent, childElt);
                continue;
            }
            if (childElt instanceof LayoutComposition) {
                LayoutComposition compo = (LayoutComposition)childElt;
                String template = compo.getTemplate();
                if (template != null) {
                    block13: {
                        LayoutComposition.push(context, childElt);
                        try {
                            LayoutViewHandler.buildUIComponentTree(context, parent, LayoutDefinitionManager.getLayoutDefinition(context, template));
                        }
                        catch (LayoutDefinitionException ex) {
                            if (!((LayoutComposition)childElt).isRequired()) break block13;
                            throw ex;
                        }
                    }
                    LayoutComposition.pop(context);
                    continue;
                }
                LayoutViewHandler.buildUIComponentTree(context, parent, childElt);
                continue;
            }
            if (childElt instanceof LayoutInsert) {
                Stack<LayoutElement> stack = LayoutComposition.getCompositionStack(context);
                if (stack.empty()) {
                    throw new IllegalArgumentException("'ui:insert' encountered, however, no 'ui:composition' was used!");
                }
                String insertName = ((LayoutInsert)childElt).getName();
                if (insertName == null) {
                    LayoutViewHandler.buildUIComponentTree(context, parent, (LayoutElement)stack.get(0));
                    continue;
                }
                insertName = "" + ((LayoutInsert)childElt).resolveValue(context, parent, insertName);
                LayoutDefine def = LayoutInsert.findLayoutDefine(context, parent, stack, insertName);
                if (def == null) {
                    LayoutViewHandler.buildUIComponentTree(context, parent, childElt);
                    continue;
                }
                LayoutViewHandler.buildUIComponentTree(context, parent, def);
                continue;
            }
            if (childElt instanceof LayoutComponent) {
                child = ((LayoutComponent)childElt).getChild(context, parent);
                if (LayoutDefinitionManager.isDebug(context)) {
                    String id;
                    Map<String, String> idMap = LayoutViewHandler.getClientIdMap(context);
                    if (idMap.containsKey(id = child.getClientId(context))) {
                        throw new IllegalArgumentException("The clientId (" + id + ") appears more than once!  Make sure you " + "have not included multiple times in the same " + "NamingContainer.");
                    }
                    idMap.put(id, id);
                }
                LayoutViewHandler.buildUIComponentTree(context, child, childElt);
                continue;
            }
            LayoutViewHandler.buildUIComponentTree(context, parent, childElt);
        }
    }

    private static Map<String, String> getClientIdMap(FacesContext context) {
        Map reqMap = context.getExternalContext().getRequestMap();
        HashMap idMap = (HashMap)reqMap.get("__debugIdMap");
        if (idMap == null) {
            idMap = new HashMap();
            reqMap.put("__debugIdMap", idMap);
        }
        return idMap;
    }

    public UIViewRoot restoreView(FacesContext context, String viewId) {
        String key;
        Map map = context.getExternalContext().getRequestMap();
        if (map.get(RESTORE_VIEW_ID) != null) {
            return this.createView(context, viewId);
        }
        map.put(RESTORE_VIEW_ID, viewId);
        UIViewRoot root = this._oldViewHandler.restoreView(context, viewId);
        if (root != null && (key = ViewRootUtil.getLayoutDefinitionKey(root)) != null) {
            context.setViewRoot(root);
            LayoutDefinition def = ViewRootUtil.getLayoutDefinition(key);
            def.decode(context, (UIComponent)root);
        }
        return root;
    }

    public void renderView(FacesContext context, UIViewRoot viewToRender) throws IOException {
        LayoutDefinition def = ViewRootUtil.getLayoutDefinition(viewToRender);
        if (def == null) {
            this._oldViewHandler.renderView(context, viewToRender);
        } else if (!context.getPartialViewContext().isPartialRequest()) {
            ResponseWriter writer = this.setupResponseWriter(context);
            writer.startDocument();
            def.encode(context, (UIComponent)viewToRender);
            writer.endDocument();
        } else {
            def.encode(context, (UIComponent)viewToRender);
        }
    }

    private static void renderComponent(FacesContext context, UIComponent comp) throws IOException {
        if (!comp.isRendered()) {
            return;
        }
        comp.encodeBegin(context);
        if (comp.getRendersChildren()) {
            comp.encodeChildren(context);
        } else {
            UIComponent child2 = null;
            for (UIComponent child2 : comp.getChildren()) {
                LayoutViewHandler.renderComponent(context, child2);
            }
        }
        comp.encodeEnd(context);
    }

    private ResponseWriter setupResponseWriter(FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        if (writer != null) {
            return writer;
        }
        ExternalContext extCtx = context.getExternalContext();
        ServletResponse response = (ServletResponse)extCtx.getResponse();
        RenderKitFactory renderFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        RenderKit renderKit = renderFactory.getRenderKit(context, context.getViewRoot().getRenderKitId());
        String contentTypeList = null;
        String userContentType = "text/html";
        if (userContentType != null && userContentType.length() > 0) {
            response.setContentType(userContentType);
        } else {
            contentTypeList = (String)extCtx.getRequestHeaderMap().get("Accept");
            if (contentTypeList == null) {
                contentTypeList = "text/html;q=1.0";
            }
        }
        String encType = LayoutViewHandler.getEncoding(context);
        extCtx.getSessionMap().put("javax.faces.request.charset", encType);
        response.setCharacterEncoding(encType);
        writer = renderKit.createResponseWriter((Writer)new OutputStreamWriter((OutputStream)response.getOutputStream(), encType), contentTypeList, encType);
        context.setResponseWriter(writer);
        response.setContentType(writer.getContentType());
        return writer;
    }

    public void writeState(FacesContext context) throws IOException {
        UIViewRoot root = context.getViewRoot();
        if (root == null || context.getPartialViewContext().isPartialRequest() || ViewRootUtil.getLayoutDefinition(root) == null) {
            this._oldViewHandler.writeState(context);
        } else {
            StateManager stateManager = context.getApplication().getStateManager();
            StateManager.SerializedView view = stateManager.saveSerializedView(context);
            stateManager.writeState(context, view);
        }
    }

    public String getResourceURL(FacesContext context, String path) {
        return this._oldViewHandler.getResourceURL(context, path);
    }

    public String getActionURL(FacesContext context, String viewId) {
        return this._oldViewHandler.getActionURL(context, viewId);
    }

    public Locale calculateLocale(FacesContext context) {
        return this._oldViewHandler.calculateLocale(context);
    }

    public String calculateRenderKitId(FacesContext context) {
        return this._oldViewHandler.calculateRenderKitId(context);
    }

    static {
        TypeConverter.registerTypeConversion(null, UIComponent.class, UICOMPONENT_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(null, UIComponent.class.getName(), UICOMPONENT_TYPE_CONVERSION);
    }
}

