/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.mbeanserver;

import java.io.IOException;
import javax.management.MBeanServer;
import javax.management.remote.JMXAuthenticator;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXServiceURL;
import javax.security.auth.Subject;
import org.glassfish.admin.mbeanserver.BootAMXListener;
import org.jvnet.hk2.component.Habitat;

abstract class ConnectorStarter {
    protected final MBeanServer mMBeanServer;
    protected final String mAddress;
    protected final int mPort;
    protected final String mAuthRealmName;
    protected final boolean mSecurityEnabled;
    private final Habitat mHabitat;
    protected final BootAMXListener mBootListener;
    protected volatile JMXServiceURL mJMXServiceURL = null;
    protected volatile JMXConnectorServer mConnectorServer = null;

    protected static void debug(String s) {
        System.out.println(s);
    }

    public JMXServiceURL getJMXServiceURL() {
        return this.mJMXServiceURL;
    }

    ConnectorStarter(MBeanServer mbeanServer, String address, int port, String authRealmName, boolean securityEnabled, Habitat habitat, BootAMXListener bootListener) {
        this.mMBeanServer = mbeanServer;
        this.mAddress = address;
        this.mPort = port;
        this.mAuthRealmName = authRealmName;
        this.mSecurityEnabled = securityEnabled;
        this.mHabitat = habitat;
        this.mBootListener = bootListener;
        if (securityEnabled) {
            throw new IllegalArgumentException("JMXConnectorServer not yet supporting security");
        }
    }

    abstract JMXConnectorServer start() throws Exception;

    public JMXAuthenticator getAccessController() {
        return new JMXAuthenticator(){

            public Subject authenticate(Object credentials) {
                JMXAuthenticator controller = ConnectorStarter.this.mHabitat.getByContract(JMXAuthenticator.class);
                return controller.authenticate(credentials);
            }
        };
    }

    public synchronized void stop() {
        try {
            this.mConnectorServer.stop();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected static void ignore(Throwable t) {
    }
}

