/*
 * Decompiled with CFR 0.152.
 */
package com.sun.btrace.runtime;

import com.sun.btrace.org.objectweb.asm.ClassAdapter;
import com.sun.btrace.org.objectweb.asm.ClassReader;
import com.sun.btrace.org.objectweb.asm.ClassWriter;
import com.sun.btrace.org.objectweb.asm.Label;
import com.sun.btrace.org.objectweb.asm.MethodVisitor;
import com.sun.btrace.runtime.Constants;
import com.sun.btrace.runtime.InstrumentUtils;
import com.sun.btrace.runtime.MethodInstrumentor;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;

public class ErrorReturnInstrumentor
extends MethodInstrumentor {
    private Label start = new Label();
    private Label end = new Label();

    public ErrorReturnInstrumentor(MethodVisitor mv, int access, String name, String desc) {
        super(mv, access, name, desc);
    }

    @Override
    public void visitCode() {
        this.visitLabel(this.start);
        super.visitCode();
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        this.visitLabel(this.end);
        this.visitTryCatchBlock(this.start, this.end, this.end, Constants.JAVA_LANG_THROWABLE);
        this.onErrorReturn();
        this.visitInsn(191);
        super.visitMaxs(maxStack, maxLocals);
    }

    protected void onErrorReturn() {
        this.println("error return from " + this.getName() + this.getDescriptor());
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println("Usage: java com.sun.btrace.runtime.ErrorReturnInstrumentor <class>");
            System.exit(1);
        }
        args[0] = args[0].replace('.', '/');
        FileInputStream fis = new FileInputStream(args[0] + ".class");
        ClassReader reader = new ClassReader(new BufferedInputStream(fis));
        FileOutputStream fos = new FileOutputStream(args[0] + ".class");
        ClassWriter writer = InstrumentUtils.newClassWriter();
        InstrumentUtils.accept(reader, new ClassAdapter(writer){

            @Override
            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
                return new ErrorReturnInstrumentor(mv, access, name, desc);
            }
        });
        fos.write(writer.toByteArray());
    }
}

