/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.embed.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Connector;
import org.apache.catalina.Container;
import org.apache.catalina.Engine;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.startup.ContextConfig;
import org.apache.catalina.startup.Embedded;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.embedded.Port;
import org.glassfish.api.embedded.web.ConfigException;
import org.glassfish.api.embedded.web.WebBuilder;
import org.glassfish.web.embed.impl.Context;
import org.glassfish.web.embed.impl.VirtualServer;
import org.glassfish.web.embed.impl.WebListener;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class EmbeddedWebContainer
implements org.glassfish.api.embedded.web.EmbeddedWebContainer {
    @Inject
    Habitat habitat;
    private static Logger log = Logger.getLogger(EmbeddedWebContainer.class.getName());
    private VirtualServer defaultVirtualServer = null;
    private Embedded embedded = new Embedded();
    private Engine engine = null;
    private File path = null;
    private String defaultDomain = "com.sun.appserv";

    public EmbeddedWebContainer() {
        this.embedded.setUseNaming(false);
        this.engine = this.embedded.createEngine();
        this.embedded.addEngine(this.engine);
    }

    @Override
    public void setConfiguration(WebBuilder builder) {
        this.setPath(builder.getDocRootDir());
    }

    public List<Sniffer> getSniffers() {
        ArrayList<Sniffer> sniffers = new ArrayList<Sniffer>();
        sniffers.add((Sniffer)this.habitat.getComponent(Sniffer.class, "web"));
        sniffers.add((Sniffer)this.habitat.getComponent(Sniffer.class, "webbeans"));
        Sniffer security = (Sniffer)this.habitat.getComponent(Sniffer.class, "Security");
        if (security != null) {
            sniffers.add(security);
        }
        return sniffers;
    }

    public void bind(Port port, String protocol) {
    }

    @Override
    public void start() throws org.glassfish.api.embedded.LifecycleException {
        log.info("EmbeddedWebContainer is starting");
        int port = 8080;
        String webListenerId = "http-listener-1";
        String virtualServerId = "server";
        String hostName = "localhost";
        try {
            if (this.createDefaultConfig()) {
                this.engine.setName(this.defaultDomain);
                ((StandardEngine)this.engine).setDomain(this.defaultDomain);
                this.engine.setDefaultHost(virtualServerId);
                this.engine.setParentClassLoader(EmbeddedWebContainer.class.getClassLoader());
                WebListener webListener = this.createWebListener(webListenerId, WebListener.class);
                webListener.setPort(port);
                webListener.setDefaultHost(virtualServerId);
                webListener.setDomain(this.defaultDomain);
                org.glassfish.api.embedded.web.WebListener[] webListeners = new WebListener[]{webListener};
                File docRoot = this.getPath();
                this.defaultVirtualServer = (VirtualServer)this.createVirtualServer(virtualServerId, docRoot, webListeners);
                this.defaultVirtualServer.addAlias(hostName);
                this.engine.addChild(this.defaultVirtualServer);
                Context context = (Context)this.createContext(docRoot, null);
                this.defaultVirtualServer.addChild(context);
                this.embedded.addEngine(this.engine);
            }
            this.embedded.start();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new org.glassfish.api.embedded.LifecycleException((Throwable)e);
        }
    }

    @Override
    public void stop() throws org.glassfish.api.embedded.LifecycleException {
        try {
            this.embedded.stop();
        }
        catch (LifecycleException e) {
            throw new org.glassfish.api.embedded.LifecycleException((Throwable)e);
        }
    }

    @Override
    public org.glassfish.api.embedded.web.Context createContext(File docRoot, String contextRoot, ClassLoader classLoader) {
        log.info("Creating context '" + contextRoot + "' with docBase '" + docRoot.getPath() + "'");
        Context context = new Context();
        context.setDocBase(docRoot.getPath());
        context.setPath(contextRoot);
        if (classLoader != null) {
            context.setParentClassLoader(classLoader);
        } else {
            context.setParentClassLoader(Thread.currentThread().getContextClassLoader());
        }
        ContextConfig config = new ContextConfig();
        context.addLifecycleListener(config);
        this.defaultVirtualServer.addChild(context);
        return context;
    }

    @Override
    public org.glassfish.api.embedded.web.Context createContext(File docRoot, ClassLoader classLoader) {
        String contextRoot = "";
        log.info("Creating context '" + contextRoot + "' with docBase '" + docRoot.getPath() + "'");
        Context context = new Context();
        context.setDocBase(docRoot.getPath());
        context.setPath(contextRoot);
        if (classLoader != null) {
            context.setParentClassLoader(classLoader);
        } else {
            context.setParentClassLoader(Thread.currentThread().getContextClassLoader());
        }
        ContextConfig config = new ContextConfig();
        context.addLifecycleListener(config);
        return context;
    }

    @Override
    public <T extends org.glassfish.api.embedded.web.WebListener> T createWebListener(String id, Class<T> c) throws InstantiationException, IllegalAccessException {
        org.glassfish.api.embedded.web.WebListener webListener = null;
        log.info("Creating connector " + id);
        try {
            webListener = (org.glassfish.api.embedded.web.WebListener)c.newInstance();
            webListener.setId(id);
        }
        catch (Exception e) {
            log.severe("Couldn't create connector");
        }
        return (T)webListener;
    }

    @Override
    public void addWebListener(org.glassfish.api.embedded.web.WebListener webListener) throws ConfigException, org.glassfish.api.embedded.LifecycleException {
        if (this.findWebListener(webListener.getId()) != null) {
            throw new ConfigException("Connector with name '" + webListener.getId() + "' already exsits");
        }
        this.embedded.addConnector((Connector)((Object)webListener));
        log.info("Added connector " + webListener.getId());
    }

    @Override
    public org.glassfish.api.embedded.web.WebListener findWebListener(String id) {
        WebListener webListener = null;
        for (Connector connector : this.embedded.findConnectors()) {
            if (!connector.getName().equals(id)) continue;
            webListener = (WebListener)connector;
        }
        return webListener;
    }

    @Override
    public Collection<org.glassfish.api.embedded.web.WebListener> getWebListeners() {
        org.glassfish.api.embedded.web.WebListener[] connectors = (org.glassfish.api.embedded.web.WebListener[])this.embedded.findConnectors();
        return Arrays.asList(connectors);
    }

    @Override
    public void removeWebListener(org.glassfish.api.embedded.web.WebListener webListener) throws org.glassfish.api.embedded.LifecycleException {
        try {
            this.embedded.removeConnector((Connector)((Object)webListener));
        }
        catch (LifecycleException e) {
            throw new org.glassfish.api.embedded.LifecycleException((Throwable)e);
        }
    }

    @Override
    public org.glassfish.api.embedded.web.VirtualServer createVirtualServer(String id, File docRoot, org.glassfish.api.embedded.web.WebListener ... webListeners) {
        log.info("Created virtual server " + id + " with ports ");
        VirtualServer virtualServer = new VirtualServer();
        virtualServer.setName(id);
        if (docRoot != null) {
            virtualServer.setAppBase(docRoot.getPath());
        }
        int[] ports = new int[webListeners.length];
        for (int i = 0; i < webListeners.length; ++i) {
            ports[i] = webListeners[i].getPort();
            log.info("" + ports[i]);
        }
        virtualServer.setPorts(ports);
        return virtualServer;
    }

    @Override
    public org.glassfish.api.embedded.web.VirtualServer createVirtualServer(String id, File docRoot) {
        log.info("Created virtual server " + id + " with ports ");
        VirtualServer virtualServer = new VirtualServer();
        virtualServer.setName(id);
        if (docRoot != null) {
            virtualServer.setAppBase(docRoot.getPath());
        }
        Connector[] connectors = this.embedded.findConnectors();
        int[] ports = new int[connectors.length];
        for (int i = 0; i < connectors.length; ++i) {
            ports[i] = ((org.apache.catalina.connector.Connector)connectors[i]).getPort();
            log.info("" + ports[i]);
        }
        virtualServer.setPorts(ports);
        return virtualServer;
    }

    @Override
    public void addVirtualServer(org.glassfish.api.embedded.web.VirtualServer virtualServer) throws ConfigException, org.glassfish.api.embedded.LifecycleException {
        Engine[] engines = this.embedded.getEngines();
        if (engines.length == 0) {
            Engine engine = this.embedded.createEngine();
            engine.setName(this.defaultDomain);
            ((StandardEngine)engine).setDomain(this.defaultDomain);
            engine.setParentClassLoader(EmbeddedWebContainer.class.getClassLoader());
            this.embedded.addEngine(engine);
        }
        if ((engines = this.embedded.getEngines())[0].findChild(virtualServer.getId()) != null) {
            throw new ConfigException("VirtualServer with id " + virtualServer.getId() + " is already registered");
        }
        engines[0].setDefaultHost(virtualServer.getId());
        engines[0].addChild((Container)((Object)virtualServer));
        log.info("Added virtual server " + virtualServer.getId());
    }

    @Override
    public VirtualServer findVirtualServer(String id) {
        Engine[] engines = this.embedded.getEngines();
        return (VirtualServer)engines[0].findChild(id);
    }

    @Override
    public Collection<org.glassfish.api.embedded.web.VirtualServer> getVirtualServers() {
        Engine[] engines = this.embedded.getEngines();
        org.glassfish.api.embedded.web.VirtualServer[] virtualServers = (org.glassfish.api.embedded.web.VirtualServer[])engines[0].findChildren();
        return Arrays.asList(virtualServers);
    }

    @Override
    public void removeVirtualServer(org.glassfish.api.embedded.web.VirtualServer virtualServer) throws org.glassfish.api.embedded.LifecycleException {
        Engine[] engines = this.embedded.getEngines();
        engines[0].removeChild((Container)((Object)virtualServer));
    }

    public void setPath(File path) {
        this.path = path;
    }

    public File getPath() {
        return this.path;
    }

    @Override
    public void setLogLevel(Level level) {
        log.setLevel(level);
    }

    public boolean createDefaultConfig() {
        Engine[] engines = this.embedded.getEngines();
        if (engines.length == 0 || engines[0] == null) {
            return true;
        }
        return this.embedded.findConnectors().length <= 0 || engines[0].findChildren().length <= 0;
    }
}

