/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.event;

import javax.enterprise.event.TransactionPhase;
import org.jboss.webbeans.BeanManagerImpl;
import org.jboss.webbeans.bean.RIBean;
import org.jboss.webbeans.event.DeferredEventNotification;
import org.jboss.webbeans.event.ObserverMethodImpl;
import org.jboss.webbeans.event.Status;
import org.jboss.webbeans.event.TransactionSynchronizedRunnable;
import org.jboss.webbeans.introspector.WBMethod;
import org.jboss.webbeans.transaction.spi.TransactionServices;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TransactionalObserverMethodImpl<X, T>
extends ObserverMethodImpl<X, T> {
    protected TransactionalObserverMethodImpl(WBMethod<?, ?> observer, RIBean<?> observerBean, TransactionPhase transactionPhase, BeanManagerImpl manager) {
        super(observer, observerBean, manager);
        this.transactionPhase = transactionPhase;
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void notify(T event) {
        if (this.manager.getServices().get(TransactionServices.class) != null && this.manager.getServices().get(TransactionServices.class).isTransactionActive()) {
            this.deferEvent(event);
        } else {
            this.sendEvent(event);
        }
    }

    private void deferEvent(T event) {
        DeferredEventNotification<T> deferredEvent = new DeferredEventNotification<T>(event, this);
        TransactionSynchronizedRunnable synchronization = null;
        if (this.transactionPhase.equals((Object)TransactionPhase.BEFORE_COMPLETION)) {
            synchronization = new TransactionSynchronizedRunnable(deferredEvent, true);
        } else if (this.transactionPhase.equals((Object)TransactionPhase.AFTER_COMPLETION)) {
            synchronization = new TransactionSynchronizedRunnable(deferredEvent, false);
        } else if (this.transactionPhase.equals((Object)TransactionPhase.AFTER_SUCCESS)) {
            synchronization = new TransactionSynchronizedRunnable(deferredEvent, Status.SUCCESS);
        } else if (this.transactionPhase.equals((Object)TransactionPhase.AFTER_FAILURE)) {
            synchronization = new TransactionSynchronizedRunnable(deferredEvent, Status.FAILURE);
        }
        this.manager.getServices().get(TransactionServices.class).registerSynchronization(synchronization);
    }
}

