/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.util;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbIORConfigurationDescriptor;
import com.sun.enterprise.deployment.LifecycleCallbackDescriptor;
import com.sun.enterprise.deployment.ManagedBeanDescriptor;
import com.sun.enterprise.deployment.ServletFilterDescriptor;
import com.sun.enterprise.deployment.SessionConfigDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.util.ApplicationVisitor;
import com.sun.enterprise.deployment.util.EjbBundleValidator;
import com.sun.enterprise.deployment.util.EjbBundleVisitor;
import com.sun.enterprise.deployment.util.EjbVisitor;
import com.sun.enterprise.deployment.util.ManagedBeanVisitor;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.deployment.web.MultipartConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jvnet.hk2.annotations.Service;

@Service(name="application_deploy")
public class ApplicationValidator
extends EjbBundleValidator
implements ApplicationVisitor,
EjbBundleVisitor,
EjbVisitor,
ManagedBeanVisitor {
    private Application application;

    public void accept(Application application) {
        this.application = application;
        if (application.getBundleDescriptors().size() == 0) {
            throw new IllegalArgumentException("Application [" + application.getRegistrationName() + "] contains no valid components");
        }
        ArrayList<ModuleDescriptor<BundleDescriptor>> conflicted = new ArrayList<ModuleDescriptor<BundleDescriptor>>();
        Set<ModuleDescriptor<BundleDescriptor>> modules = application.getModules();
        for (ModuleDescriptor<BundleDescriptor> module : modules) {
            if (conflicted.contains(module)) continue;
            boolean foundConflictedModule = false;
            for (ModuleDescriptor<BundleDescriptor> module2 : modules) {
                if (conflicted.contains(module2) || module.equals(module2) || !module.getModuleName().equals(module2.getModuleName())) continue;
                conflicted.add(module2);
                foundConflictedModule = true;
            }
            if (!foundConflictedModule) continue;
            conflicted.add(module);
        }
        for (ModuleDescriptor<BundleDescriptor> cModule : conflicted) {
            cModule.setModuleName(cModule.getModuleName() + cModule.getModuleType().toString());
        }
    }

    public void accept(EjbBundleDescriptor bundleDescriptor) {
        this.bundleDescriptor = bundleDescriptor;
        super.accept(bundleDescriptor);
        String rlm = this.application.getRealm();
        for (EjbDescriptor ejb : bundleDescriptor.getEjbs()) {
            for (EjbIORConfigurationDescriptor desc : ejb.getIORConfigurationDescriptors()) {
                desc.setRealmName(rlm);
            }
        }
    }

    public void accept(ManagedBeanDescriptor managedBean) {
        this.bundleDescriptor = managedBean.getBundle();
        this.application = this.bundleDescriptor.getApplication();
    }

    public void accept(WebBundleDescriptor descriptor) {
        this.bundleDescriptor = descriptor;
        if (descriptor.getSessionConfig() == null) {
            descriptor.setSessionConfig(new SessionConfigDescriptor());
        }
        if (descriptor.isDistributable() == null) {
            descriptor.setDistributable(Boolean.FALSE);
        }
    }

    public void accept(ApplicationClientDescriptor appclientdescriptor) {
        this.bundleDescriptor = appclientdescriptor;
        for (LifecycleCallbackDescriptor next : appclientdescriptor.getPreDestroyDescriptors()) {
            next.setDefaultLifecycleCallbackClass(appclientdescriptor.getMainClassName());
        }
        for (LifecycleCallbackDescriptor next : appclientdescriptor.getPostConstructDescriptors()) {
            next.setDefaultLifecycleCallbackClass(appclientdescriptor.getMainClassName());
        }
    }

    public void accept(WebComponentDescriptor descriptor) {
        MultipartConfig multipartConfig;
        if (descriptor.getLoadOnStartUp() == null) {
            descriptor.setLoadOnStartUp(-1);
        }
        if (descriptor.isAsyncSupported() == null) {
            descriptor.setAsyncSupported(false);
        }
        if ((multipartConfig = descriptor.getMultipartConfig()) != null) {
            if (multipartConfig.getMaxFileSize() == null) {
                multipartConfig.setMaxFileSize(new Long(-1L));
            }
            if (multipartConfig.getMaxRequestSize() == null) {
                multipartConfig.setMaxRequestSize(new Long(-1L));
            }
            if (multipartConfig.getFileSizeThreshold() == null) {
                multipartConfig.setFileSizeThreshold(new Integer(0));
            }
        }
        this.computeRuntimeDefault(descriptor);
    }

    private void computeRuntimeDefault(WebComponentDescriptor webComp) {
        if (!webComp.getUsesCallerIdentity()) {
            this.computeRunAsPrincipalDefault(webComp.getRunAsIdentity(), webComp.getApplication());
        }
    }

    public void accept(ServletFilterDescriptor descriptor) {
        if (descriptor.isAsyncSupported() == null) {
            descriptor.setAsyncSupported(false);
        }
    }

    protected Collection getEjbDescriptors() {
        if (this.application != null) {
            return this.application.getEjbDescriptors();
        }
        return new HashSet();
    }

    protected Application getApplication() {
        return this.application;
    }

    protected BundleDescriptor getBundleDescriptor() {
        return this.bundleDescriptor;
    }
}

