/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.util;

import com.sun.enterprise.deployment.AnnotationTypesProvider;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.DummyEjbDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.InjectionCapable;
import com.sun.enterprise.deployment.InterceptorBindingDescriptor;
import com.sun.enterprise.deployment.JmsDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.ManagedBeanDescriptor;
import com.sun.enterprise.deployment.MessageDestinationDescriptor;
import com.sun.enterprise.deployment.MessageDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.RunAsIdentityDescriptor;
import com.sun.enterprise.deployment.ScheduledTimerDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.types.EjbReference;
import com.sun.enterprise.deployment.util.ComponentValidator;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.util.EjbBundleVisitor;
import com.sun.enterprise.deployment.util.InterceptorBindingTranslator;
import com.sun.enterprise.deployment.util.ScheduledTimerValidator;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import org.glassfish.internal.api.Globals;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbBundleValidator
extends ComponentValidator
implements EjbBundleVisitor {
    protected EjbBundleDescriptor ejbBundleDescriptor = null;
    protected EjbDescriptor ejb = null;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(EjbBundleValidator.class);
    private Logger _logger = LogDomains.getLogger(DOLUtils.class, (String)"javax.enterprise.system.tools.deployment");

    @Override
    public void accept(EjbBundleDescriptor bundleDescriptor) {
        if (bundleDescriptor.getEjbs().size() == 0) {
            throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.util.no_ejb_in_ejb_jar", "Invalid ejb jar {0}: it contains zero ejb. A valid ejb jar requires at least one session/entity/message driven bean.", new Object[]{bundleDescriptor.getModuleDescriptor().getArchiveUri()}));
        }
        if (!bundleDescriptor.areResourceReferencesValid()) {
            throw new RuntimeException("Incorrectly resolved role references");
        }
        this.ejbBundleDescriptor = bundleDescriptor;
        this.handleOverloadedInterceptorMethodBindings(bundleDescriptor);
        InterceptorBindingTranslator bindingTranslator = new InterceptorBindingTranslator(bundleDescriptor);
        for (EjbDescriptor ejb : bundleDescriptor.getEjbs()) {
            if (ejb.getType() == "Entity") continue;
            ejb.applyInterceptors(bindingTranslator);
        }
    }

    private void handleOverloadedInterceptorMethodBindings(EjbBundleDescriptor bundleDesc) {
        List<InterceptorBindingDescriptor> origBindings = bundleDesc.getInterceptorBindings();
        if (origBindings.isEmpty()) {
            return;
        }
        ClassLoader cl = bundleDesc.getClassLoader();
        LinkedList<InterceptorBindingDescriptor> newBindings = new LinkedList<InterceptorBindingDescriptor>();
        for (InterceptorBindingDescriptor next : origBindings) {
            if (next.getNeedsOverloadResolution()) {
                MethodDescriptor overloadedMethodDesc = next.getBusinessMethod();
                String methodName = overloadedMethodDesc.getName();
                String ejbName = next.getEjbName();
                EjbDescriptor ejbDesc = bundleDesc.getEjbByName(ejbName);
                Class<?> ejbClass = null;
                try {
                    ejbClass = cl.loadClass(ejbDesc.getEjbClassName());
                }
                catch (Exception e) {
                    RuntimeException re = new RuntimeException("Error loading ejb class " + ejbDesc.getEjbClassName());
                    re.initCause(e);
                    throw re;
                }
                for (Method ejbClassMethod : ejbClass.getDeclaredMethods()) {
                    if (!ejbClassMethod.getName().equals(methodName)) continue;
                    InterceptorBindingDescriptor newInterceptorBinding = new InterceptorBindingDescriptor();
                    MethodDescriptor newMethodDesc = new MethodDescriptor(ejbClassMethod, "Bean");
                    newInterceptorBinding.setEjbName(ejbName);
                    newInterceptorBinding.setBusinessMethod(newMethodDesc);
                    for (String interceptorClass : next.getInterceptorClasses()) {
                        newInterceptorBinding.appendInterceptorClass(interceptorClass);
                    }
                    newInterceptorBinding.setIsTotalOrdering(next.getIsTotalOrdering());
                    newInterceptorBinding.setExcludeDefaultInterceptors(next.getExcludeDefaultInterceptors());
                    newInterceptorBinding.setExcludeClassInterceptors(next.getExcludeClassInterceptors());
                    newBindings.add(newInterceptorBinding);
                }
                continue;
            }
            newBindings.add(next);
        }
        bundleDesc.setInterceptorBindings(newBindings);
    }

    @Override
    public void accept(InjectionCapable injectable) {
        this.acceptWithCL(injectable);
        this.acceptWithoutCL(injectable);
    }

    @Override
    public void accept(EjbDescriptor ejb) {
        block11: {
            if (ejb instanceof DummyEjbDescriptor) {
                throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionbeanbundle", "Referencing error: this bundle has no bean of name: {0}", new Object[]{ejb.getName()}));
            }
            this.ejb = ejb;
            this.setDOLDefault(ejb);
            this.computeRuntimeDefault(ejb);
            this.checkDependsOn(ejb);
            this.validateConcurrencyMetadata(ejb);
            try {
                ClassLoader cl = ejb.getEjbBundleDescriptor().getClassLoader();
                Class<?> ejbClass = cl.loadClass(ejb.getEjbClassName());
                AnnotationTypesProvider provider = Globals.getDefaultHabitat().getComponent(AnnotationTypesProvider.class, "EJB");
                if (!ejb.isTimedObject()) {
                    if (provider != null) {
                        if (provider.getType("javax.ejb.TimedObject").isAssignableFrom(ejbClass)) {
                            MethodDescriptor timedObjectMethod = new MethodDescriptor("ejbTimeout", "TimedObject timeout method", new String[]{"javax.ejb.Timer"}, "Bean");
                            ejb.setEjbTimeoutMethod(timedObjectMethod);
                        }
                        break block11;
                    }
                    throw new RuntimeException("Cannot find AnnotationTypesProvider named 'EJB'");
                }
                if (ejb.getEjbTimeoutMethod() != null) {
                    MethodDescriptor timeoutMethodDescOrig = ejb.getEjbTimeoutMethod();
                    MethodDescriptor timeoutMethodDesc = this.processTimeoutMethod(ejb, timeoutMethodDescOrig, provider, ejbClass);
                    ejb.setEjbTimeoutMethod(timeoutMethodDesc);
                }
                ScheduledTimerValidator validator = Globals.getDefaultHabitat().getComponent(ScheduledTimerValidator.class);
                for (ScheduledTimerDescriptor sd : ejb.getScheduledTimerDescriptors()) {
                    if (validator != null) {
                        try {
                            validator.validateScheduledTimerDescriptor(sd);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(ejb.getName() + ": Invalid schedule " + " defined on method " + sd.getTimeoutMethod().getFormattedString() + ": " + e.getMessage());
                        }
                    }
                    MethodDescriptor timeoutMethodDescOrig = sd.getTimeoutMethod();
                    MethodDescriptor timeoutMethodDesc = this.processTimeoutMethod(ejb, timeoutMethodDescOrig, provider, ejbClass);
                    sd.setTimeoutMethod(timeoutMethodDesc);
                }
            }
            catch (Exception e) {
                RuntimeException re = new RuntimeException("Error processing EjbDescriptor");
                re.initCause(e);
                throw re;
            }
        }
    }

    @Override
    public void accept(WebService webService) {
    }

    private void validateConcurrencyMetadata(EjbDescriptor ejb) {
        if (ejb instanceof EjbSessionDescriptor) {
            EjbSessionDescriptor sessionDesc = (EjbSessionDescriptor)ejb;
            List<EjbSessionDescriptor.AccessTimeoutHolder> accessTimeoutInfo = sessionDesc.getAccessTimeoutInfo();
            for (EjbSessionDescriptor.AccessTimeoutHolder accessTimeoutHolder : accessTimeoutInfo) {
                MethodDescriptor accessTimeoutMethodDesc = accessTimeoutHolder.method;
                Method accessTimeoutMethod = accessTimeoutMethodDesc.getMethod(ejb);
                if (accessTimeoutMethod != null) continue;
                throw new RuntimeException("Invalid AccessTimeout method signature " + accessTimeoutMethodDesc + " . Method could not be resolved to a bean class method for bean " + ejb.getName());
            }
            for (MethodDescriptor lockMethodDesc : sessionDesc.getReadAndWriteLockMethods()) {
                Method readLockMethod = lockMethodDesc.getMethod(sessionDesc);
                if (readLockMethod != null) continue;
                throw new RuntimeException("Invalid Lock method signature " + lockMethodDesc + " . Method could not be resolved to a bean class method for bean " + ejb.getName());
            }
        }
    }

    private void checkDependsOn(EjbDescriptor ejb) {
        EjbSessionDescriptor sessionDesc;
        if (ejb instanceof EjbSessionDescriptor && (sessionDesc = (EjbSessionDescriptor)ejb).hasDependsOn()) {
            String[] dependsOn;
            if (!sessionDesc.isSingleton()) {
                throw new RuntimeException("Illegal usage of DependsOn for EJB " + ejb.getName() + ". DependsOn is only supported for Singleton beans");
            }
            for (String next : dependsOn = sessionDesc.getDependsOn()) {
                boolean fullyQualified = next.contains("#");
                Application app = sessionDesc.getEjbBundleDescriptor().getApplication();
                if (fullyQualified) {
                    EjbBundleDescriptor ejbBundle;
                    int indexOfHash = next.indexOf("#");
                    String ejbName = next.substring(indexOfHash + 1);
                    String relativeJarPath = next.substring(0, indexOfHash);
                    BundleDescriptor bundle = app.getRelativeBundle(sessionDesc.getEjbBundleDescriptor(), relativeJarPath);
                    if (bundle == null) {
                        throw new IllegalStateException("Invalid @DependOn value = " + next + " for Singleton " + sessionDesc.getName());
                    }
                    EjbBundleDescriptor ejbBundleDescriptor = ejbBundle = bundle instanceof WebBundleDescriptor ? ((WebBundleDescriptor)bundle).getExtensionsDescriptors(EjbBundleDescriptor.class).iterator().next() : (EjbBundleDescriptor)bundle;
                    if (ejbBundle.hasEjbByName(ejbName)) continue;
                    throw new RuntimeException("Invalid DependsOn dependency '" + next + "' for EJB " + ejb.getName());
                }
                EjbBundleDescriptor bundle = ejb.getEjbBundleDescriptor();
                if (bundle.hasEjbByName(next)) continue;
                throw new RuntimeException("Invalid DependsOn dependency '" + next + "' for EJB " + ejb.getName());
            }
        }
    }

    @Override
    public void accept(EjbReference ejbRef) {
        String interfaceToMatch;
        EjbIntfInfo intfInfo;
        Map<String, EjbIntfInfo> ejbIntfInfoMap;
        DOLUtils.getDefaultLogger().fine("Visiting Ref" + ejbRef);
        if (ejbRef.getEjbDescriptor() != null) {
            return;
        }
        if (ejbRef.getType() == null) {
            if (ejbRef.isEJB30ClientView()) {
                ejbRef.setType("Session");
            } else {
                String homeIntf = ejbRef.getEjbHomeInterface();
                BundleDescriptor referringJar = ejbRef.getReferringBundleDescriptor();
                if (referringJar == null) {
                    referringJar = this.getBundleDescriptor();
                }
                ClassLoader classLoader = referringJar.getClassLoader();
                Class<?> clazz = null;
                try {
                    clazz = classLoader.loadClass(homeIntf);
                    for (Method method : clazz.getDeclaredMethods()) {
                        if (!method.getName().equals("findByPrimaryKey")) continue;
                        ejbRef.setType("Entity");
                        break;
                    }
                    if (ejbRef.getType() == null) {
                        ejbRef.setType("Session");
                    }
                }
                catch (Exception e) {
                    this._logger.log(Level.FINE, "Could not load " + homeIntf, e);
                }
            }
        }
        if (ejbRef.getJndiName() != null && ejbRef.getJndiName().length() != 0 && (!ejbRef.isLocal() || ejbRef.isLocal() && ejbRef.getLinkName() == null)) {
            DOLUtils.getDefaultLogger().fine("Ref " + ejbRef.getName() + " is bound to Ejb with JNDI Name " + ejbRef.getJndiName());
            if (this.getEjbDescriptors() != null) {
                for (EjbDescriptor ejb : this.getEjbDescriptors()) {
                    if (!ejbRef.getJndiName().equals(ejb.getJndiName())) continue;
                    ejbRef.setEjbDescriptor(ejb);
                    return;
                }
            }
        }
        if (!(ejbRef.getJndiName() != null && ejbRef.getJndiName().length() != 0 || ejbRef.getLinkName() != null && ejbRef.getLinkName().length() != 0 || ejbRef.hasLookupName() || (ejbIntfInfoMap = this.getEjbIntfMap()).size() <= 0 || (intfInfo = ejbIntfInfoMap.get(interfaceToMatch = ejbRef.isEJB30ClientView() ? ejbRef.getEjbInterface() : ejbRef.getEjbHomeInterface())) == null)) {
            int numMatches = intfInfo.ejbs.size();
            if (numMatches == 1) {
                Iterator<EjbDescriptor> iter = intfInfo.ejbs.iterator();
                EjbDescriptor target = iter.next();
                EjbBundleDescriptor targetModule = target.getEjbBundleDescriptor();
                BundleDescriptor sourceModule = ejbRef.getReferringBundleDescriptor();
                Application app = targetModule.getApplication();
                String ejbLinkName = target.getName();
                if (!sourceModule.isPackagedAsSingleModule(targetModule)) {
                    String relativeUri = null;
                    relativeUri = sourceModule == app ? targetModule.getModuleDescriptor().getArchiveUri() : this.getApplication().getRelativeUri(sourceModule, targetModule);
                    ejbLinkName = relativeUri + "#" + ejbLinkName;
                }
                ejbRef.setLinkName(ejbLinkName);
            } else {
                String msg = "Cannot resolve reference " + ejbRef + " because there are " + numMatches + " ejbs " + " in the application with interface " + interfaceToMatch;
                DOLUtils.getDefaultLogger().severe(msg);
                throw new RuntimeException(msg);
            }
        }
        if (ejbRef.getLinkName() == null) {
            if (ejbRef.isLocal()) {
                if (ejbRef.hasLookupName()) {
                    return;
                }
                DOLUtils.getDefaultLogger().severe("Cannot resolve reference " + ejbRef);
                throw new RuntimeException("Cannot resolve reference " + ejbRef);
            }
            if (!ejbRef.hasJndiName() && !ejbRef.hasLookupName()) {
                String jndiName = this.getDefaultEjbJndiName(ejbRef.isEJB30ClientView() ? ejbRef.getEjbInterface() : ejbRef.getEjbHomeInterface());
                ejbRef.setJndiName(jndiName);
                DOLUtils.getDefaultLogger().fine("Applying default to ejb reference: " + ejbRef);
            }
            return;
        }
        String homeClassName = ejbRef.getEjbHomeInterface();
        String intfClassName = ejbRef.getEjbInterface();
        String type = ejbRef.getType();
        EjbDescriptor ejbReferee = null;
        String linkName = ejbRef.getLinkName();
        int ind = linkName.lastIndexOf(35);
        if (ind != -1) {
            String ejbName = linkName.substring(ind + 1);
            String jarPath = linkName.substring(0, ind);
            BundleDescriptor referringJar = ejbRef.getReferringBundleDescriptor();
            if (referringJar == null) {
                ejbRef.setReferringBundleDescriptor(this.getBundleDescriptor());
                referringJar = this.getBundleDescriptor();
            }
            if (this.getApplication() != null) {
                BundleDescriptor refereeJar = null;
                refereeJar = referringJar instanceof Application ? ((Application)referringJar).getModuleByUri(jarPath) : this.getApplication().getRelativeBundle(referringJar, jarPath);
                if (refereeJar != null && refereeJar instanceof EjbBundleDescriptor) {
                    ejbReferee = ((EjbBundleDescriptor)refereeJar).getEjbByName(ejbName);
                }
            }
        } else if (this.getApplication() != null && this.ejbBundleDescriptor != null && this.ejbBundleDescriptor.hasEjbByName(linkName)) {
            ejbReferee = this.ejbBundleDescriptor.getEjbByName(linkName);
        } else if (this.getApplication() != null && this.getApplication().hasEjbByName(linkName)) {
            ejbReferee = this.getApplication().getEjbByName(ejbRef.getLinkName());
        } else if (this.ejb != null) {
            try {
                ejbReferee = this.ejb.getEjbBundleDescriptor().getEjbByName(ejbRef.getLinkName());
            }
            catch (IllegalArgumentException e) {
                DOLUtils.getDefaultLogger().warning("Unresolved <ejb-link>: " + linkName);
                return;
            }
        }
        if (ejbReferee == null) {
            if (ejbRef.isLocal()) {
                DOLUtils.getDefaultLogger().severe("Unresolved <ejb-link>: " + linkName);
                throw new RuntimeException("Error: Unresolved <ejb-link>: " + linkName);
            }
            if (ejbRef.getReferringBundleDescriptor() instanceof ApplicationClientDescriptor) {
                DOLUtils.getDefaultLogger().fine("Unresolved <ejb-link>: " + linkName);
            } else {
                DOLUtils.getDefaultLogger().warning("Unresolved <ejb-link>: " + linkName);
            }
            return;
        }
        if (ejbRef.isEJB30ClientView()) {
            String msg;
            BundleDescriptor referringBundle = ejbRef.getReferringBundleDescriptor();
            if (referringBundle == null && this.ejbBundleDescriptor == null || referringBundle instanceof ApplicationClientDescriptor || this.getApplication() == null && referringBundle instanceof WebBundleDescriptor) {
                ejbRef.setLocal(false);
                if (!ejbReferee.getRemoteBusinessClassNames().contains(intfClassName)) {
                    msg = "Target ejb " + ejbReferee.getName() + " for " + " remote ejb 3.0 reference " + ejbRef.getName() + " does not expose a remote business interface of type " + intfClassName;
                    throw new RuntimeException(msg);
                }
            } else if (ejbReferee.getLocalBusinessClassNames().contains(intfClassName)) {
                ejbRef.setLocal(true);
            } else if (ejbReferee.getRemoteBusinessClassNames().contains(intfClassName)) {
                ejbRef.setLocal(false);
            } else if (ejbReferee.isLocalBean()) {
                ejbRef.setLocal(true);
            } else {
                msg = "Warning : Unable to determine local  business vs. remote business designation for  EJB 3.0 ref " + ejbRef;
                throw new RuntimeException(msg);
            }
        }
        ejbRef.setEjbDescriptor(ejbReferee);
        if (DOLUtils.getDefaultLogger().isLoggable(Level.FINE)) {
            DOLUtils.getDefaultLogger().fine("Done Visiting " + this.ejb.getName() + " reference " + ejbRef);
        }
        if (ejbReferee != null) {
            if (ejbRef.isEJB30ClientView()) {
                Set<String> targetBusinessIntfs = ejbRef.isLocal() ? ejbReferee.getLocalBusinessClassNames() : ejbReferee.getRemoteBusinessClassNames();
                EjbDescriptor ejbDesc = ejbRef.getEjbDescriptor();
                if (!targetBusinessIntfs.contains(intfClassName) && ejbDesc.isLocalBean() && !intfClassName.equals(ejbReferee.getEjbClassName())) {
                    DOLUtils.getDefaultLogger().log(Level.WARNING, "enterprise.deployment.backend.ejbRefTypeMismatch", new Object[]{ejbRef.getName(), intfClassName, ejbReferee.getName(), ejbRef.isLocal() ? "Local Business" : "Remote Business", targetBusinessIntfs.toString()});
                    if (targetBusinessIntfs.size() == 1) {
                        Iterator<String> iter = targetBusinessIntfs.iterator();
                        ejbRef.setEjbInterface(iter.next());
                    }
                }
            } else {
                String targetComponentIntf;
                String targetHome;
                String string = targetHome = ejbRef.isLocal() ? ejbReferee.getLocalHomeClassName() : ejbReferee.getHomeClassName();
                if (!homeClassName.equals(targetHome)) {
                    DOLUtils.getDefaultLogger().log(Level.WARNING, "enterprise.deployment.backend.ejbRefTypeMismatch", new Object[]{ejbRef.getName(), homeClassName, ejbReferee.getName(), ejbRef.isLocal() ? "Local Home" : "Remote Home", targetHome});
                    if (targetHome != null) {
                        ejbRef.setEjbHomeInterface(targetHome);
                    }
                }
                String string2 = targetComponentIntf = ejbRef.isLocal() ? ejbReferee.getLocalClassName() : ejbReferee.getRemoteClassName();
                if (intfClassName != null && !intfClassName.equals(targetComponentIntf)) {
                    DOLUtils.getDefaultLogger().log(Level.WARNING, "enterprise.deployment.backend.ejbRefTypeMismatch", new Object[]{ejbRef.getName(), intfClassName, ejbReferee.getName(), ejbRef.isLocal() ? "Local" : "Remote", targetComponentIntf});
                    if (targetComponentIntf != null) {
                        ejbRef.setEjbInterface(targetComponentIntf);
                    }
                }
            }
            ejbRef.setJndiName(ejbReferee.getJndiName());
        }
        if (!type.equals(ejbRef.getType())) {
            DOLUtils.getDefaultLogger().log(Level.WARNING, "enterprise.deployment.backend.invalidDescriptorMappingFailure", new Object[]{ejbRef.getName(), type});
            ejbRef.setType(ejbRef.getType());
        }
    }

    @Override
    public void accept(ResourceReferenceDescriptor resRef) {
        this.computeRuntimeDefault(resRef);
    }

    @Override
    public void accept(JmsDestinationReferenceDescriptor jmsDestRef) {
        String refType;
        Map<String, ManagedBeanDescriptor> managedBeanMap;
        if ((jmsDestRef.getJndiName() == null || jmsDestRef.getJndiName().length() == 0) && (managedBeanMap = this.getManagedBeanMap()).containsKey(refType = jmsDestRef.getRefType())) {
            ManagedBeanDescriptor desc = managedBeanMap.get(refType);
            jmsDestRef.setJndiName(desc.getGlobalJndiName());
            jmsDestRef.setIsManagedBean(true);
            jmsDestRef.setManagedBeanDescriptor(desc);
        }
        this.computeRuntimeDefault(jmsDestRef);
    }

    @Override
    public void accept(MessageDestinationReferenceDescriptor msgDestRef) {
        this.computeRuntimeDefault(msgDestRef);
    }

    @Override
    public void accept(MessageDestinationDescriptor msgDest) {
        this.computeRuntimeDefault(msgDest);
    }

    private Map<String, EjbIntfInfo> getEjbIntfMap() {
        Collection ejbs = this.getEjbDescriptors();
        HashMap<String, EjbIntfInfo> intfInfoMap = new HashMap<String, EjbIntfInfo>();
        for (EjbDescriptor next : ejbs) {
            if (next.isRemoteInterfacesSupported()) {
                this.addIntfInfo(intfInfoMap, next.getHomeClassName(), EjbIntfType.REMOTE_HOME, next);
            }
            if (next.isRemoteBusinessInterfacesSupported()) {
                for (String nextIntf : next.getRemoteBusinessClassNames()) {
                    this.addIntfInfo(intfInfoMap, nextIntf, EjbIntfType.REMOTE_BUSINESS, next);
                }
            }
            if (next.isLocalInterfacesSupported()) {
                this.addIntfInfo(intfInfoMap, next.getLocalHomeClassName(), EjbIntfType.LOCAL_HOME, next);
            }
            if (next.isLocalBusinessInterfacesSupported()) {
                for (String nextIntf : next.getLocalBusinessClassNames()) {
                    this.addIntfInfo(intfInfoMap, nextIntf, EjbIntfType.LOCAL_BUSINESS, next);
                }
            }
            if (!next.isLocalBean()) continue;
            this.addIntfInfo(intfInfoMap, next.getEjbClassName(), EjbIntfType.NO_INTF_LOCAL_BUSINESS, next);
        }
        return intfInfoMap;
    }

    private Map<String, ManagedBeanDescriptor> getManagedBeanMap() {
        BundleDescriptor thisBundle = this.getBundleDescriptor();
        Set<Object> bundleDescs = new HashSet<BundleDescriptor>();
        if (thisBundle != null) {
            Application app = thisBundle.getApplication();
            if (app != null) {
                bundleDescs = app.getBundleDescriptors();
            } else {
                bundleDescs.add(thisBundle);
            }
        }
        HashMap<String, ManagedBeanDescriptor> managedBeanMap = new HashMap<String, ManagedBeanDescriptor>();
        HashSet<String> allManagedBeanClasses = new HashSet<String>();
        block0: for (BundleDescriptor bundleDescriptor : bundleDescs) {
            for (ManagedBeanDescriptor managedBean : bundleDescriptor.getManagedBeans()) {
                String beanClassName = managedBean.getBeanClassName();
                if (allManagedBeanClasses.contains(beanClassName)) {
                    managedBeanMap.remove(beanClassName);
                    continue block0;
                }
                allManagedBeanClasses.add(beanClassName);
                managedBeanMap.put(beanClassName, managedBean);
            }
        }
        return managedBeanMap;
    }

    private void addIntfInfo(Map<String, EjbIntfInfo> intfInfoMap, String intf, EjbIntfType intfType, EjbDescriptor ejbDesc) {
        EjbIntfInfo intfInfo = intfInfoMap.get(intf);
        if (intfInfo == null) {
            EjbIntfInfo newInfo = new EjbIntfInfo();
            newInfo.ejbs = new HashSet<EjbDescriptor>();
            newInfo.ejbs.add(ejbDesc);
            newInfo.intfType = intfType;
            intfInfoMap.put(intf, newInfo);
        } else {
            intfInfo.ejbs.add(ejbDesc);
            intfInfo.intfType = EjbIntfType.NONE;
        }
    }

    protected Collection getEjbDescriptors() {
        if (this.getApplication() != null) {
            return this.getApplication().getEjbDescriptors();
        }
        if (this.ejbBundleDescriptor != null) {
            return this.ejbBundleDescriptor.getEjbs();
        }
        return new HashSet();
    }

    protected Application getApplication() {
        return null;
    }

    @Override
    protected BundleDescriptor getBundleDescriptor() {
        return this.ejbBundleDescriptor;
    }

    protected void computeRunAsPrincipalDefault(RunAsIdentityDescriptor runAs, Application application) {
        if (runAs != null && (runAs.getRoleName() == null || runAs.getRoleName().length() == 0)) {
            DOLUtils.getDefaultLogger().log(Level.WARNING, "enterprise.deployment.backend.emptyRoleName");
            return;
        }
        if (runAs != null && (runAs.getPrincipal() == null || runAs.getPrincipal().length() == 0) && application != null && application.getRoleMapper() != null) {
            String principalName = null;
            String roleName = runAs.getRoleName();
            final Subject fs = (Subject)application.getRoleMapper().getRoleToSubjectMapping().get(roleName);
            if (fs != null) {
                principalName = (String)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Set<Principal> pset = fs.getPrincipals();
                        Principal prin = null;
                        if (pset.size() > 0) {
                            prin = pset.iterator().next();
                            DOLUtils.getDefaultLogger().log(Level.WARNING, "enterprise.deployment.backend.computeRunAsPrincipal", new Object[]{prin.getName()});
                        }
                        return prin != null ? prin.getName() : null;
                    }
                });
            }
            if (principalName == null || principalName.length() == 0) {
                throw new RuntimeException("The RunAs role \"" + roleName + "\"" + " is not mapped to a principal.");
            }
            runAs.setPrincipal(principalName);
        }
    }

    private void setDOLDefault(EjbDescriptor ejb) {
        if (ejb.getUsesCallerIdentity() == null) {
            if (ejb instanceof EjbMessageBeanDescriptor) {
                ejb.setUsesCallerIdentity(false);
            } else {
                ejb.setUsesCallerIdentity(true);
            }
        }
        if (ejb.getTransactionType() == null) {
            ejb.setTransactionType("Container");
        }
        ejb.setUsesDefaultTransaction();
    }

    private void computeRuntimeDefault(EjbDescriptor ejb) {
        String intfName = null;
        if (!(ejb.getJndiName() != null && ejb.getJndiName().length() != 0 || ejb.isRemoteInterfacesSupported() && ejb.isRemoteBusinessInterfacesSupported())) {
            Set<String> classNames;
            if (ejb.isRemoteInterfacesSupported()) {
                intfName = ejb.getHomeClassName();
            } else if (ejb.isRemoteBusinessInterfacesSupported() && (classNames = ejb.getRemoteBusinessClassNames()).size() == 1) {
                intfName = classNames.iterator().next();
            }
        }
        if (intfName != null) {
            String jndiName = this.getDefaultEjbJndiName(intfName);
            ejb.setJndiName(jndiName);
        }
        if (!ejb.getUsesCallerIdentity().booleanValue()) {
            this.computeRunAsPrincipalDefault(ejb.getRunAsIdentity(), ejb.getApplication());
        }
    }

    private void computeRuntimeDefault(ResourceReferenceDescriptor resRef) {
        if (resRef.getType().equals("org.omg.CORBA.ORB")) {
            resRef.setJndiName("java:comp/ORB");
        } else if (resRef.getJndiName() == null || resRef.getJndiName().length() == 0) {
            resRef.setJndiName(this.getDefaultResourceJndiName(resRef.getName()));
        }
    }

    private void computeRuntimeDefault(JmsDestinationReferenceDescriptor jmsDestRef) {
        if (jmsDestRef.getRefType().equals("javax.transaction.UserTransaction")) {
            jmsDestRef.setJndiName("java:comp/UserTransaction");
        } else if (jmsDestRef.getRefType().equals("javax.transaction.TransactionSynchronizationRegistry")) {
            jmsDestRef.setJndiName("java:comp/TransactionSynchronizationRegistry");
        } else if (jmsDestRef.getJndiName() == null || jmsDestRef.getJndiName().length() == 0) {
            jmsDestRef.setJndiName(this.getDefaultResourceJndiName(jmsDestRef.getName()));
        }
    }

    private void computeRuntimeDefault(MessageDestinationReferenceDescriptor msgDestRef) {
        if (msgDestRef.getJndiName() == null || msgDestRef.getJndiName().length() == 0) {
            msgDestRef.setJndiName(this.getDefaultResourceJndiName(msgDestRef.getName()));
        }
    }

    private void computeRuntimeDefault(MessageDestinationDescriptor msgDest) {
        if (msgDest.getJndiName() == null || msgDest.getJndiName().length() == 0) {
            msgDest.setJndiName(this.getDefaultResourceJndiName(msgDest.getName()));
        }
    }

    private String getDefaultResourceJndiName(String resName) {
        return resName;
    }

    private String getDefaultEjbJndiName(String intfName) {
        return intfName;
    }

    private MethodDescriptor processTimeoutMethod(EjbDescriptor ejb, MethodDescriptor timeoutMethodDescOrig, AnnotationTypesProvider provider, Class ejbClass) throws ClassNotFoundException {
        Method m = timeoutMethodDescOrig.getDeclaredMethod(ejb);
        if (m == null) {
            Class[] params = new Class[1];
            if (provider == null) {
                throw new RuntimeException("Cannot find AnnotationTypesProvider named 'EJB'");
            }
            params[0] = provider.getType("javax.ejb.Timer");
            m = timeoutMethodDescOrig.getDeclaredMethod(ejb, params);
        }
        if (m == null) {
            throw new RuntimeException("Class " + ejbClass.getName() + " does not define timeout method " + timeoutMethodDescOrig.getFormattedString());
        }
        return new MethodDescriptor(m, "Bean");
    }

    private static class EjbIntfInfo {
        Set<EjbDescriptor> ejbs;
        EjbIntfType intfType;

        private EjbIntfInfo() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum EjbIntfType {
        NONE,
        REMOTE_HOME,
        REMOTE_BUSINESS,
        LOCAL_HOME,
        LOCAL_BUSINESS,
        NO_INTF_LOCAL_BUSINESS;

    }
}

