/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client.acc;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ACCClassLoader
extends URLClassLoader {
    private static ACCClassLoader instance = null;
    private ACCClassLoader shadow = null;
    private boolean shouldTransform = false;
    private final List<ClassFileTransformer> transformers = Collections.synchronizedList(new ArrayList());

    public static ACCClassLoader newInstance(ClassLoader parent, boolean shouldTransform) {
        if (instance != null) {
            throw new IllegalStateException("already set");
        }
        instance = new ACCClassLoader(parent, shouldTransform);
        return instance;
    }

    public static ACCClassLoader instance() {
        return instance;
    }

    public ACCClassLoader(ClassLoader parent) {
        super(ACCClassLoader.userClassPath(), (ClassLoader)new ACCClassLoader(ACCClassLoader.GFSystemClassPath(), parent.getParent()));
        instance = this;
    }

    private static URL[] userClassPath() {
        List<URL> result = ACCClassLoader.classPathToURLs(System.getProperty("java.class.path"));
        ListIterator<URL> it = result.listIterator();
        while (it.hasNext()) {
            URL url = it.next();
            if (!url.equals(ACCClassLoader.GFSystemURL())) continue;
            it.remove();
        }
        result.addAll(ACCClassLoader.classPathToURLs(System.getenv("APPCPATH")));
        return result.toArray(new URL[result.size()]);
    }

    private static URL[] GFSystemClassPath() {
        try {
            return new URL[]{ACCClassLoader.GFSystemURL().toURI().normalize().toURL()};
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static URL GFSystemURL() {
        try {
            Class<?> agentClass = Class.forName("org.glassfish.appclient.client.acc.agent.AppClientContainerAgent");
            return agentClass.getProtectionDomain().getCodeSource().getLocation().toURI().normalize().toURL();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static List<URL> classPathToURLs(String classPath) {
        if (classPath == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<URL> result = new ArrayList<URL>();
        try {
            for (String classPathElement : classPath.split(File.pathSeparator)) {
                result.add(new File(classPathElement).toURI().normalize().toURL());
            }
            return result;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public ACCClassLoader(ClassLoader parent, boolean shouldTransform) {
        super(new URL[0], parent);
        this.shouldTransform = shouldTransform;
    }

    public ACCClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    public synchronized void appendURL(URL url) {
        this.addURL(url);
        if (this.shadow != null) {
            this.shadow.addURL(url);
        }
    }

    public void addTransformer(ClassFileTransformer xf) {
        this.transformers.add(xf);
    }

    public void setShouldTransform(boolean shouldTransform) {
        this.shouldTransform = shouldTransform;
    }

    synchronized ACCClassLoader shadow() {
        if (this.shadow == null) {
            this.shadow = new ACCClassLoader(this.getURLs(), this.getParent());
        }
        return this.shadow;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (!this.shouldTransform) {
            return super.findClass(name);
        }
        ACCClassLoader s = this.shadow();
        Class<?> c = s.findClassUnshadowed(name);
        return this.copyClass(c);
    }

    private Class<?> copyClass(Class c) throws ClassNotFoundException {
        String name = c.getName();
        ProtectionDomain pd = c.getProtectionDomain();
        byte[] bytecode = this.readByteCode(name);
        for (ClassFileTransformer xf : this.transformers) {
            try {
                bytecode = xf.transform(this, name, null, pd, bytecode);
            }
            catch (IllegalClassFormatException ex) {
                throw new ClassNotFoundException(name, ex);
            }
        }
        return this.defineClass(name, bytecode, 0, bytecode.length, pd);
    }

    private Class<?> findClassUnshadowed(String name) throws ClassNotFoundException {
        return super.findClass(name);
    }

    private byte[] readByteCode(String className) throws ClassNotFoundException {
        String resourceName = className.replace('.', '/') + ".class";
        InputStream is = this.getResourceAsStream(resourceName);
        if (is == null) {
            throw new ClassNotFoundException(className);
        }
        try {
            int bytesRead;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[8196];
            while ((bytesRead = is.read(buffer)) != -1) {
                baos.write(buffer, 0, bytesRead);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new ClassNotFoundException(className, e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                throw new ClassNotFoundException(className, e);
            }
        }
    }
}

