/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist;

import com.sun.messaging.jmq.jmsserver.BrokerStateHandler;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;

public class StoreManager {
    private static final String PERSIST_PROP = "imq.persist.";
    private static final String CLASS_PROP = ".class";
    private static final String STORE_TYPE_PROP = "imq.persist.store";
    private static final String TXNLOG_ENABLED_PROP = "imq.persist.file.txnLog.enabled";
    private static final String NEW_TXNLOG_ENABLED_PROP = "imq.persist.file.newTxnLog.enabled";
    private static final String DEFAULT_STORE_TYPE = "file";
    private static final String DEFAULT_FILESTORE_CLASS = "com.sun.messaging.jmq.jmsserver.persist.file.FileStore";
    private static final String DEFAULT_JDBCSTORE_CLASS = "com.sun.messaging.jmq.jmsserver.persist.jdbc.JDBCStore";
    private static final String DEFAULT_INMEMORYSTORE_CLASS = "com.sun.messaging.jmq.jmsserver.persist.inmemory.InMemoryStore";
    private static Boolean isConfiguredFileStore = null;
    private static Boolean txnLogEnabled = null;
    private static Boolean newTxnLogEnabled = null;
    private static Store store = null;

    public static synchronized Store getStore() throws BrokerException {
        Logger logger = Globals.getLogger();
        BrokerResources brokerResources = Globals.getBrokerResources();
        if (store == null) {
            if (BrokerStateHandler.shuttingDown) {
                throw new BrokerException(Globals.getBrokerResources().getKString("B4140"), "B4140");
            }
            BrokerConfig brokerConfig = Globals.getConfig();
            String string = brokerConfig.getProperty(STORE_TYPE_PROP, DEFAULT_STORE_TYPE);
            if (Store.getDEBUG()) {
                logger.log(4, "imq.persist.store=" + string);
            }
            String string2 = brokerConfig.getProperty(PERSIST_PROP + string + CLASS_PROP);
            isConfiguredFileStore = new Boolean(false);
            if (string2 == null || string2.equals("")) {
                if (string.equals(DEFAULT_STORE_TYPE)) {
                    string2 = DEFAULT_FILESTORE_CLASS;
                    isConfiguredFileStore = new Boolean(true);
                } else {
                    string2 = string.equals("jdbc") ? DEFAULT_JDBCSTORE_CLASS : (string.equals("inmemory") ? DEFAULT_INMEMORYSTORE_CLASS : null);
                }
            }
            if (string2 == null) {
                throw new BrokerException(brokerResources.getString("B3005", string));
            }
            if (Store.getDEBUG()) {
                logger.log(4, PERSIST_PROP + string + CLASS_PROP + "=" + string2);
            }
            try {
                boolean bl = false;
                do {
                    store = (Store)Class.forName(string2).newInstance();
                    store.init();
                    txnLogEnabled = new Boolean(brokerConfig.getBooleanProperty(TXNLOG_ENABLED_PROP, false));
                    newTxnLogEnabled = new Boolean(brokerConfig.getBooleanProperty(NEW_TXNLOG_ENABLED_PROP, false));
                    if (!isConfiguredFileStore.booleanValue()) {
                        if (txnLogEnabled.booleanValue()) {
                            logger.log(16, Globals.getBrokerResources().getKString("B2219", "imq.persist.file.txnLog.enabled=true"));
                        }
                        if (newTxnLogEnabled.booleanValue()) {
                            logger.log(16, Globals.getBrokerResources().getKString("B2219", "imq.persist.file.newTxnLog.enabled=true"));
                        }
                        break;
                    }
                    if (Globals.isNewTxnLogEnabled()) {
                        return store;
                    }
                    if (bl) {
                        if (store.initTxnLogger()) {
                            throw new BrokerException(brokerResources.getString("B3228"));
                        }
                        break;
                    }
                    bl = store.initTxnLogger();
                    if (!bl) continue;
                    store.close();
                    store = null;
                } while (bl);
            }
            catch (Exception exception) {
                if (exception instanceof BrokerException) {
                    throw (BrokerException)exception;
                }
                throw new BrokerException(brokerResources.getString("B3006"), exception);
            }
        }
        return store;
    }

    private static boolean isConfiguredFileStore() {
        Boolean bl = isConfiguredFileStore;
        if (bl != null) {
            return bl;
        }
        String string = Globals.getConfig().getProperty(STORE_TYPE_PROP, DEFAULT_STORE_TYPE);
        return string.equals(DEFAULT_STORE_TYPE);
    }

    public static boolean txnLogEnabled() {
        if (!StoreManager.isConfiguredFileStore()) {
            return false;
        }
        Boolean bl = txnLogEnabled;
        if (bl != null) {
            return bl;
        }
        return Globals.getConfig().getBooleanProperty(TXNLOG_ENABLED_PROP, false);
    }

    public static boolean newTxnLogEnabled() {
        if (!StoreManager.isConfiguredFileStore()) {
            return false;
        }
        Boolean bl = newTxnLogEnabled;
        if (bl != null) {
            return bl;
        }
        return Globals.getConfig().getBooleanProperty(NEW_TXNLOG_ENABLED_PROP, false);
    }

    public static synchronized void releaseStore(boolean bl) {
        if (store != null) {
            if (!store.closed()) {
                store.close(bl);
            }
            store = null;
        }
    }

    public static Store getStoreForTonga() throws BrokerException {
        BrokerConfig brokerConfig = Globals.getConfig();
        String string = brokerConfig.getProperty(STORE_TYPE_PROP, DEFAULT_STORE_TYPE);
        if (string.equals("jdbc")) {
            brokerConfig.put("imq.persist.jdbc.lockstore.enabled", "false");
            brokerConfig.put("imq.persist.jdbc.connection.limit", "2");
        }
        return StoreManager.getStore();
    }
}

