/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.schema2beans;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.schema2beans.BaseAttribute;
import org.netbeans.modules.schema2beans.Common;

public class AttrProp
implements BaseAttribute {
    public static final int MASK_KIND = 255;
    public static final int CDATA = 1;
    public static final int ENUM = 2;
    public static final int NMTOKEN = 3;
    public static final int ID = 4;
    public static final int IDREF = 5;
    public static final int IDREFS = 6;
    public static final int ENTITY = 7;
    public static final int ENTITIES = 8;
    public static final int NOTATION = 9;
    static final String[] kinds = new String[]{"CDATA", "ENUM", "NMTOKEN", "ID", "IDREF", "IDREFS", "ENTITY", "ENTITIES", "NOTATION"};
    static final int[] kindValues = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
    public static final int MASK_OPTION = 3840;
    public static final int REQUIRED = 256;
    public static final int IMPLIED = 512;
    public static final int FIXED = 768;
    public static final int TRANSIENT = 4096;
    static final String[] options = new String[]{"#REQUIRED", "#IMPLIED", "#FIXED"};
    static final int[] optionValues = new int[]{256, 512, 768};
    String propertyName;
    String name;
    String dtdName;
    String namespace;
    int type;
    String javaType;
    ArrayList values;
    String defaultValue;
    private int state;
    private int enumMode;
    private List extraData;
    private static final int NEED_NAME = 0;
    private static final int NEED_TYPE = 1;
    private static final int NEED_ENUM = 2;
    private static final int NEED_OPTION = 3;
    private static final int NEED_DEFVAL = 4;
    private static final int NEED_VALUE = 5;
    private static final int DONE = 6;

    public AttrProp() {
        this.values = null;
        this.state = 0;
        this.type = 0;
        this.enumMode = 0;
    }

    public AttrProp(String string) {
        this();
        this.propertyName = string;
    }

    public AttrProp(String string, String string2, String string3, int n, String[] stringArray, String string4) {
        this.dtdName = string2;
        this.name = string3;
        this.propertyName = string;
        if (stringArray != null && stringArray.length > 0) {
            this.values = new ArrayList();
            for (int i = 0; i < stringArray.length; ++i) {
                this.values.add(stringArray[i]);
            }
        }
        this.defaultValue = string4;
        this.state = 6;
        this.type = n;
    }

    public int getInstance() {
        if (this.defaultValue != null) {
            return 32;
        }
        switch (this.type & 0xF00) {
            case 256: 
            case 768: {
                return 32;
            }
        }
        return 16;
    }

    public void setEnum(boolean bl) {
        this.enumMode += bl ? 1 : -1;
        if (this.enumMode == 1) {
            if (this.values == null) {
                this.values = new ArrayList();
            }
            this.type = 2;
            this.state = 2;
        } else if (this.enumMode == 0) {
            this.state = 3;
        } else {
            this.failed(Common.getMessage("WrongEnumDecl_msg"));
        }
    }

    public void addValue(String string) {
        this.addValue(string, null);
    }

    public void addValue(String string, String string2) {
        int n = string.length();
        if (string.charAt(0) == '\"') {
            if (n == 1) {
                this.failed(Common.getMessage("TooLittleDeclaration_msg", string));
            }
            string = string.substring(1, string.length() - 1);
        } else if (string.charAt(0) == '\'') {
            if (n == 1) {
                this.failed(Common.getMessage("TooLittleDeclaration_msg", string));
            }
            string = string.substring(1, string.length() - 1);
        }
        switch (this.state) {
            case 0: {
                this.dtdName = string;
                this.namespace = string2;
                this.name = Common.convertName(string);
                this.state = 1;
                break;
            }
            case 1: {
                this.type = this.stringToInt(string, kinds, kindValues);
                this.state = 3;
                if (this.type != -1) break;
                this.failed(Common.getMessage("UnknownType_msg", string));
                break;
            }
            case 2: {
                this.values.add(string);
                break;
            }
            case 3: {
                int n2 = this.stringToInt(string, options, optionValues);
                if (n2 != -1) {
                    this.type |= n2;
                    if (n2 == 768) {
                        this.state = 5;
                        break;
                    }
                    this.state = 6;
                    break;
                }
            }
            case 5: {
                this.defaultValue = string;
                this.state = 6;
                break;
            }
            case 6: {
                this.failed(Common.getMessage("TooMuchDeclaration_msg"));
            }
        }
    }

    public boolean isTransient() {
        return (this.type & 0x1000) == 4096;
    }

    public boolean isComplete() {
        return this.state == 6;
    }

    public boolean hasName(String string) {
        return string.equals(this.name) || string.equals(this.dtdName);
    }

    public String[] getValues() {
        int n = 0;
        if (this.values != null) {
            n = this.values.size();
        }
        String[] stringArray = new String[n];
        if (n > 0) {
            return this.values.toArray(stringArray);
        }
        return stringArray;
    }

    public void setDefaultValue(String string) {
        this.defaultValue = string;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getDtdName() {
        return this.dtdName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String typeAsString() {
        String string = "AttrProp." + this.intToString(this.type & 0xFF, kinds, kindValues);
        int n = this.type & 0xF00;
        if (n != 0) {
            string = string + " | AttrProp." + this.intToString(n, options, optionValues).substring(1);
        }
        return string;
    }

    String enumsToString() {
        String[] stringArray = this.getValues();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public void validate() {
        if (this.state != 6) {
            this.failed(Common.getMessage("BadAttributeDecl_msg"));
        }
    }

    public void checkEnum() {
        if (this.enumMode == 0) {
            this.failed(Common.getMessage("UseCharORWithEnum_msg"));
        }
    }

    public boolean isEnum() {
        return (this.type & 0xFF) == 2;
    }

    public boolean isFixed() {
        return (this.type & 0xF00) == 768;
    }

    public int getType() {
        return this.type & 0xFF;
    }

    public int getOption() {
        return this.type & 0xF00;
    }

    public String getJavaType() {
        return this.javaType;
    }

    public void setJavaType(String string) {
        this.javaType = string;
    }

    int stringToInt(String string, String[] stringArray, int[] nArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return nArray[i];
        }
        return -1;
    }

    String intToString(int n, String[] stringArray, int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            if (n != nArray[i]) continue;
            return stringArray[i];
        }
        return "?";
    }

    private void failed(String string) {
        throw new RuntimeException(Common.getMessage("ATTLISTParseError_msg", this.name, string));
    }

    public void addExtraData(Object object) {
        if (this.extraData == null) {
            this.extraData = new ArrayList();
        }
        this.extraData.add(object);
    }

    public List getExtraData() {
        if (this.extraData == null) {
            return Collections.EMPTY_LIST;
        }
        return this.extraData;
    }

    public String toString() {
        String string = this.dtdName + " " + this.intToString(this.type & 0xFF, kinds, kindValues) + " ";
        int n = this.type & 0xF00;
        if (n != 0) {
            string = string + this.intToString(n, options, optionValues) + " ";
        }
        if (this.values != null) {
            int n2 = this.values.size();
            string = string + "( ";
            for (int i = 0; i < n2; ++i) {
                string = string + this.values.get(i) + " ";
            }
            string = string + ") ";
        }
        if (this.defaultValue != null) {
            string = string + this.defaultValue;
        }
        if (this.isTransient()) {
            string = string + " (transient)";
        }
        if (this.javaType != null) {
            string = string + " : " + this.javaType;
        }
        return string;
    }
}

