/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.connectors.internal.api;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsClassLoaderUtil;
import com.sun.enterprise.config.serverbeans.AdminObjectResource;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.config.serverbeans.ConnectorResource;
import com.sun.enterprise.config.serverbeans.ConnectorService;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.ResourcePool;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbInterceptor;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.deployment.JmsDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.ManagedBeanDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.runtime.connector.SunConnector;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.internal.api.ConnectorClassFinder;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.config.types.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class AppSpecificConnectorClassLoaderUtil {
    @Inject
    ApplicationRegistry appRegistry;
    @Inject
    Habitat habitat;
    private Logger _logger = LogDomains.getLogger(ConnectorRuntime.class, (String)"javax.enterprise.resource.resourceadapter");

    public void detectReferredRARs(String appName) {
        ApplicationInfo appInfo = this.appRegistry.get(appName);
        if (appInfo == null) {
            throw new IllegalStateException("ApplicationInfo is not available for application [ " + appName + " ]");
        }
        Application app = (Application)appInfo.getMetaData(Application.class);
        if (!appInfo.isJavaEEApp()) {
            if (this._logger.isLoggable(Level.FINEST)) {
                this._logger.finest("Application [" + appName + "] is not a Java EE application, skipping " + "resource-adapter references detection");
            }
            return;
        }
        this.processDescriptorForRAReferences(app, (Descriptor)app);
        Set bundleDescriptors = app.getBundleDescriptors();
        for (BundleDescriptor bundleDesc : bundleDescriptors) {
            if (bundleDesc instanceof JndiNameEnvironment) {
                this.processDescriptorForRAReferences(app, (Descriptor)bundleDesc);
            }
            if (bundleDesc instanceof EjbBundleDescriptor) {
                EjbBundleDescriptor ejbDesc = (EjbBundleDescriptor)bundleDesc;
                Set ejbDescriptors = ejbDesc.getEjbs();
                for (EjbDescriptor ejbDescriptor : ejbDescriptors) {
                    EjbMessageBeanDescriptor messageBeanDesc;
                    String raMid;
                    this.processDescriptorForRAReferences(app, (Descriptor)ejbDescriptor);
                    if (!(ejbDescriptor instanceof EjbMessageBeanDescriptor) || (raMid = (messageBeanDesc = (EjbMessageBeanDescriptor)ejbDescriptor).getResourceAdapterMid()) == null) continue;
                    app.addResourceAdapter(raMid);
                }
                Set ejbInterceptors = ejbDesc.getInterceptors();
                for (EjbInterceptor ejbInterceptor : ejbInterceptors) {
                    this.processDescriptorForRAReferences(app, (Descriptor)ejbInterceptor);
                }
            }
            Set managedBeanDescriptors = bundleDesc.getManagedBeans();
            for (ManagedBeanDescriptor mbd : managedBeanDescriptors) {
                this.processDescriptorForRAReferences(app, (Descriptor)mbd);
            }
        }
    }

    public Set<String> getRARsReferredByApplication(String appName) {
        ApplicationInfo appInfo = this.appRegistry.get(appName);
        if (appInfo != null) {
            Application app = (Application)appInfo.getMetaData(Application.class);
            if (appInfo.isJavaEEApp()) {
                return app.getResourceAdapters();
            }
        }
        return new HashSet<String>();
    }

    private void processDescriptorForRAReferences(Application app, Descriptor descriptor) {
        if (descriptor instanceof JndiNameEnvironment) {
            String jndiName;
            JndiNameEnvironment jndiEnv = (JndiNameEnvironment)descriptor;
            for (Object resourceRef : jndiEnv.getResourceReferenceDescriptors()) {
                ResourceReferenceDescriptor resRefDesc = (ResourceReferenceDescriptor)resourceRef;
                jndiName = resRefDesc.getJndiName();
                if (jndiName == null) continue;
                this.detectResourceInRA(app, jndiName);
            }
            for (Object jmsDestRef : jndiEnv.getJmsDestinationReferenceDescriptors()) {
                JmsDestinationReferenceDescriptor jmsDestRefDesc = (JmsDestinationReferenceDescriptor)jmsDestRef;
                jndiName = jmsDestRefDesc.getJndiName();
                if (jndiName == null) continue;
                this.detectResourceInRA(app, jndiName);
            }
        }
    }

    private void detectResourceInRA(Application app, String jndiName) {
        Resource res = this.getResources().getResourceByName(BindableResource.class, jndiName);
        if (res != null) {
            if (ConnectorResource.class.isAssignableFrom(res.getClass())) {
                String poolName = ((ConnectorResource)res).getPoolName();
                Resource pool = this.getResources().getResourceByName(ResourcePool.class, poolName);
                if (ConnectorConnectionPool.class.isAssignableFrom(pool.getClass())) {
                    String raName = ((ConnectorConnectionPool)pool).getResourceAdapterName();
                    app.addResourceAdapter(raName);
                }
            } else if (AdminObjectResource.class.isAssignableFrom(res.getClass())) {
                String raName = ((AdminObjectResource)res).getResAdapter();
                app.addResourceAdapter(raName);
            }
        } else {
            boolean found = false;
            List applications = this.getApplications().getApplicationsWithSnifferType("connector", true);
            block0: for (com.sun.enterprise.config.serverbeans.Application application : applications) {
                String appName = application.getName();
                ApplicationInfo appInfo = this.appRegistry.get(appName);
                Application dolApp = (Application)appInfo.getMetaData(Application.class);
                Set rarDescriptors = dolApp.getRarDescriptors();
                for (ConnectorDescriptor desc : rarDescriptors) {
                    SunConnector sunraDesc = desc.getSunDescriptor();
                    if (sunraDesc != null) {
                        String sunRAJndiName = (String)sunraDesc.getResourceAdapter().getValue("JndiName");
                        if (!jndiName.equals(sunRAJndiName)) continue;
                        app.addResourceAdapter(desc.getName());
                        found = true;
                        continue block0;
                    }
                    if (!desc.getDefaultResourcesNames().contains(jndiName)) continue;
                    app.addResourceAdapter(desc.getName());
                    found = true;
                    continue block0;
                }
            }
            if (!found) {
                DOLUtils.getDefaultLogger().log(Level.FINEST, "could not find resource by name : " + jndiName);
            }
        }
    }

    public Collection<ConnectorClassFinder> getSystemRARClassLoaders() {
        try {
            return this.getConnectorsClassLoaderUtil().getSystemRARClassLoaders();
        }
        catch (ConnectorRuntimeException cre) {
            throw new RuntimeException(cre.getMessage(), cre);
        }
    }

    public boolean useGlobalConnectorClassLoader() {
        Property property;
        boolean flag = false;
        ConnectorService connectorService = this.habitat.getComponent(ConnectorService.class);
        if (connectorService != null && (property = connectorService.getProperty("access-all-rars")) != null) {
            flag = Boolean.valueOf(property.getValue());
        }
        return flag;
    }

    public Collection<String> getRequiredResourceAdapters(String appName) {
        Property property;
        ConnectorService connectorService;
        ArrayList<String> requiredRars = new ArrayList<String>();
        if (appName != null && (connectorService = this.habitat.getComponent(ConnectorService.class)) != null && appName != null && appName.trim().length() > 0 && (property = connectorService.getProperty("required-rars-for-" + appName.trim())) != null) {
            String requiredRarsString = property.getValue();
            StringTokenizer tokenizer = new StringTokenizer(requiredRarsString, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken().trim();
                requiredRars.add(token);
            }
        }
        return requiredRars;
    }

    private ConnectorsClassLoaderUtil getConnectorsClassLoaderUtil() {
        return this.habitat.getComponent(ConnectorsClassLoaderUtil.class);
    }

    private Resources getResources() {
        return this.habitat.getComponent(Resources.class);
    }

    private Applications getApplications() {
        return this.habitat.getComponent(Applications.class);
    }
}

