/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.iiop.security;

import com.sun.corba.ee.spi.legacy.interceptor.ORBInitInfoExt;
import com.sun.enterprise.iiop.security.AlternateSecurityInterceptorFactory;
import com.sun.enterprise.iiop.security.SecClientRequestInterceptor;
import com.sun.enterprise.iiop.security.SecIORInterceptor;
import com.sun.enterprise.iiop.security.SecServerRequestInterceptor;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.enterprise.iiop.api.IIOPInterceptorFactory;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Singleton;
import org.omg.CORBA.ORB;
import org.omg.IOP.Codec;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.IORInterceptor;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

@Service(name="ServerSecurityInterceptorFactory")
@Scoped(value=Singleton.class)
public class SecurityIIOPInterceptorFactory
implements IIOPInterceptorFactory {
    private static Logger _logger = null;
    private ClientRequestInterceptor creq;
    private ServerRequestInterceptor sreq;
    private SecIORInterceptor sior;
    @Inject
    private ProcessEnvironment penv;
    @Inject
    private Habitat habitat;
    @Inject(optional=true)
    private AlternateSecurityInterceptorFactory altSecFactory;

    public ClientRequestInterceptor createClientRequestInterceptor(ORBInitInfo info, Codec codec) {
        if (!this.penv.getProcessType().isServer()) {
            return null;
        }
        if (this.altSecFactory != null) {
            return this.altSecFactory.getClientRequestInterceptor(codec);
        }
        ClientRequestInterceptor ret = this.getClientInterceptorInstance(codec);
        return ret;
    }

    public ServerRequestInterceptor createServerRequestInterceptor(ORBInitInfo info, Codec codec) {
        ServerRequestInterceptor ret = null;
        try {
            if (!this.penv.getProcessType().isServer()) {
                return null;
            }
            ret = this.altSecFactory != null ? this.altSecFactory.getServerRequestInterceptor(codec) : this.getServerInterceptorInstance(codec);
            ORBInitInfoExt infoExt = (ORBInitInfoExt)info;
            IORInterceptor secIOR = this.getSecIORInterceptorInstance(codec, (ORB)infoExt.getORB());
            info.add_ior_interceptor(secIOR);
        }
        catch (DuplicateName ex) {
            _logger.log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
        return ret;
    }

    private synchronized ClientRequestInterceptor getClientInterceptorInstance(Codec codec) {
        if (this.creq == null) {
            this.creq = new SecClientRequestInterceptor("SecClientRequestInterceptor", codec, this.habitat);
        }
        return this.creq;
    }

    private synchronized ServerRequestInterceptor getServerInterceptorInstance(Codec codec) {
        if (this.sreq == null) {
            this.sreq = new SecServerRequestInterceptor("SecServerRequestInterceptor", codec, this.habitat);
        }
        return this.sreq;
    }

    private synchronized IORInterceptor getSecIORInterceptorInstance(Codec codec, ORB orb) {
        if (this.sior == null) {
            this.sior = new SecIORInterceptor(codec, this.habitat, orb);
        }
        return this.sior;
    }

    static {
        _logger = LogDomains.getLogger(SecurityIIOPInterceptorFactory.class, (String)"javax.enterprise.system.core.security");
    }
}

