/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl;

import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.util.Result;
import com.sun.enterprise.v3.services.impl.ContainerMapper;
import com.sun.enterprise.v3.services.impl.GrizzlyListener;
import com.sun.enterprise.v3.services.impl.GrizzlyService;
import com.sun.enterprise.v3.services.impl.NetworkProxy;
import com.sun.enterprise.v3.services.impl.monitor.GrizzlyMonitoring;
import com.sun.grizzly.Controller;
import com.sun.grizzly.ControllerStateListener;
import com.sun.grizzly.config.GrizzlyEmbeddedHttp;
import com.sun.grizzly.config.dom.NetworkListener;
import com.sun.grizzly.config.dom.Protocol;
import com.sun.grizzly.tcp.Adapter;
import com.sun.grizzly.tcp.StaticResourcesAdapter;
import com.sun.grizzly.util.Grizzly;
import com.sun.grizzly.util.http.mapper.Mapper;
import com.sun.hk2.component.ExistingSingletonInhabitant;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.container.EndpointRegistrationException;
import org.glassfish.api.deployment.ApplicationContainer;
import org.glassfish.internal.grizzly.V3Mapper;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.config.types.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrizzlyProxy
implements NetworkProxy {
    protected GrizzlyListener grizzlyListener;
    final Logger logger;
    final NetworkListener networkListener;
    private int portNumber;
    public static final String LEADER_FOLLOWER = "com.sun.grizzly.disableLeaderFollower";
    public static final String AUTO_CONFIGURE = "com.sun.grizzly.autoConfigure";
    private InetAddress address;
    private Inhabitant<Mapper> onePortMapper;
    private GrizzlyService grizzlyService;
    private VirtualServer vs;

    public GrizzlyProxy(GrizzlyService service, NetworkListener listener) {
        this.grizzlyService = service;
        this.logger = service.getLogger();
        this.networkListener = listener;
        String port = this.networkListener.getPort();
        this.portNumber = 8080;
        if (port == null) {
            this.logger.severe("Cannot find port information from domain.xml");
            throw new RuntimeException("Cannot find port information from domain configuration");
        }
        try {
            this.portNumber = Integer.parseInt(port);
        }
        catch (NumberFormatException e) {
            this.logger.severe("Cannot parse port value : " + port + ", using port 8080");
        }
        try {
            this.address = InetAddress.getByName(this.networkListener.getAddress());
        }
        catch (UnknownHostException ex) {
            this.logger.log(Level.SEVERE, "Unknown address " + this.address, ex);
        }
        this.configureGrizzly();
    }

    private void configureGrizzly() {
        if (!"light-weight-listener".equals(this.networkListener.getProtocol())) {
            this.registerMonitoringStatsProviders();
        }
        this.grizzlyListener = new GrizzlyListener(this.grizzlyService.getMonitoring(), new Controller(){

            public void logVersion() {
            }
        }, this.networkListener.getName());
        this.grizzlyListener.configure(this.networkListener, this.grizzlyService.habitat);
        if (!this.grizzlyListener.isGenericListener()) {
            V3Mapper mapper = new V3Mapper(this.logger);
            mapper.setPort(this.portNumber);
            mapper.setId(this.networkListener.getName());
            GrizzlyEmbeddedHttp embeddedHttp = this.grizzlyListener.getEmbeddedHttp();
            ContainerMapper adapter = new ContainerMapper(this.grizzlyService, embeddedHttp);
            adapter.setMapper((Mapper)mapper);
            adapter.setDefaultHost(this.grizzlyListener.getDefaultVirtualServer());
            adapter.configureMapper();
            embeddedHttp.setAdapter((Adapter)adapter);
            Protocol httpProtocol = this.networkListener.findHttpProtocol();
            String ct = httpProtocol.getHttp().getDefaultResponseType();
            adapter.setDefaultContentType(ct);
            if (httpProtocol != null) {
                Collection list = this.grizzlyService.getHabitat().getAllByContract(VirtualServer.class);
                String vsName = httpProtocol.getHttp().getDefaultVirtualServer();
                for (VirtualServer virtualServer : list) {
                    if (!virtualServer.getId().equals(vsName)) continue;
                    this.vs = virtualServer;
                    embeddedHttp.setWebAppRootPath(this.vs.getDocroot());
                    if (this.vs.getProperty() == null || this.vs.getProperty().isEmpty()) break;
                    for (Property p : this.vs.getProperty()) {
                        String name = p.getName();
                        if (!name.startsWith("alternatedocroot")) continue;
                        String value = p.getValue();
                        String[] mapping = value.split(" ");
                        if (mapping.length != 2) {
                            this.logger.log(Level.WARNING, "Invalid alternate_docroot " + value);
                            continue;
                        }
                        String docBase = mapping[1].substring("dir=".length());
                        String urlPattern = mapping[0].substring("from=".length());
                        try {
                            StaticResourcesAdapter a = new StaticResourcesAdapter();
                            a.setRootFolder(docBase);
                            ArrayList<String> al = GrizzlyProxy.toArray(this.vs.getHosts(), ";");
                            al.add(this.grizzlyListener.getDefaultVirtualServer());
                            this.registerEndpoint(urlPattern, (Collection<String>)al, (Adapter)a, (ApplicationContainer)null);
                        }
                        catch (EndpointRegistrationException ex) {
                            this.logger.log(Level.SEVERE, "Unable to set alternate_docroot", ex);
                        }
                    }
                }
            }
            adapter.setRootFolder(embeddedHttp.getWebAppRootPath());
            boolean autoConfigure = false;
            if (System.getProperty(AUTO_CONFIGURE) != null) {
                autoConfigure = true;
            }
            embeddedHttp.getController().setAutoConfigure(autoConfigure);
            boolean leaderFollower = false;
            if (System.getProperty(LEADER_FOLLOWER) != null) {
                leaderFollower = true;
            }
            embeddedHttp.getController().useLeaderFollowerStrategy(leaderFollower);
            this.onePortMapper = new ExistingSingletonInhabitant((Object)mapper);
            this.grizzlyService.getHabitat().addIndex(this.onePortMapper, Mapper.class.getName(), this.networkListener.getPort());
            this.grizzlyService.notifyMapperUpdateListeners(this.networkListener, (Mapper)mapper);
        }
    }

    static ArrayList<String> toArray(String list, String token) {
        String[] s = list.split(token);
        ArrayList<String> a = new ArrayList<String>();
        for (String h : s) {
            a.add(h);
        }
        return a;
    }

    @Override
    public void stop() {
        this.grizzlyListener.stop();
    }

    @Override
    public void destroy() {
        if (!this.grizzlyListener.isGenericListener()) {
            this.grizzlyService.getHabitat().removeIndex(Mapper.class.getName(), String.valueOf(this.portNumber));
            this.unregisterMonitoringStatsProviders();
        }
    }

    public String toString() {
        return "Grizzly on port " + this.networkListener.getPort();
    }

    @Override
    public void registerEndpoint(String contextRoot, Collection<String> vsServers, Adapter endpointAdapter, ApplicationContainer container) throws EndpointRegistrationException {
        if (this.grizzlyListener.isGenericListener()) {
            return;
        }
        if (endpointAdapter == null) {
            throw new EndpointRegistrationException("The endpoint adapter is null");
        }
        ((ContainerMapper)this.grizzlyListener.getEmbeddedHttp().getAdapter()).register(contextRoot, vsServers, endpointAdapter, container);
    }

    @Override
    public void unregisterEndpoint(String contextRoot, ApplicationContainer app) throws EndpointRegistrationException {
        if (this.grizzlyListener.isGenericListener()) {
            return;
        }
        ((ContainerMapper)this.grizzlyListener.getEmbeddedHttp().getAdapter()).unregister(contextRoot);
    }

    @Override
    public Future<Result<Thread>> start() {
        final GrizzlyFuture future = new GrizzlyFuture();
        final long t1 = System.currentTimeMillis();
        Thread thread = new Thread(){

            public void run() {
                try {
                    final Thread t = Thread.currentThread();
                    GrizzlyProxy.this.grizzlyListener.initEndpoint();
                    GrizzlyProxy.this.grizzlyListener.getController().addStateListener(new ControllerStateListener(){

                        public void onStarted() {
                        }

                        public void onReady() {
                            if (GrizzlyProxy.this.logger.isLoggable(Level.INFO)) {
                                GrizzlyProxy.this.logger.info("Grizzly Framework " + Grizzly.getRawVersion() + " started in: " + (System.currentTimeMillis() - t1) + "ms listening on port " + GrizzlyProxy.this.grizzlyListener.getPort());
                            }
                            future.setResult((Result<Thread>)new Result((Object)t));
                        }

                        public void onStopped() {
                        }

                        public void onException(Throwable throwable) {
                            future.setResult((Result<Thread>)new Result(throwable));
                        }
                    });
                    GrizzlyProxy.this.grizzlyListener.startEndpoint();
                }
                catch (InstantiationException e) {
                    GrizzlyProxy.this.logger.log(Level.SEVERE, "Cannot start grizzly listener", e);
                }
                catch (IOException e) {
                    GrizzlyProxy.this.logger.log(Level.SEVERE, "Cannot start grizzly listener", e);
                }
                catch (RuntimeException e) {
                    GrizzlyProxy.this.logger.log(Level.INFO, "Exception in grizzly thread", e);
                }
                catch (Throwable e) {
                    GrizzlyProxy.this.logger.log(Level.INFO, e.getMessage(), e);
                }
            }
        };
        thread.setPriority(10);
        thread.start();
        return future;
    }

    @Override
    public int getPort() {
        return this.portNumber;
    }

    protected void registerMonitoringStatsProviders() {
        String name = this.networkListener.getName();
        GrizzlyMonitoring monitoring = this.grizzlyService.getMonitoring();
        monitoring.registerThreadPoolStatsProvider(name);
        monitoring.registerKeepAliveStatsProvider(name);
        monitoring.registerFileCacheStatsProvider(name);
        monitoring.registerConnectionQueueStatsProvider(name);
    }

    protected void unregisterMonitoringStatsProviders() {
        String name = this.networkListener.getName();
        GrizzlyMonitoring monitoring = this.grizzlyService.getMonitoring();
        monitoring.unregisterThreadPoolStatsProvider(name);
        monitoring.unregisterKeepAliveStatsProvider(name);
        monitoring.unregisterFileCacheStatsProvider(name);
        monitoring.unregisterConnectionQueueStatsProvider(name);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class GrizzlyFuture
    implements Future<Result<Thread>> {
        Result<Thread> result;
        CountDownLatch latch = new CountDownLatch(1);

        public void setResult(Result<Thread> result) {
            this.result = result;
            this.latch.countDown();
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return this.latch.getCount() == 0L;
        }

        @Override
        public Result<Thread> get() throws InterruptedException {
            this.latch.await();
            return this.result;
        }

        @Override
        public Result<Thread> get(long timeout, TimeUnit unit) throws InterruptedException {
            this.latch.await(timeout, unit);
            return this.result;
        }
    }
}

