/*
 * Decompiled with CFR 0.152.
 */
package javax.help;

import com.sun.java.help.impl.JHelpPrintHandler;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Locale;
import javax.help.AbstractHelpAction;
import javax.help.HelpUtilities;
import javax.help.JHelp;
import javax.help.TreeItem;
import javax.swing.UIManager;

public class PrintAction
extends AbstractHelpAction
implements PropertyChangeListener,
ActionListener {
    private static final String NAME = "PrintAction";
    private JHelpPrintHandler handler = null;

    public PrintAction(Object control) {
        super(control, NAME);
        if (control instanceof JHelp) {
            JHelp help = (JHelp)control;
            this.handler = JHelpPrintHandler.getJHelpPrintHandler(help);
            this.handler.addPropertyChangeListener(this);
            Locale locale = null;
            try {
                locale = help.getModel().getHelpSet().getLocale();
            }
            catch (NullPointerException npe) {
                locale = Locale.getDefault();
            }
            this.putValue("tooltip", HelpUtilities.getString(locale, "tooltip.PrintAction"));
            this.putValue("access", HelpUtilities.getString(locale, "access.PrintAction"));
        }
        this.putValue("icon", UIManager.getIcon("PrintAction.icon"));
    }

    public void actionPerformed(ActionEvent event) {
        if (this.handler != null) {
            JHelp help = (JHelp)this.getControl();
            URL[] urls = null;
            TreeItem[] items = help.getSelectedItems();
            if (items != null) {
                urls = new URL[items.length];
                for (int i = 0; i < items.length; ++i) {
                    urls[i] = items[i].getURL();
                }
            }
            if (urls != null && urls.length > 0) {
                this.handler.print(urls);
            } else {
                this.handler.print(help.getModel().getCurrentURL());
            }
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("enabled")) {
            this.setEnabled((Boolean)evt.getNewValue());
        }
    }
}

