/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.server.provider;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.server.AsyncProviderCallback;
import com.sun.xml.ws.api.server.Invoker;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.server.AbstractWebServiceContext;
import com.sun.xml.ws.server.provider.ProviderArgumentsBuilder;
import com.sun.xml.ws.server.provider.ProviderInvokerTube;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AsyncProviderInvokerTube<T>
extends ProviderInvokerTube<T> {
    private static final Logger LOGGER = Logger.getLogger("javax.enterprise.resource.webservices.jaxws.server.AsyncProviderInvokerTube");

    public AsyncProviderInvokerTube(Invoker invoker, ProviderArgumentsBuilder<T> argsBuilder) {
        super(invoker, argsBuilder);
    }

    @Override
    @NotNull
    public NextAction processRequest(@NotNull Packet request) {
        Object param = this.argsBuilder.getParameter(request);
        AsyncProviderCallbackImpl callback = new AsyncProviderCallbackImpl(request);
        AsyncWebServiceContext ctxt = new AsyncWebServiceContext(this.getEndpoint(), request);
        LOGGER.fine("Invoking AsyncProvider Endpoint");
        try {
            this.getInvoker(request).invokeAsyncProvider(request, param, callback, ctxt);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            return this.doThrow(e);
        }
        return this.doSuspend();
    }

    @Override
    @NotNull
    public NextAction processResponse(@NotNull Packet response) {
        return this.doReturnWith(response);
    }

    @Override
    @NotNull
    public NextAction processException(@NotNull Throwable t) {
        throw new IllegalStateException("AsyncProviderInvokerTube's processException shouldn't be called.");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AsyncProviderCallbackImpl
    implements AsyncProviderCallback<T> {
        private final Packet request;
        private final Fiber fiber;

        public AsyncProviderCallbackImpl(Packet request) {
            this.request = request;
            this.fiber = Fiber.current();
        }

        @Override
        public void send(@Nullable T param) {
            if (param == null && this.request.transportBackChannel != null) {
                this.request.transportBackChannel.close();
            }
            Packet packet = AsyncProviderInvokerTube.this.argsBuilder.getResponse(this.request, param, AsyncProviderInvokerTube.this.getEndpoint().getPort(), AsyncProviderInvokerTube.this.getEndpoint().getBinding());
            this.fiber.resume(packet);
        }

        @Override
        public void sendError(@NotNull Throwable t) {
            RuntimeException e = t instanceof RuntimeException ? (RuntimeException)t : new RuntimeException(t);
            Packet packet = AsyncProviderInvokerTube.this.argsBuilder.getResponse(this.request, e, AsyncProviderInvokerTube.this.getEndpoint().getPort(), AsyncProviderInvokerTube.this.getEndpoint().getBinding());
            this.fiber.resume(packet);
        }
    }

    private static final class AsyncWebServiceContext
    extends AbstractWebServiceContext {
        final Packet packet;

        AsyncWebServiceContext(WSEndpoint endpoint, Packet packet) {
            super(endpoint);
            this.packet = packet;
        }

        @NotNull
        public Packet getRequestPacket() {
            return this.packet;
        }
    }
}

