/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.tcp.server;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.BindingID;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.transport.tcp.resources.MessagesMessages;
import com.sun.xml.ws.transport.tcp.server.TCPAdapter;
import com.sun.xml.ws.transport.tcp.servicechannel.ServiceChannelWSImpl;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WSTCPModule {
    private static volatile WSTCPModule instance;
    protected static final Logger logger;

    @NotNull
    public static WSTCPModule getInstance() {
        if (instance == null) {
            throw new IllegalStateException(MessagesMessages.WSTCP_0007_TRANSPORT_MODULE_NOT_INITIALIZED());
        }
        return instance;
    }

    protected static void setInstance(WSTCPModule instance) {
        WSTCPModule.instance = instance;
    }

    public WSEndpoint<ServiceChannelWSImpl> createServiceChannelEndpoint() {
        QName serviceName = WSEndpoint.getDefaultServiceName(ServiceChannelWSImpl.class);
        QName portName = WSEndpoint.getDefaultPortName(serviceName, ServiceChannelWSImpl.class);
        BindingID bindingId = BindingID.parse(ServiceChannelWSImpl.class);
        WSBinding binding = bindingId.createBinding();
        return WSEndpoint.create(ServiceChannelWSImpl.class, true, null, serviceName, portName, null, binding, null, null, null, true);
    }

    public abstract void register(@NotNull String var1, @NotNull List<TCPAdapter> var2);

    public abstract void free(@NotNull String var1, @NotNull List<TCPAdapter> var2);

    public abstract int getPort();

    static {
        logger = Logger.getLogger("com.sun.xml.ws.transport.tcp.server");
    }
}

