/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.shell.impl;

import java.io.PrintStream;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.felix.shell.Command;

public class SystemPropertiesCommandImpl
implements Command {
    private static final String REMOVE_PROP_SWITCH = "-r";

    public void execute(String line, PrintStream out, PrintStream err) {
        StringTokenizer st = new StringTokenizer(line);
        int tokens = st.countTokens();
        if (tokens == 1) {
            this.printAll(out);
        } else {
            st.nextToken();
            String secondArgument = st.nextToken();
            if (tokens == 2) {
                out.println(secondArgument + "=" + System.getProperty(secondArgument));
            } else if (tokens == 3) {
                if (REMOVE_PROP_SWITCH.equals(secondArgument)) {
                    this.removeProperty(st.nextToken());
                } else {
                    String value = st.nextToken();
                    System.setProperty(secondArgument, value);
                    out.println("Set " + secondArgument + "=" + value);
                }
            }
        }
    }

    private void printAll(PrintStream out) {
        out.println("-------System properties------");
        Iterator<Object> keyIterator = System.getProperties().keySet().iterator();
        while (keyIterator.hasNext()) {
            Object key = keyIterator.next();
            out.println(key.toString() + "=" + System.getProperty(key.toString()));
        }
    }

    private void removeProperty(String key) {
        System.getProperties().remove(key);
    }

    public String getName() {
        return "sysprop";
    }

    public String getShortDescription() {
        return "Display, set, modify and remove system properties";
    }

    public String getUsage() {
        return "sysprop [-r] [<key>] [<value>]";
    }
}

