/*
 * Decompiled with CFR 0.152.
 */
package jmaki.runtime.config;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import jmaki.runtime.AjaxException;
import jmaki.runtime.IOUtil;
import jmaki.runtime.LocalizedMessage;
import jmaki.runtime.ResourceManager;
import jmaki.runtime.config.ApiKey;
import jmaki.runtime.config.ApiKeyMap;
import jmaki.runtime.config.Config;
import jmaki.runtime.config.ConfigImpl;
import jmaki.runtime.config.ConfigUtil;
import jmaki.runtime.config.Extension;
import jmaki.runtime.config.GlueInclude;
import jmaki.runtime.config.Type;
import jmaki.runtime.config.WidgetConfig;
import jmaki.runtime.config.WidgetConfigException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GlobalConfig {
    private static final String GLOBALCONFIG = "/config.json";
    private static final String WIDGETCONFIG = "/widget.json";
    private static final String GLOBALBOOTSTRAPSCRIPT = "/jmaki-min.js";
    private HashMap globalTypes = null;
    private ApiKeyMap globalApiKeys = null;
    private HashMap widgetConfigs = new HashMap();
    private String globalTheme = null;
    private LinkedHashSet glueIncludes = null;
    private LinkedHashSet extensions = null;
    private HashMap extensionConfigs = null;
    private ResourceManager resourceManager;
    public static final Iterator NULLITERATOR = new Iterator(){

        public Object next() throws NoSuchElementException {
            throw new NoSuchElementException();
        }

        public boolean hasNext() {
            return false;
        }

        public void remove() throws IllegalStateException {
            throw new IllegalStateException("next has not been called yet");
        }
    };
    private boolean isGlobalConfigWebAppResource = false;
    private boolean isGlobalBootstrapScriptWebAppResource = false;

    public Iterator getGlueIncludes() {
        return this.glueIncludes == null ? NULLITERATOR : this.glueIncludes.iterator();
    }

    public Iterator getExtensions() {
        return this.extensions == null ? NULLITERATOR : this.extensions.iterator();
    }

    public boolean isGlobalConfigWebAppResource() {
        return this.isGlobalConfigWebAppResource;
    }

    public boolean isGlobalBootstrapScriptWebAppResource() {
        return this.isGlobalBootstrapScriptWebAppResource;
    }

    public GlobalConfig(ResourceManager resourceManager) throws AjaxException {
        this.resourceManager = resourceManager;
        URL[] globalConfigURLs = resourceManager.locateClassPathResources(resourceManager.getClassPathResourcePath() + GLOBALCONFIG);
        for (int i = 0; i < globalConfigURLs.length; ++i) {
            this.loadGlobalConfig(globalConfigURLs[i]);
        }
        if (resourceManager.isWebAppResource(resourceManager.getWebResourcePath() + GLOBALCONFIG)) {
            this.loadGlobalConfig(resourceManager.locateWebAppResource(resourceManager.getWebResourcePath() + GLOBALCONFIG));
            this.isGlobalConfigWebAppResource = true;
        }
        if (resourceManager.isWebAppResource(resourceManager.getResourcesDir() + GLOBALBOOTSTRAPSCRIPT)) {
            this.isGlobalBootstrapScriptWebAppResource = true;
        }
    }

    public Config getWidgetConfig(String widgetname, String location, boolean useWidgetConfig) throws AjaxException {
        try {
            int positionOfDot;
            WidgetConfig widgetConfig = null;
            Type type = null;
            if (location != null && (widgetConfig = (WidgetConfig)this.widgetConfigs.get(location)) == null) {
                widgetConfig = this.loadWidgetConfig(location);
                this.widgetConfigs.put(location, widgetConfig);
            }
            if (this.globalTypes != null && (type = (Type)this.globalTypes.get(widgetname)) == null && (positionOfDot = widgetname.indexOf(46)) > 0) {
                type = (Type)this.globalTypes.get(widgetname.substring(0, positionOfDot));
            }
            if ((type == null || useWidgetConfig) && widgetConfig.getType() != null) {
                type = widgetConfig.getType();
            }
            return new ConfigImpl(type, this.globalApiKeys, widgetConfig.getApiKeyMap(), this.globalTheme);
        }
        catch (Exception e) {
            String[] parameter = new String[]{widgetname, location, e.getLocalizedMessage()};
            throw new AjaxException(new LocalizedMessage("ERROR_WIDGETCONFIG", parameter), (Throwable)e);
        }
    }

    public Config getExtensionConfig(String extensionname) {
        return this.extensionConfigs == null ? null : (Config)this.extensionConfigs.get(extensionname);
    }

    public Config getGlobalIncludeConfig(String name) throws AjaxException {
        Type type = (Type)this.globalTypes.get(name);
        if (type != null) {
            return new ConfigImpl(type, this.globalApiKeys, null, this.globalTheme);
        }
        String[] parameter = new String[]{name};
        throw new AjaxException(new LocalizedMessage("ERROR_UNDEFINED_TYPE", parameter));
    }

    public void discard() {
        if (this.globalApiKeys != null) {
            this.globalApiKeys.discard();
            this.globalApiKeys = null;
        }
        if (this.globalTypes != null) {
            Iterator globalTypesIterator = this.globalTypes.entrySet().iterator();
            while (globalTypesIterator.hasNext()) {
                ((Type)globalTypesIterator.next().getValue()).discard();
            }
            this.globalTypes.clear();
            this.globalTypes = null;
        }
        if (this.widgetConfigs != null) {
            Iterator widgetConfigsIterator = this.widgetConfigs.entrySet().iterator();
            while (widgetConfigsIterator.hasNext()) {
                ((WidgetConfig)widgetConfigsIterator.next().getValue()).discard();
            }
            this.widgetConfigs.clear();
            this.widgetConfigs = null;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void loadGlobalConfig(URL url) throws AjaxException {
        InputStream is = null;
        try {
            JSONObject jAll;
            is = url.openConnection().getInputStream();
            if (is != null && (jAll = IOUtil.loadJSONObject(is)).has("config")) {
                String keytype;
                JSONObject glue;
                JSONObject dConfig = jAll.getJSONObject("config");
                if (dConfig.has("glue") && (glue = dConfig.getJSONObject("glue")).has("includes")) {
                    if (this.glueIncludes == null) {
                        this.glueIncludes = new LinkedHashSet();
                    }
                    JSONArray glueList = glue.getJSONArray("includes");
                    for (int il = 0; il < glueList.length(); ++il) {
                        GlueInclude include = this.loadGlueInclude(glueList.get(il));
                        if (include == null) continue;
                        this.glueIncludes.add(include);
                    }
                }
                if (dConfig.has("globalTheme")) {
                    this.globalTheme = dConfig.getString("globalTheme");
                }
                if (dConfig.has("types")) {
                    JSONArray typesArray = dConfig.getJSONArray("types");
                    for (int l = 0; l < typesArray.length(); ++l) {
                        JSONObject jType = typesArray.getJSONObject(l);
                        keytype = jType.getString("id");
                        if (this.globalTypes == null) {
                            this.globalTypes = new HashMap();
                        }
                        this.globalTypes.put(keytype, this.loadType(null, jType));
                    }
                }
                if (dConfig.has("apikeys")) {
                    JSONArray apikeyArray = dConfig.getJSONArray("apikeys");
                    for (int l = 0; l < apikeyArray.length(); ++l) {
                        List keyList;
                        JSONObject jApiKeys = apikeyArray.getJSONObject(l);
                        keytype = jApiKeys.getString("id");
                        if (this.globalApiKeys == null) {
                            this.globalApiKeys = new ApiKeyMap();
                        }
                        if ((keyList = this.loadApiKeys(jApiKeys, (List)this.globalApiKeys.get(keytype))) == null || this.globalApiKeys.containsKey(keytype)) continue;
                        this.globalApiKeys.put(keytype, keyList);
                    }
                }
                if (dConfig.has("extensions")) {
                    JSONArray exs = dConfig.getJSONArray("extensions");
                    for (int il = 0; il < exs.length(); ++il) {
                        Extension ex = this.loadExtension(exs.get(il));
                        if (ex == null) continue;
                        if (this.extensions == null) {
                            this.extensions = new LinkedHashSet();
                            this.extensionConfigs = new HashMap();
                        }
                        this.extensions.add(ex);
                        this.extensionConfigs.put(ex.getName(), new ConfigImpl(ex.getType(), null, null, null));
                    }
                }
            }
            if (is == null) return;
        }
        catch (JSONException ex) {
            try {
                String[] parameter = new String[]{"config.json", url.toString(), ex.getLocalizedMessage()};
                throw new WidgetConfigException(new LocalizedMessage("ERROR_PARSING_CONFIG", parameter), (Throwable)ex);
                catch (IOException ioe) {
                    parameter = new String[]{"config.json", url.toString(), ioe.getLocalizedMessage()};
                    throw new WidgetConfigException(new LocalizedMessage("ERROR_LOADING_CONFIG", parameter), (Throwable)ioe);
                }
            }
            catch (Throwable throwable) {
                if (is == null) throw throwable;
                try {
                    is.close();
                    throw throwable;
                }
                catch (IOException ioe) {
                    String[] parameter = new String[]{url.toString()};
                    throw new WidgetConfigException(new LocalizedMessage("ERROR_CLOSING_STREAM", parameter), (Throwable)ioe);
                }
            }
        }
        try {
            is.close();
            return;
        }
        catch (IOException ioe) {
            String[] parameter = new String[]{url.toString()};
            throw new WidgetConfigException(new LocalizedMessage("ERROR_CLOSING_STREAM", parameter), (Throwable)ioe);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized WidgetConfig loadWidgetConfig(String location) throws AjaxException {
        URL url = null;
        WidgetConfig widgetConfig = new WidgetConfig();
        String widgetPath = location + WIDGETCONFIG;
        if (this.resourceManager.isWebAppResource(widgetPath)) {
            url = this.resourceManager.locateWebAppResource(widgetPath);
        } else if (this.resourceManager.isClassPathResource(widgetPath)) {
            url = this.resourceManager.locateClassPathResource(widgetPath);
        }
        InputStream is = null;
        try {
            JSONObject jAll;
            if (url != null) {
                is = url.openConnection().getInputStream();
            }
            if (is != null && (jAll = IOUtil.loadJSONObject(is)).has("config")) {
                JSONArray apikeyArray;
                JSONObject dConfig = jAll.getJSONObject("config");
                if (dConfig.has("type")) {
                    JSONObject jType = dConfig.getJSONObject("type");
                    widgetConfig.setType(this.loadType(location, jType));
                }
                if (dConfig.has("apikeys") && (apikeyArray = dConfig.getJSONArray("apikeys")).length() > 0) {
                    ApiKeyMap apiKeys = new ApiKeyMap();
                    for (int l = 0; l < apikeyArray.length(); ++l) {
                        String keytype;
                        JSONObject jApiKeys = apikeyArray.getJSONObject(l);
                        List keyList = this.loadApiKeys(jApiKeys, (List)apiKeys.get(keytype = jApiKeys.getString("id")));
                        if (keyList == null || apiKeys.containsKey(keytype)) continue;
                        apiKeys.put(keytype, keyList);
                    }
                    widgetConfig.setApiKeys(apiKeys);
                }
            }
            if (is == null) return widgetConfig;
        }
        catch (JSONException ex) {
            try {
                String[] parameter = new String[]{"widget.json", url.toString(), ex.getLocalizedMessage()};
                throw new WidgetConfigException(new LocalizedMessage("ERROR_PARSING_CONFIG", parameter), (Throwable)ex);
                catch (IOException ioe) {
                    parameter = new String[]{"widget.json", url.toString(), ioe.getLocalizedMessage()};
                    throw new WidgetConfigException(new LocalizedMessage("ERROR_LOADING_CONFIG", parameter), (Throwable)ioe);
                }
            }
            catch (Throwable throwable) {
                if (is == null) throw throwable;
                try {
                    is.close();
                    throw throwable;
                }
                catch (IOException ioe) {
                    String[] parameter = new String[]{url.toString()};
                    throw new WidgetConfigException(new LocalizedMessage("ERROR_CLOSING_STREAM", parameter), (Throwable)ioe);
                }
            }
        }
        try {
            is.close();
            return widgetConfig;
        }
        catch (IOException ioe) {
            String[] parameter = new String[]{url.toString()};
            throw new WidgetConfigException(new LocalizedMessage("ERROR_CLOSING_STREAM", parameter), (Throwable)ioe);
        }
    }

    private GlueInclude loadGlueInclude(Object obj) throws JSONException {
        if (obj instanceof JSONObject) {
            JSONObject jo = (JSONObject)obj;
            return new GlueInclude(jo.getString("url"), jo.getString("lib"));
        }
        if (obj instanceof String) {
            return new GlueInclude("*", (String)obj);
        }
        return null;
    }

    private Extension loadExtension(Object obj) throws JSONException, WidgetConfigException {
        if (obj instanceof JSONObject) {
            JSONObject jo = (JSONObject)obj;
            String args = jo.has("args") ? ConfigUtil.jsonToObjectLiteral(jo.getJSONObject("args"), null).toString() : null;
            Type type = jo.has("type") ? this.loadType(null, jo.getJSONObject("type")) : null;
            String url = jo.has("url") ? jo.getString("url") : null;
            return new Extension(url, jo.getString("name"), args, type);
        }
        if (obj instanceof String) {
            return new Extension("*", (String)obj, null, null);
        }
        return null;
    }

    private Type loadType(String currentDir, JSONObject jType) throws JSONException, WidgetConfigException {
        String s;
        int il;
        JSONArray nA;
        Type type = new Type(jType.getString("id"));
        if (jType.has("includeGlobalTypes")) {
            nA = jType.getJSONArray("includeGlobalTypes");
            if (nA.length() > 0 && this.globalTypes == null) {
                throw new IllegalArgumentException("global type is null but includeGlobalTypes not null!");
            }
            for (il = 0; il < nA.length(); ++il) {
                Map themes;
                List styleList;
                String t = nA.getString(il);
                Type aType = (Type)this.globalTypes.get(t);
                if (aType == null) {
                    throw new IllegalArgumentException("the include global type:" + t + " is not exists!");
                }
                if (type.getId().equals(aType.getId())) {
                    throw new IllegalArgumentException("the include global type:" + t + "  same as current type:" + type.getId());
                }
                List libs = aType.getLibs();
                if (libs != null) {
                    if (type.getLibs() == null) {
                        type.setLibs(new ArrayList());
                    }
                    type.getLibs().addAll(libs);
                }
                if (null != (styleList = aType.getStyles())) {
                    if (type.getStyles() == null) {
                        type.setStyles(new ArrayList());
                    }
                    type.getStyles().addAll(styleList);
                }
                if (null == (themes = aType.getThemes())) continue;
                if (type.getThemes() == null) {
                    type.setThemes(new HashMap());
                }
                type.getThemes().putAll(themes);
            }
        }
        if (jType.has("styles")) {
            nA = jType.getJSONArray("styles");
            for (il = 0; il < nA.length(); ++il) {
                s = nA.getString(il);
                if (type.getStyles() == null) {
                    type.setStyles(new ArrayList());
                }
                type.getStyles().add(IOUtil.resolvePath(currentDir, s));
            }
        }
        if (jType.has("themes")) {
            nA = jType.getJSONArray("themes");
            for (il = 0; il < nA.length(); ++il) {
                JSONObject theme = nA.getJSONObject(il);
                String key = null;
                String style = null;
                if (theme.has("id")) {
                    key = theme.getString("id");
                }
                if (theme.has("style")) {
                    style = theme.getString("style");
                }
                if (theme.has("default") && theme.getBoolean("default")) {
                    type.setDefaultTheme(key);
                }
                if (type.getThemes() == null && style != null) {
                    type.setThemes(new HashMap());
                }
                type.getThemes().put(key, IOUtil.resolvePath(currentDir, style));
            }
        }
        if (jType.has("libs")) {
            nA = jType.getJSONArray("libs");
            for (il = 0; il < nA.length(); ++il) {
                s = nA.getString(il);
                if (type.getLibs() == null) {
                    type.setLibs(new ArrayList());
                }
                type.getLibs().add(IOUtil.resolvePath(currentDir, s));
            }
        }
        if (jType.has("postLoad")) {
            type.setPostLoad(jType.getString("postLoad"));
        }
        if (jType.has("preload")) {
            type.setPreLoad(jType.getString("preload"));
        } else if (jType.has("preLoad")) {
            type.setPreLoad(jType.getString("preLoad"));
        }
        if (jType.has("postload")) {
            type.setPostLoad(jType.getString("postload"));
        } else if (jType.has("postLoad")) {
            type.setPostLoad(jType.getString("postLoad"));
        }
        if (jType.has("apikey")) {
            type.setApiKeyType(jType.getString("apikey"));
        } else if (jType.has("apiKey")) {
            type.setApiKeyType(jType.getString("apiKey"));
        }
        if (jType.has("dynamicallyLoadable")) {
            type.setDynamicallyLoadable(jType.getBoolean("dynamicallyLoadable"));
        }
        return type;
    }

    private List loadApiKeys(JSONObject jApiKeys, List keyList) throws JSONException {
        JSONArray keys = jApiKeys.getJSONArray("keys");
        int keyListLen = keys.length();
        if (keyListLen > 0) {
            if (keyList == null) {
                keyList = new ArrayList<ApiKey>();
            }
            for (int k = 0; k < keyListLen; ++k) {
                JSONObject apiKey = keys.getJSONObject(k);
                String targeturl = apiKey.getString("url");
                keyList.add(new ApiKey(targeturl, apiKey.getString("key")));
            }
        }
        return keyList;
    }
}

