/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.jruby.rack;

import com.sun.grizzly.jruby.RackGrizzlyAdapter;
import com.sun.grizzly.jruby.rack.AbstractRackApplication;
import com.sun.grizzly.jruby.rack.GenericApplication;
import com.sun.grizzly.jruby.rack.JRubyRuntime;
import com.sun.grizzly.jruby.rack.MerbApplication;
import com.sun.grizzly.jruby.rack.Messages;
import com.sun.grizzly.jruby.rack.RackApplicationPool;
import com.sun.grizzly.jruby.rack.RailsApplication;
import com.sun.grizzly.jruby.rack.SinatraApplication;
import com.sun.grizzly.scripting.pool.DynamicPool;
import com.sun.grizzly.scripting.pool.DynamicPoolConfig;
import com.sun.grizzly.scripting.pool.PoolAdapter;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.scripting.jruby.common.config.JRubyConfig;
import org.glassfish.scripting.jruby.common.config.JRubyRuntimeConfig;
import org.jruby.Ruby;
import org.jruby.exceptions.RaiseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RackApplicationPoolFactory {
    public static RackApplicationPool<AbstractRackApplication> getRackApplocationPool(RackGrizzlyAdapter adapter) {
        try {
            AbstractRackApplication app = RackApplicationPoolFactory.newApplication(adapter);
            if (app.isMTSafe()) {
                return new MultithreadedRackApplicationPool(app);
            }
            return new SingleThreadedRackAppPool(app, adapter);
        }
        catch (RaiseException e) {
            adapter.config.getLogger().log(Level.SEVERE, RackApplicationPoolFactory.exceptionMessage(e), e);
            return null;
        }
    }

    private static AbstractRackApplication newApplication(RackGrizzlyAdapter adapter) {
        AbstractRackApplication app;
        String appType = adapter.config.framework().type();
        Ruby runtime = new JRubyRuntime((JRubyConfig)adapter.config).ruby;
        long startTime = System.currentTimeMillis();
        Logger logger = adapter.config.getLogger();
        if (appType.equalsIgnoreCase("rails")) {
            logger.fine("Creating RailsApplication...");
            app = new RailsApplication(runtime, adapter);
        } else if (appType.equalsIgnoreCase("merb")) {
            logger.fine("Creating MerbApplication");
            app = new MerbApplication(runtime, adapter);
        } else if (appType.equalsIgnoreCase("sinatra")) {
            logger.fine("Creating SinatraApplication");
            app = new SinatraApplication(runtime, adapter);
        } else {
            logger.fine("Creating GenericApplication");
            app = new GenericApplication(runtime, adapter);
        }
        logger.log(Level.INFO, Messages.format("newinstance.creation.time", appType, System.currentTimeMillis() - startTime));
        return app;
    }

    private static String exceptionMessage(RaiseException re) {
        StringBuilder st = new StringBuilder();
        st.append(re.getException().toString()).append("\n");
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        re.getException().printBacktrace(new PrintStream(b));
        st.append(b.toString());
        return st.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MultithreadedRackApplicationPool
    implements RackApplicationPool<AbstractRackApplication> {
        private final AbstractRackApplication app;

        public MultithreadedRackApplicationPool(AbstractRackApplication app) {
            this.app = app;
        }

        @Override
        public void shutdown() {
            this.app.destroy();
        }

        @Override
        public AbstractRackApplication getApp() {
            return this.app;
        }

        @Override
        public void returnApp(AbstractRackApplication returned) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SingleThreadedRackAppPool
    implements RackApplicationPool<AbstractRackApplication> {
        private final DynamicPoolConfig myConfig;
        private DynamicPool<AbstractRackApplication> pool;
        private final int numThreads;

        public SingleThreadedRackAppPool(AbstractRackApplication app, RackGrizzlyAdapter adapter) {
            JRubyRuntimeConfig config = adapter.config.runtimeConfig();
            this.myConfig = new DynamicPoolConfig(config.getInitRuntime(), -1, config.getMaxRuntime(), config.getMinRuntime(), -1, -1, -1, adapter.async(), false);
            this.numThreads = adapter.getNumThreads();
            RackApplicationPoolAdapter poolAdapter = new RackApplicationPoolAdapter(app, adapter);
            this.pool = new DynamicPool<AbstractRackApplication>(poolAdapter, this.myConfig);
            this.pool.start(this.numThreads);
            adapter.config.jRubyRuntimePoolProvider.runtimePoolStartEvent(adapter.config.getAppName(), adapter.config.runtimeConfig().getMinRuntime(), adapter.config.runtimeConfig().getMaxRuntime(), this.myConfig.getNumberOfObjects());
        }

        @Override
        public void shutdown() {
            this.pool.stop();
        }

        @Override
        public AbstractRackApplication getApp() {
            return this.pool.borrowObject();
        }

        @Override
        public void returnApp(AbstractRackApplication returned) {
            this.pool.returnObject(returned);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class RackApplicationPoolAdapter
        implements PoolAdapter<AbstractRackApplication> {
            private final RackGrizzlyAdapter adapter;
            private AbstractRackApplication app;
            private boolean addPreviousApp;

            private RackApplicationPoolAdapter(AbstractRackApplication app, RackGrizzlyAdapter adapter) {
                this.adapter = adapter;
                this.app = app;
                this.addPreviousApp = true;
            }

            @Override
            public AbstractRackApplication initializeObject() {
                if (this.addPreviousApp) {
                    this.addPreviousApp = false;
                    return this.app;
                }
                return RackApplicationPoolFactory.newApplication(this.adapter);
            }

            @Override
            public void dispose(AbstractRackApplication rackApplication) {
                rackApplication.destroy();
            }

            @Override
            public boolean validate(AbstractRackApplication rackApplication) {
                return true;
            }
        }
    }
}

