/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.mbeans;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.mbeans.MBeanUtils;
import org.apache.tomcat.util.modeler.Registry;

public class GlobalResourcesLifecycleListener
implements LifecycleListener {
    private static Logger log = Logger.getLogger(GlobalResourcesLifecycleListener.class.getName());
    protected Lifecycle component = null;
    protected static final Registry registry = MBeanUtils.createRegistry();
    protected int debug = 0;

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public void lifecycleEvent(LifecycleEvent event) {
        if ("start".equals(event.getType())) {
            this.component = event.getLifecycle();
            this.createMBeans();
        } else if ("stop".equals(event.getType())) {
            this.destroyMBeans();
            this.component = null;
        }
    }

    protected void createMBeans() {
        Context context = null;
        try {
            context = (Context)new InitialContext().lookup("java:/");
        }
        catch (NamingException e) {
            log.severe("No global naming context defined for server");
            return;
        }
        try {
            this.createMBeans("", context);
        }
        catch (NamingException e) {
            log.log(Level.SEVERE, "Exception processing Global JNDI Resources", e);
        }
    }

    protected void createMBeans(String prefix, Context context) throws NamingException {
        if (this.debug >= 1) {
            log.fine("Creating MBeans for Global JNDI Resources in Context '" + prefix + "'");
        }
        try {
            NamingEnumeration<Binding> bindings = context.listBindings("");
            while (bindings.hasMore()) {
                Binding binding = bindings.next();
                String name = prefix + binding.getName();
                Object value = context.lookup(binding.getName());
                if (this.debug >= 2) {
                    log.fine("Checking resource " + name);
                }
                if (!(value instanceof Context)) continue;
                this.createMBeans(name + "/", (Context)value);
            }
        }
        catch (RuntimeException ex) {
            log.log(Level.SEVERE, "RuntimeException", ex);
        }
        catch (OperationNotSupportedException ex) {
            log.log(Level.SEVERE, "Operation not supported", ex);
        }
    }

    protected void destroyMBeans() {
        if (this.debug >= 1) {
            log.fine("Destroying MBeans for Global JNDI Resources");
        }
    }

    protected void log(String message) {
        log.info(message);
    }

    protected void log(String message, Throwable throwable) {
        log.log(Level.INFO, message, throwable);
    }
}

