/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.impl;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.annotation.introspection.ClassFile;
import com.sun.enterprise.deployment.annotation.introspection.ConstantPoolInfo;
import com.sun.enterprise.deployment.annotation.introspection.DefaultAnnotationScanner;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.glassfish.apf.Scanner;
import org.glassfish.apf.impl.AnnotationUtils;
import org.glassfish.apf.impl.JavaEEScanner;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.loader.util.ASClassLoaderUtil;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.component.PostConstruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModuleScanner<T>
extends JavaEEScanner
implements Scanner<T>,
PostConstruct {
    @Inject
    DefaultAnnotationScanner defaultScanner;
    protected File archiveFile = null;
    protected ClassLoader classLoader = null;
    protected ClassFile classFile = null;
    private boolean processAllClasses = Boolean.getBoolean("com.sun.enterprise.deployment.annotation.processAllClasses");
    private Set<String> entries = new HashSet<String>();
    protected Logger logger = LogDomains.getLogger(DeploymentUtils.class, (String)"javax.enterprise.system.tools.deployment");

    public void process(ReadableArchive archiveFile, T bundleDesc, ClassLoader classLoader) throws IOException {
        File file = new File(archiveFile.getURI());
        this.process(file, bundleDesc, classLoader);
        this.completeProcess(bundleDesc, archiveFile);
    }

    protected void completeProcess(T bundleDescr, ReadableArchive archive) throws IOException {
        this.addLibraryJars(bundleDescr, archive);
    }

    @Override
    public void postConstruct() {
        this.classFile = new ClassFile(new ConstantPoolInfo(this.defaultScanner));
    }

    protected void addScanClassName(String className) {
        if (className != null && className.length() != 0) {
            this.entries.add(className);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addScanJar(File jarFile) throws IOException {
        ZipFile jf = null;
        try {
            if (!jarFile.exists()) {
                return;
            }
            jf = new JarFile(jarFile);
            Enumeration<JarEntry> entriesEnum = ((JarFile)jf).entries();
            while (entriesEnum.hasMoreElements()) {
                JarEntry je = entriesEnum.nextElement();
                if (!je.getName().endsWith(".class")) continue;
                if (this.processAllClasses) {
                    this.addEntry(je);
                    continue;
                }
                ReadableByteChannel channel = Channels.newChannel(((JarFile)jf).getInputStream(je));
                if (channel == null) continue;
                if (this.classFile.containsAnnotation(channel, je.getSize())) {
                    this.addEntry(je);
                }
                channel.close();
            }
        }
        catch (ZipException ze) {
            this.logger.log(Level.WARNING, ze.getMessage() + ": file path: " + jarFile.getPath());
        }
        finally {
            if (jf != null) {
                jf.close();
            }
        }
    }

    private void addEntry(JarEntry je) {
        String className = je.getName().replace('/', '.');
        className = className.substring(0, className.length() - 6);
        this.entries.add(className);
    }

    private void addEntry(File top, File f) {
        String fileName = f.getPath();
        fileName = fileName.substring(top.getPath().length() + 1);
        String className = fileName.replace(File.separatorChar, '.');
        className = className.substring(0, className.length() - 6);
        this.entries.add(className);
    }

    protected void addScanDirectory(File directory) throws IOException {
        this.initScanDirectory(directory, directory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initScanDirectory(File top, File directory) throws IOException {
        File[] files;
        for (File file : files = directory.listFiles()) {
            if (file.isFile()) {
                String fileName = file.getPath();
                if (!fileName.endsWith(".class")) continue;
                if (this.processAllClasses) {
                    this.addEntry(top, file);
                    continue;
                }
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(file);
                    if (!this.classFile.containsAnnotation(fis.getChannel(), file.length())) continue;
                    this.addEntry(top, file);
                    continue;
                }
                finally {
                    if (fis != null) {
                        fis.close();
                    }
                }
            }
            this.initScanDirectory(top, file);
        }
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Set<Class> getElements() {
        HashSet<Class> elements = new HashSet<Class>();
        if (this.getClassLoader() == null) {
            AnnotationUtils.getLogger().severe("Class loader null");
            return elements;
        }
        for (String className : this.entries) {
            if (AnnotationUtils.getLogger().isLoggable(Level.FINE)) {
                AnnotationUtils.getLogger().fine("Getting " + className);
            }
            try {
                elements.add(this.classLoader.loadClass(className));
            }
            catch (ClassNotFoundException cnfe) {
                AnnotationUtils.getLogger().log(Level.WARNING, "Cannot load " + className + " reason : " + cnfe.getMessage(), cnfe);
            }
        }
        return elements;
    }

    protected void addLibraryJars(T bundleDesc, ReadableArchive moduleArchive) throws IOException {
        ArrayList libraryURLs = new ArrayList();
        ModuleDescriptor moduleDesc = ((BundleDescriptor)bundleDesc).getModuleDescriptor();
        Application app = ((BundleDescriptor)moduleDesc.getDescriptor()).getApplication();
        ReadableArchive appArchive = moduleArchive.getParentArchive();
        if (app != null && appArchive != null) {
            File appRoot = new File(appArchive.getURI());
            libraryURLs.addAll(ASClassLoaderUtil.getAppLibDirLibrariesAsList((File)appRoot, (String)app.getLibraryDirectory(), null));
            Manifest manifest = ASClassLoaderUtil.getManifest((String)moduleArchive.getURI().getPath());
            libraryURLs.addAll(ASClassLoaderUtil.getManifestClassPathAsURLs((Manifest)manifest, (String)appRoot.getPath()));
        }
        for (URL url : libraryURLs) {
            try {
                this.addScanJar(new File(url.toURI()));
            }
            catch (URISyntaxException uriEx) {
                this.logger.log(Level.WARNING, "Malform URL: " + url, uriEx);
            }
        }
    }
}

