/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.flashlight.impl.core;

import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.flashlight.impl.core.FlashlightProbeProvider;
import org.glassfish.flashlight.provider.FlashlightProbe;
import org.glassfish.flashlight.provider.ProbeRegistry;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

public class ProviderImplGenerator {
    private static final Logger logger = LogDomains.getLogger(ProviderImplGenerator.class, (String)"javax.enterprise.system.tools.monitor");
    public static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ProviderImplGenerator.class);

    public String defineClass(FlashlightProbeProvider provider, Class providerClazz) {
        String generatedClassName = provider.getModuleProviderName() + "_Flashlight_" + provider.getModuleName() + "_" + "Probe_" + (provider.getProbeProviderName() == null ? providerClazz.getName() : provider.getProbeProviderName());
        generatedClassName = providerClazz.getName() + "_" + generatedClassName;
        byte[] classData = this.generateClassData(provider, providerClazz, generatedClassName);
        ProtectionDomain pd = providerClazz.getProtectionDomain();
        java.lang.reflect.Method jm = null;
        for (java.lang.reflect.Method jm2 : ClassLoader.class.getDeclaredMethods()) {
            if (!jm2.getName().equals("defineClass") || jm2.getParameterTypes().length != 5) continue;
            jm = jm2;
            break;
        }
        final java.lang.reflect.Method clM = jm;
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    if (!clM.isAccessible()) {
                        clM.setAccessible(true);
                    }
                    return null;
                }
            });
            clM.invoke((Object)providerClazz.getClassLoader(), generatedClassName, classData, 0, classData.length, pd);
            return generatedClassName;
        }
        catch (PrivilegedActionException pEx) {
            throw new RuntimeException(pEx);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (InvocationTargetException invtEx) {
            throw new RuntimeException(invtEx);
        }
    }

    public byte[] generateClassData(FlashlightProbeProvider provider, Class providerClazz, String generatedClassName) {
        Type classType = Type.getType((Class)providerClazz);
        if (logger.isLoggable(Level.FINEST)) {
            this.printd("** classType: " + classType);
            this.printd("** classDesc: " + Type.getDescriptor((Class)providerClazz));
            this.printd("Generating for: " + generatedClassName);
        }
        generatedClassName = generatedClassName.replace('.', '/');
        int cwFlags = 3;
        ClassWriter cw = new ClassWriter(cwFlags);
        int access = 17;
        String[] interfaces = new String[]{providerClazz.getName().replace('.', '/')};
        cw.visit(49, access, generatedClassName, null, "java/lang/Object", interfaces);
        for (FlashlightProbe probe : provider.getProbes()) {
            Type probeType = Type.getType(FlashlightProbe.class);
            int fieldAccess = 1;
            String fieldName = "_flashlight_" + probe.getProbeName();
            cw.visitField(fieldAccess, fieldName, probeType.getDescriptor(), null, null);
        }
        Type probeType = Type.getType(FlashlightProbe.class);
        for (FlashlightProbe probe : provider.getProbes()) {
            String methodDesc = "void " + probe.getProviderJavaMethodName();
            methodDesc = methodDesc + "(";
            String delim = "";
            for (Class paramType : probe.getParamTypes()) {
                methodDesc = methodDesc + delim + paramType.getName();
                delim = ", ";
            }
            methodDesc = methodDesc + ")";
            Method m = Method.getMethod((String)methodDesc);
            GeneratorAdapter gen = new GeneratorAdapter(1, m, null, null, (ClassVisitor)cw);
            String fieldName = "_flashlight_" + probe.getProbeName();
            gen.loadThis();
            gen.visitFieldInsn(180, generatedClassName, fieldName, probeType.getDescriptor());
            int index = gen.newLocal(probeType);
            gen.storeLocal(index);
            gen.loadLocal(index);
            gen.invokeVirtual(probeType, Method.getMethod((String)"boolean isEnabled()"));
            gen.push(true);
            Label enabledLabel = new Label();
            Label notEnabledLabel = new Label();
            gen.ifCmp(Type.getType(Boolean.TYPE), 153, enabledLabel);
            gen.goTo(notEnabledLabel);
            gen.visitLabel(enabledLabel);
            gen.loadLocal(index);
            gen.loadArgArray();
            gen.invokeVirtual(probeType, Method.getMethod((String)"void fireProbe(Object[])"));
            gen.visitLabel(notEnabledLabel);
            gen.returnValue();
            gen.endMethod();
        }
        this.generateConstructor(cw, generatedClassName, provider);
        cw.visitEnd();
        byte[] classData = cw.toByteArray();
        int index = generatedClassName.lastIndexOf(46);
        String clsName = generatedClassName.substring(index + 1);
        if (Boolean.parseBoolean(System.getenv("AS_DEBUG"))) {
            if (logger.isLoggable(Level.FINEST)) {
                this.printd("Generated ClassDATA " + clsName);
            }
            clsName = clsName.replace('.', '/');
            index = (clsName = clsName.replace('\\', '/')).lastIndexOf("/");
            if (index >= 0) {
                clsName = clsName.substring(index + 1);
            }
            try {
                String rootPath = System.getProperty("com.sun.aas.installRoot") + File.separator + "lib" + File.separator;
                String fileName = rootPath + clsName + ".class";
                if (logger.isLoggable(Level.FINEST)) {
                    this.printd("ClassFile: " + fileName);
                }
                File file = new File(fileName);
                file.getParentFile().mkdirs();
                FileOutputStream fos = new FileOutputStream(file);
                fos.write(classData);
                fos.flush();
                fos.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return classData;
    }

    private void generateConstructor(ClassWriter cw, String generatedClassName, FlashlightProbeProvider provider) {
        Method m = Method.getMethod((String)"void <init> ()");
        GeneratorAdapter gen = new GeneratorAdapter(1, m, null, null, (ClassVisitor)cw);
        gen.loadThis();
        gen.invokeConstructor(Type.getType(Object.class), m);
        Type probeRegType = Type.getType(ProbeRegistry.class);
        Type probeType = Type.getType(FlashlightProbe.class);
        gen.loadThis();
        for (FlashlightProbe probe : provider.getProbes()) {
            gen.dup();
            String fieldName = "_flashlight_" + probe.getProbeName();
            gen.push(probe.getId());
            gen.invokeStatic(probeRegType, Method.getMethod((String)"org.glassfish.flashlight.provider.FlashlightProbe getProbeById(int)"));
            gen.visitFieldInsn(181, generatedClassName, fieldName, probeType.getDescriptor());
        }
        gen.pop();
        gen.returnValue();
        gen.endMethod();
    }

    private void generateSystemOutPrintln(GeneratorAdapter mg, String msg) {
        mg.getStatic(Type.getType(System.class), "out", Type.getType(PrintStream.class));
        mg.push(msg);
        mg.invokeVirtual(Type.getType(PrintStream.class), Method.getMethod((String)"void println (String)"));
        mg.returnValue();
    }

    private void printd(String pstring) {
        logger.log(Level.FINEST, pstring);
    }
}

