/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.flashlight.xml;

import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import org.glassfish.flashlight.xml.Probe;
import org.glassfish.flashlight.xml.ProbeParam;
import org.glassfish.flashlight.xml.Provider;
import org.glassfish.flashlight.xml.StaxParser;
import org.glassfish.flashlight.xml.XmlConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProbeProviderStaxParser
extends StaxParser {
    private static final Logger logger = LogDomains.getLogger(ProbeProviderStaxParser.class, (String)"javax.enterprise.system.tools.monitor");
    public static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ProbeProviderStaxParser.class);
    private List<Provider> providers = null;

    public ProbeProviderStaxParser(File f) throws XMLStreamException {
        super(f);
    }

    public ProbeProviderStaxParser(InputStream in) throws XMLStreamException {
        super(in);
    }

    public List<Provider> getProviders() {
        if (this.providers == null) {
            try {
                this.read();
            }
            catch (Exception ex) {
                this.close();
            }
        }
        if (this.providers.isEmpty()) {
            String errStr = localStrings.getLocalString("noProviderIdentifiedFromXML", "No providers identified from the xml");
            logger.log(Level.SEVERE, errStr);
        }
        return this.providers;
    }

    @Override
    protected void read() throws XMLStreamException, StaxParser.EndDocumentException {
        this.providers = new ArrayList<Provider>();
        this.skipPast("probe-providers");
        while (true) {
            this.providers.add(this.parseProbeProvider());
        }
    }

    private Provider parseProbeProvider() throws XMLStreamException {
        if (!this.parser.getLocalName().equals(XmlConstants.PROBE_PROVIDER)) {
            String errStr = localStrings.getLocalString("invalidStartElement", "START_ELEMENT is supposed to be {0}, found: {1}", new Object[]{XmlConstants.PROBE_PROVIDER, this.parser.getLocalName()});
            throw new XMLStreamException(errStr);
        }
        Map<String, String> atts = this.parseAttributes();
        List<Probe> probes = this.parseProbes();
        return new Provider(atts.get(XmlConstants.MODULE_PROVIDER_NAME), atts.get(XmlConstants.MODULE_NAME), atts.get(XmlConstants.PROBE_PROVIDER_NAME), atts.get(XmlConstants.PROBE_PROVIDER_CLASS), probes);
    }

    private List<Probe> parseProbes() throws XMLStreamException {
        ArrayList<Probe> probes = new ArrayList<Probe>();
        boolean done = false;
        while (!done) {
            try {
                this.nextStart();
                if (this.parser.getLocalName().equals(XmlConstants.PROBE)) {
                    probes.add(this.parseProbe());
                    continue;
                }
                done = true;
            }
            catch (StaxParser.EndDocumentException ex) {
                done = true;
            }
        }
        return probes;
    }

    private Probe parseProbe() throws XMLStreamException {
        if (!this.parser.getLocalName().equals(XmlConstants.PROBE)) {
            String errStr = localStrings.getLocalString("invalidStartElement", "START_ELEMENT is supposed to be {0}, found: {1}", new Object[]{XmlConstants.PROBE, this.parser.getLocalName()});
            throw new XMLStreamException(errStr);
        }
        ArrayList<ProbeParam> params = new ArrayList<ProbeParam>();
        Map<String, String> atts = this.parseAttributes();
        String method = null;
        String name = atts.get(XmlConstants.PROBE_NAME);
        boolean self = Boolean.parseBoolean(atts.get(XmlConstants.PROBE_SELF));
        boolean hidden = Boolean.parseBoolean(atts.get(XmlConstants.PROBE_HIDDEN));
        boolean done = false;
        while (!done) {
            try {
                this.nextStart();
                String localName = this.parser.getLocalName();
                if (localName.equals(XmlConstants.METHOD)) {
                    method = this.parser.getElementText();
                    continue;
                }
                if (localName.equals(XmlConstants.PROBE_PARAM)) {
                    params.add(this.parseParam());
                    continue;
                }
                done = true;
            }
            catch (StaxParser.EndDocumentException ex) {
                done = true;
            }
        }
        return new Probe(name, method, params, self, hidden);
    }

    private ProbeParam parseParam() throws XMLStreamException {
        if (!this.parser.getLocalName().equals(XmlConstants.PROBE_PARAM)) {
            String errStr = localStrings.getLocalString("invalidStartElement", "START_ELEMENT is supposed to be {0}, found: {1}", new Object[]{XmlConstants.PROBE_PARAM, this.parser.getLocalName()});
            throw new XMLStreamException(errStr);
        }
        Map<String, String> atts = this.parseAttributes();
        return new ProbeParam(atts.get(XmlConstants.PROBE_PARAM_NAME), atts.get(XmlConstants.PROBE_PARAM_TYPE));
    }
}

