/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.util;

import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.net.tls.DefaultTrustManager;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.SSLPropertyMap;
import com.sun.messaging.jmq.util.Password;
import com.sun.messaging.jmq.util.StringUtil;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Properties;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class KeystoreUtil
implements SSLPropertyMap {
    public static final String KEYSTORE_DIR_PROP = "imq.keystore.file.dirpath";
    public static final String KEYSTORE_FILE_PROP = "imq.keystore.file.name";
    public static final String KEYSTORE_PASSWORD_PROP = "imq.keystore.password";
    private static String keystore_location = null;
    private static String pass_phrase = null;
    protected static final BrokerResources br = Globals.getBrokerResources();
    public static final String KEYSTORE_FILE = "javax.net.ssl.keyStore";
    public static final String KEYSTORE_PASSWORD = "javax.net.ssl.keyStorePassword";
    public static final String KEYSTORE_TYPE = "javax.net.ssl.keyStoreType";
    public static final String TRUSTSTORE_FILE = "javax.net.ssl.trustStore";
    public static final String TRUSTSTORE_PASSWORD = "javax.net.ssl.trustStorePassword";
    public static final String TRUSTSTORE_TYPE = "javax.net.ssl.trustStoreType";
    public static final String KEYSTORE_ALGORITHM = "ssl.KeyManagerFactory.algorithm";
    public static final String TRUSTSTORE_ALGORITHM = "ssl.TrustManagerFactory.algorithm";
    public static final String SECURESOCKET_PROTOCOL = "securesocket.protocol";

    public static void clear() {
        keystore_location = null;
        Object var0 = null;
    }

    public static String getKeystoreLocation() throws IOException {
        if (keystore_location == null) {
            BrokerConfig brokerConfig = Globals.getConfig();
            String string = System.getProperty("file.separator");
            String string2 = brokerConfig.getProperty(KEYSTORE_DIR_PROP);
            String string3 = string2 != null ? (string2 = StringUtil.expandVariables(string2, brokerConfig)) : brokerConfig.getProperty("imq.varhome") + string + "security";
            keystore_location = string3 + string + brokerConfig.getProperty(KEYSTORE_FILE_PROP);
        }
        return keystore_location;
    }

    public static String getKeystorePassword() throws IOException {
        if (pass_phrase == null) {
            Password password = null;
            BrokerConfig brokerConfig = Globals.getConfig();
            pass_phrase = brokerConfig.getProperty(KEYSTORE_PASSWORD_PROP);
            password = new Password();
            for (int i = 0; (pass_phrase == null || pass_phrase.equals("")) && i <= 5; ++i) {
                System.err.print(br.getString("B0004", KeystoreUtil.getKeystoreLocation()));
                System.err.flush();
                if (Broker.getBroker().background) {
                    System.err.print("\n");
                    break;
                }
                pass_phrase = password.getPassword();
            }
        }
        return pass_phrase;
    }

    public String mapSSLProperty(String string) {
        return string;
    }

    public static Properties getDefaultSSLContextConfig(String string, SSLPropertyMap sSLPropertyMap) throws Exception {
        if (sSLPropertyMap == null) {
            sSLPropertyMap = new KeystoreUtil();
        }
        Properties properties = new Properties();
        String string2 = KeystoreUtil.getKeystoreLocation();
        File file = new File(string2);
        if (!file.exists()) {
            throw new IOException(Globals.getBrokerResources().getKString("B3019", string2));
        }
        properties.setProperty(sSLPropertyMap.mapSSLProperty(KEYSTORE_FILE), string2);
        properties.setProperty(sSLPropertyMap.mapSSLProperty(TRUSTSTORE_FILE), string2);
        String string3 = KeystoreUtil.getKeystorePassword();
        if (string3 == null) {
            throw new IOException(Globals.getBrokerResources().getKString("B3021"));
        }
        properties.setProperty(sSLPropertyMap.mapSSLProperty(KEYSTORE_PASSWORD), string3);
        properties.setProperty(sSLPropertyMap.mapSSLProperty(TRUSTSTORE_PASSWORD), string3);
        properties.setProperty(sSLPropertyMap.mapSSLProperty(KEYSTORE_TYPE), "JKS");
        properties.setProperty(sSLPropertyMap.mapSSLProperty(TRUSTSTORE_TYPE), "JKS");
        String string4 = "SunX509";
        try {
            KeyManagerFactory.getInstance("SunX509");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            string4 = KeyManagerFactory.getDefaultAlgorithm();
            Logger logger = Globals.getLogger();
            Globals.getLogger();
            logger.log(8, string + ":" + noSuchAlgorithmException.getMessage() + ", use default KeyManagerFactory algorithm " + string4);
        }
        properties.setProperty(sSLPropertyMap.mapSSLProperty(KEYSTORE_ALGORITHM), string4);
        string4 = "SunX509";
        try {
            TrustManagerFactory.getInstance("SunX509");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            string4 = TrustManagerFactory.getDefaultAlgorithm();
            Logger logger = Globals.getLogger();
            Globals.getLogger();
            logger.log(8, string + ":" + noSuchAlgorithmException.getMessage() + ", use default TrustManagerFactory algorithm " + string4);
        }
        properties.setProperty(sSLPropertyMap.mapSSLProperty(TRUSTSTORE_ALGORITHM), string4);
        properties.setProperty(sSLPropertyMap.mapSSLProperty(SECURESOCKET_PROTOCOL), "TLS");
        return properties;
    }

    public static SSLContext getDefaultSSLContext(String string, boolean bl) throws Exception {
        Object object;
        String string2 = KeystoreUtil.getKeystoreLocation();
        File file = new File(string2);
        if (!file.exists()) {
            throw new IOException(Globals.getBrokerResources().getKString("B3019", string2));
        }
        String string3 = KeystoreUtil.getKeystorePassword();
        if (string3 == null) {
            throw new IOException(Globals.getBrokerResources().getKString("B3021"));
        }
        char[] cArray = string3.toCharArray();
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(new FileInputStream(string2), cArray);
        KeyManagerFactory keyManagerFactory = null;
        try {
            keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            object = KeyManagerFactory.getDefaultAlgorithm();
            Logger logger = Globals.getLogger();
            Globals.getLogger();
            logger.log(8, string + ":" + noSuchAlgorithmException.getMessage() + ", use default KeyManagerFactory algorithm " + (String)object);
            keyManagerFactory = KeyManagerFactory.getInstance((String)object);
        }
        keyManagerFactory.init(keyStore, cArray);
        TrustManager[] trustManagerArray = null;
        if (!bl) {
            object = null;
            try {
                object = TrustManagerFactory.getInstance("SunX509");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                String string4 = TrustManagerFactory.getDefaultAlgorithm();
                Logger logger = Globals.getLogger();
                Globals.getLogger();
                logger.log(8, string + ":" + noSuchAlgorithmException.getMessage() + ", use default TrustManagerFactory algorithm " + string4);
                object = TrustManagerFactory.getInstance(string4);
            }
            ((TrustManagerFactory)object).init(keyStore);
            trustManagerArray = ((TrustManagerFactory)object).getTrustManagers();
        } else {
            trustManagerArray = new TrustManager[]{new DefaultTrustManager()};
        }
        object = SSLContext.getInstance("TLS");
        SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
        ((SSLContext)object).init(keyManagerFactory.getKeyManagers(), trustManagerArray, secureRandom);
        return object;
    }
}

