/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.loader;

import com.sun.appserv.server.util.PreprocessorUtil;
import com.sun.enterprise.loader.JasperAdapter;
import com.sun.enterprise.util.Print;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import org.glassfish.api.deployment.InstrumentableClassLoader;
import org.jvnet.hk2.component.PreDestroy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASURLClassLoader
extends URLClassLoader
implements JasperAdapter,
InstrumentableClassLoader,
PreDestroy {
    static Logger _logger = LogDomains.getLogger(ASURLClassLoader.class, "javax.enterprise.system.core.classloading");
    private List<URLEntry> urlSet = Collections.synchronizedList(new ArrayList());
    private Map notFoundResources = new HashMap();
    private Map notFoundClasses = new HashMap();
    private boolean doneCalled = false;
    private String doneSnapshot;
    private Vector<SentinelInputStream> streams = null;
    private ArrayList<ClassFileTransformer> transformers = new ArrayList(1);
    private static StringManager sm = StringManager.getManager(ASURLClassLoader.class);

    public ASURLClassLoader() {
        super(new URL[0]);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "ClassLoader: " + this + " is getting created.");
        }
    }

    public ASURLClassLoader(ClassLoader parent) {
        super(new URL[0], parent);
    }

    public boolean isDone() {
        return this.doneCalled;
    }

    @Override
    public void preDestroy() {
        this.done();
    }

    public void done() {
        if (this.doneCalled) {
            return;
        }
        this.doneSnapshot = "ASURLClassLoader.done() called ON " + this.toString() + "\n AT " + new Date() + " \n BY :" + Print.printStackTraceToString();
        this.doneCalled = true;
        for (int i = 0; i < this.urlSet.size(); ++i) {
            URLEntry u = this.urlSet.get(i);
            if (u.zip != null) {
                try {
                    u.zip.reallyClose();
                }
                catch (IOException ioe) {
                    _logger.log(Level.INFO, ASURLClassLoader.formatMsg("loader.asurlclassloader_exc_closing_URLEntry", u.source), ioe);
                }
            }
            if (u.table != null) {
                u.table.clear();
                u.table = null;
            }
            u = null;
        }
        this.closeOpenStreams();
        if (this.urlSet != null) {
            this.urlSet.clear();
        }
        if (this.notFoundResources != null) {
            this.notFoundResources.clear();
        }
        if (this.notFoundClasses != null) {
            this.notFoundClasses.clear();
        }
        this.urlSet = null;
        this.notFoundResources = null;
        this.notFoundClasses = null;
    }

    public synchronized void appendURL(File file) throws IOException {
        try {
            this.appendURL(file.toURI().toURL());
        }
        catch (MalformedURLException mue) {
            _logger.log(Level.SEVERE, "loader.asurlclassloader_bad_url_entry", file.toURI());
            _logger.log(Level.SEVERE, "loader.asurlclassloader_malformed_url", mue);
            IOException ioe = new IOException();
            ioe.initCause(mue);
            throw ioe;
        }
    }

    @Override
    public void addURL(URL url) {
        this.appendURL(url);
    }

    public synchronized void appendURL(URL url) {
        try {
            if (url == null) {
                _logger.log(Level.INFO, "loader.asurlclassloader_bad_url_entry", url);
                return;
            }
            URLEntry entry = new URLEntry(url);
            if (!this.urlSet.contains(entry)) {
                entry.init();
                this.urlSet.add(entry);
                if (entry.isJar) {
                    this.checkManifest(entry.zip, entry.file);
                }
            } else {
                _logger.log(Level.FINE, "[ASURLClassLoader] Ignoring duplicate URL: " + url);
                if (entry.zip != null) {
                    try {
                        entry.zip.reallyClose();
                    }
                    catch (IOException ioe) {
                        _logger.log(Level.INFO, ASURLClassLoader.formatMsg("loader.asurlclassloader_exc_closing_dup_URLEntry", url), ioe);
                    }
                }
            }
            this.clearNotFoundCaches();
        }
        catch (IOException ioe) {
            _logger.log(Level.SEVERE, "loader.asurlclassloader_bad_url_entry", url);
            _logger.log(Level.SEVERE, "loader.asurlclassloader_malformed_url", ioe);
        }
    }

    @Override
    public synchronized URL[] getURLs() {
        URL[] url = null;
        if (this.urlSet != null) {
            url = new URL[this.urlSet.size()];
            for (int i = 0; i < url.length; ++i) {
                url[i] = this.urlSet.get((int)i).source;
            }
        } else {
            url = new URL[]{};
        }
        return url;
    }

    public String getClasspath() {
        StringBuffer strBuf = null;
        URL[] urls = this.getURLs();
        if (urls != null) {
            for (int i = 0; i < urls.length; ++i) {
                if (!urls[i].getProtocol().equals("file")) continue;
                if (strBuf == null) {
                    strBuf = new StringBuffer();
                }
                if (i > 0) {
                    strBuf.append(File.pathSeparator);
                }
                strBuf.append(urls[i].getFile());
            }
        }
        return strBuf != null ? strBuf.toString() : null;
    }

    public synchronized void refresh() throws IOException {
        this.clearNotFoundCaches();
    }

    public synchronized void addTransformer(ClassFileTransformer transformer) {
        this.transformers.add(transformer);
    }

    public ClassLoader copy() {
        return new DelegatingClassLoader(this);
    }

    private void clearNotFoundCaches() {
        this.notFoundResources.clear();
        this.notFoundClasses.clear();
    }

    private URL findResource0(final URLEntry res, final String name) {
        Object result = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (res.isJar) {
                    try {
                        JarEntry jarEntry = res.zip.getJarEntry(name);
                        if (jarEntry != null) {
                            InternalURLStreamHandler handler = new InternalURLStreamHandler(res, name);
                            URI uri = new URI("jar", res.source + "!/" + name, null);
                            URL ret = new URL(uri.toURL(), "", handler);
                            handler.tieUrl(ret);
                            return ret;
                        }
                    }
                    catch (Throwable thr) {
                        _logger.log(Level.INFO, "loader.excep_in_asurlclassloader", thr);
                    }
                } else {
                    try {
                        File resourceFile = new File(res.file.getCanonicalPath() + File.separator + name);
                        if (resourceFile.exists()) {
                            return resourceFile.toURL();
                        }
                    }
                    catch (IOException e) {
                        _logger.log(Level.INFO, "loader.excep_in_asurlclassloader", e);
                    }
                }
                return null;
            }
        });
        return (URL)result;
    }

    @Override
    public URL findResource(String name) {
        if (this.doneCalled) {
            _logger.log(Level.WARNING, ASURLClassLoader.formatMsg("loader.asurlclassloader_find_resource_after_done", name, this.toString()), new Throwable());
            return null;
        }
        String nf = (String)this.notFoundResources.get(name);
        if (nf != null && nf.equals(name)) {
            return null;
        }
        int i = 0;
        while (i < this.urlSet.size()) {
            URLEntry u = this.urlSet.get(i);
            if (!u.hasItem(name)) {
                ++i;
                continue;
            }
            URL url = this.findResource0(u, name);
            if (url != null) {
                return url;
            }
            ++i;
        }
        this.notFoundResources.put(name, name);
        return null;
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        if (this.doneCalled) {
            _logger.log(Level.WARNING, "loader.asurlclassloader_done_already_called", new Object[]{name, this.doneSnapshot});
            return null;
        }
        ArrayList<URL> resourcesList = new ArrayList<URL>();
        String nf = (String)this.notFoundResources.get(name);
        if (nf != null && nf.equals(name)) {
            return new Vector(resourcesList).elements();
        }
        for (URLEntry urlEntry : this.urlSet) {
            URL url = this.findResource0(urlEntry, name);
            if (url == null) continue;
            resourcesList.add(url);
        }
        if (resourcesList.size() == 0) {
            this.notFoundResources.put(name, name);
        }
        return new Vector(resourcesList).elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkManifest(JarFile jar, File file) throws IOException {
        if (jar == null || file == null) {
            return;
        }
        Manifest man = jar.getManifest();
        if (man == null) {
            return;
        }
        ASURLClassLoader aSURLClassLoader = this;
        synchronized (aSURLClassLoader) {
            String cp = man.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
            if (cp == null) {
                return;
            }
            StringTokenizer st = new StringTokenizer(cp, " ");
            while (st.hasMoreTokens()) {
                String entry = st.nextToken();
                File newFile = new File(file.getParentFile(), entry);
                try {
                    this.appendURL(newFile);
                }
                catch (MalformedURLException ex) {
                    _logger.log(Level.SEVERE, "loader.asurlclassloader_malformed_url", ex);
                }
            }
        }
    }

    private byte[] loadClassData0(final URLEntry res, final String entryName) {
        Object result = AccessController.doPrivileged(new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public Object run() {
                InputStream classStream = null;
                try {
                    if (res.isJar) {
                        ProtectedJarFile zip = res.zip;
                        JarEntry entry = zip.getJarEntry(entryName);
                        if (entry == null) return null;
                        classStream = zip.getInputStream(entry);
                        byte[] classData = ASURLClassLoader.this.getClassData(classStream);
                        res.setProtectionDomain(ASURLClassLoader.this, entry.getCertificates());
                        return classData;
                    }
                    File classFile = new File(res.file, entryName.replace('/', File.separatorChar));
                    if (!classFile.exists()) return null;
                    try {
                        classStream = new FileInputStream(classFile);
                        byte[] classData = ASURLClassLoader.this.getClassData(classStream);
                        res.setProtectionDomain(ASURLClassLoader.this, null);
                        byte[] byArray = classData;
                        return byArray;
                    }
                    finally {
                        if (classStream != null) {
                            try {
                                classStream.close();
                            }
                            catch (IOException closeIOE) {
                                _logger.log(Level.INFO, "loader.excep_in_asurlclassloader", closeIOE);
                            }
                        }
                    }
                }
                catch (IOException ioe) {
                    _logger.log(Level.INFO, "loader.excep_in_asurlclassloader", ioe);
                }
                return null;
            }
        });
        return (byte[])result;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        String packageName;
        int lastPackageSep;
        ClassData classData = this.findClassData(name);
        if (PreprocessorUtil.isPreprocessorEnabled()) {
            String entryName = name.replace('.', '/') + ".class";
            classData.classBytes = PreprocessorUtil.processClass(entryName, classData.classBytes);
        }
        if ((lastPackageSep = name.lastIndexOf(46)) != -1 && this.getPackage(packageName = name.substring(0, lastPackageSep)) == null) {
            try {
                this.definePackage(packageName, null, null, null, null, null, null, null);
            }
            catch (IllegalArgumentException iae) {
                _logger.log(Level.FINE, "duplicate package definition attempt for " + packageName, iae);
            }
        }
        try {
            ArrayList xformers = (ArrayList)this.transformers.clone();
            for (ClassFileTransformer transformer : xformers) {
                String internalClassName;
                byte[] transformedBytes = transformer.transform(this, internalClassName = name.replace('.', '/'), null, classData.pd, classData.classBytes);
                if (transformedBytes == null) continue;
                _logger.logp(Level.INFO, "ASURLClassLoader", "findClass", "{0} actually got transformed", name);
                classData.classBytes = transformedBytes;
            }
        }
        catch (IllegalClassFormatException icfEx) {
            throw new ClassNotFoundException(icfEx.toString(), icfEx);
        }
        Class<?> clazz = null;
        try {
            clazz = this.defineClass(name, classData.classBytes, 0, classData.classBytes.length, classData.pd);
            return clazz;
        }
        catch (UnsupportedClassVersionError ucve) {
            throw new UnsupportedClassVersionError(sm.getString("ejbClassLoader.unsupportedVersion", name, System.getProperty("java.version")));
        }
    }

    protected ClassData findClassData(String name) throws ClassNotFoundException {
        if (this.doneCalled) {
            _logger.log(Level.WARNING, ASURLClassLoader.formatMsg("loader.asurlclassloader_find_class_after_done", name, this.toString()), new Throwable());
            throw new ClassNotFoundException(name);
        }
        String nf = (String)this.notFoundClasses.get(name);
        if (nf != null && nf.equals(name)) {
            throw new ClassNotFoundException(name);
        }
        String entryName = name.replace('.', '/') + ".class";
        int i = 0;
        while (i < this.urlSet.size()) {
            URLEntry u = this.urlSet.get(i);
            if (!u.hasItem(entryName)) {
                ++i;
                continue;
            }
            byte[] result = this.loadClassData0(u, entryName);
            if (result != null) {
                return new ClassData(result, u.pd);
            }
            ++i;
        }
        this.notFoundClasses.put(name, name);
        throw new ClassNotFoundException(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getClassData(InputStream istream) throws IOException {
        BufferedInputStream bstream = new BufferedInputStream(istream);
        byte[] buf = new byte[4096];
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        int num = 0;
        try {
            while ((num = bstream.read(buf)) != -1) {
                bout.write(buf, 0, num);
            }
        }
        finally {
            if (bstream != null) {
                try {
                    bstream.close();
                }
                catch (IOException closeIOE) {
                    _logger.log(Level.INFO, "loader.excep_in_asurlclassloader", closeIOE);
                }
            }
        }
        return bout.toByteArray();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("ASURLClassLoader : \n");
        if (this.doneCalled) {
            buffer.append("doneCalled = true\n");
            if (this.doneSnapshot != null) {
                buffer.append("doneSnapshot = " + this.doneSnapshot);
            }
        } else {
            buffer.append("urlSet = " + this.urlSet + "\n");
            buffer.append("doneCalled = false \n");
        }
        buffer.append(" Parent -> " + this.getParent() + "\n");
        return buffer.toString();
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        InputStream stream = super.getResourceAsStream(name);
        if (stream != null && !(stream instanceof SentinelInputStream)) {
            stream = new SentinelInputStream(stream);
        }
        return stream;
    }

    private static String formatMsg(String key, Object ... args) {
        String fmt = _logger.getResourceBundle().getString(key);
        return MessageFormat.format(fmt, args);
    }

    private Vector<SentinelInputStream> getStreams() {
        if (this.streams == null) {
            this.streams = new Vector();
        }
        return this.streams;
    }

    private void closeOpenStreams() {
        if (this.streams != null) {
            SentinelInputStream[] toClose;
            for (SentinelInputStream s : toClose = this.streams.toArray(new SentinelInputStream[this.streams.size()])) {
                try {
                    s.closeWithWarning();
                }
                catch (IOException ioe) {
                    _logger.log(Level.WARNING, "loader.asurlclassloader_error_closing_stream", ioe);
                }
            }
            this.streams.clear();
            this.streams = null;
        }
    }

    private static class ClassData {
        protected byte[] classBytes;
        protected ProtectionDomain pd;

        ClassData(byte[] classData, ProtectionDomain pd) {
            this.classBytes = classData;
            this.pd = pd;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DelegatingClassLoader
    extends SecureClassLoader {
        private ASURLClassLoader delegate = null;

        DelegatingClassLoader(ASURLClassLoader applicationCL) {
            super(applicationCL.getParent());
            this.delegate = applicationCL;
        }

        protected Class findClass(String name) throws ClassNotFoundException {
            String packageName;
            ClassData classData = this.delegate.findClassData(name);
            int lastPackageSep = name.lastIndexOf(46);
            if (lastPackageSep != -1 && this.getPackage(packageName = name.substring(0, lastPackageSep)) == null) {
                try {
                    this.definePackage(packageName, null, null, null, null, null, null, null);
                }
                catch (IllegalArgumentException iae) {
                    _logger.log(Level.FINE, "duplicate package definition attempt for " + packageName, iae);
                }
            }
            Class<?> clazz = null;
            try {
                clazz = this.defineClass(name, classData.classBytes, 0, classData.classBytes.length, classData.pd);
                return clazz;
            }
            catch (UnsupportedClassVersionError ucve) {
                throw new UnsupportedClassVersionError(sm.getString("ejbClassLoader.unsupportedVersion", name, System.getProperty("java.version")));
            }
        }

        @Override
        protected URL findResource(String name) {
            return this.delegate.findResource(name);
        }

        @Override
        protected Enumeration<URL> findResources(String name) throws IOException {
            return this.delegate.findResources(name);
        }
    }

    private class InternalJarURLConnection
    extends JarURLConnection {
        private URL mURL;
        private URLEntry mRes;
        private String mName;

        public InternalJarURLConnection(URL url, URLEntry res, String name) throws MalformedURLException {
            super(url);
            this.mRes = res;
            this.mName = name;
        }

        public JarFile getJarFile() throws IOException {
            return this.mRes.zip;
        }

        public void connect() throws IOException {
        }

        public InputStream getInputStream() throws IOException {
            ZipEntry entry = this.mRes.zip.getEntry(this.mName);
            return new SentinelInputStream(this.mRes.zip.getInputStream(entry));
        }
    }

    private class InternalURLStreamHandler
    extends URLStreamHandler {
        private URL mURL;
        private URLEntry mRes;
        private String mName;

        public InternalURLStreamHandler(URLEntry res, String name) {
            this.mRes = res;
            this.mName = name;
        }

        protected URLConnection openConnection(URL u) throws IOException {
            if (u != this.mURL) {
                throw new IOException("Cannot open a foreign URL; this.url=" + this.mURL + "; foreign.url=" + u);
            }
            return new InternalJarURLConnection(u, this.mRes, this.mName);
        }

        public void tieUrl(URL url) {
            this.mURL = url;
        }
    }

    private static class ProtectedJarFile
    extends JarFile {
        public ProtectedJarFile(File file) throws IOException {
            super(file);
        }

        public void close() {
            _logger.log(Level.WARNING, "Illegal call to close() detected", new Throwable());
        }

        public void reallyClose() throws IOException {
            super.close();
        }

        protected void finalize() throws IOException {
            this.reallyClose();
        }
    }

    protected class SentinelInputStream
    extends FilterInputStream {
        private boolean closed;
        private final Throwable throwable;

        protected SentinelInputStream(InputStream in) {
            super(in);
            this.throwable = new Throwable();
            ASURLClassLoader.this.getStreams().add(this);
        }

        public void close() throws IOException {
            this._close();
        }

        protected void finalize() throws Throwable {
            if (!this.closed && this.in != null) {
                try {
                    this.in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.report();
            }
            super.finalize();
        }

        private void _close() throws IOException {
            this.closed = true;
            ASURLClassLoader.this.getStreams().remove(this);
            super.close();
        }

        private void closeWithWarning() throws IOException {
            this._close();
            this.report();
        }

        private void report() {
            _logger.log(Level.WARNING, "Input stream has been finalized or forced closed without being explicitly closed; stream instantiation reported in following stack trace", this.throwable);
        }
    }

    protected static class URLEntry {
        URL source = null;
        File file = null;
        ProtectedJarFile zip = null;
        boolean isJar = false;
        Hashtable<String, String> table = null;
        ProtectionDomain pd = null;

        URLEntry(URL url) {
            this.source = url;
        }

        void init() throws IOException {
            try {
                this.file = new File(this.source.toURI());
                this.isJar = this.file.isFile();
                if (this.isJar) {
                    this.zip = new ProtectedJarFile(this.file);
                }
                this.table = new Hashtable();
            }
            catch (URISyntaxException use) {
                IOException ioe = new IOException();
                ioe.initCause(use);
                throw ioe;
            }
        }

        private void cacheItems() throws IOException {
            if (this.isJar) {
                Enumeration<JarEntry> e = this.zip.entries();
                while (e.hasMoreElements()) {
                    ZipEntry curEntry = e.nextElement();
                    this.table.put(curEntry.getName(), curEntry.getName());
                }
            } else if (this.file.exists()) {
                this.fillTable(this.file, this.table, "");
            }
        }

        private void fillTable(File f, Hashtable t, String parent) throws IOException {
            String localName = parent.equals("") ? "" : parent + "/";
            File[] children = f.listFiles();
            for (int i = 0; i < children.length; ++i) {
                this.processFile(children[i], t, localName);
            }
        }

        private void processFile(File fileToProcess, Hashtable t, String parentLocalName) throws IOException {
            String key = parentLocalName + fileToProcess.getName();
            if (fileToProcess.isFile()) {
                t.put(key, key);
            } else if (fileToProcess.isDirectory()) {
                this.fillTable(fileToProcess, t, key);
            }
        }

        boolean hasItem(String item) {
            File targetFile;
            if (this.table.size() == 0) {
                return true;
            }
            boolean result = false;
            String target = item;
            if (item.startsWith("./")) {
                target = item.substring(2, item.length());
            }
            if (!(result = this.table.containsKey(target)) && !this.isJar && (targetFile = this.privilegedCheckForFile(target)) != null) {
                try {
                    this.processFile(targetFile, this.table, "");
                    result = true;
                }
                catch (IOException ioe) {
                    _logger.log(Level.SEVERE, ASURLClassLoader.formatMsg("loader.asurlclassloader_error_processing_file", new Object[]{target, this.file.getAbsolutePath()}), ioe);
                    return false;
                }
            }
            return result;
        }

        private File privilegedCheckForFile(final String targetPath) {
            try {
                File result = (File)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        File targetFile = new File(URLEntry.this.file, targetPath);
                        if (!targetFile.exists()) {
                            targetFile = null;
                        }
                        return targetFile;
                    }
                });
                return result;
            }
            catch (PrivilegedActionException pae) {
                _logger.log(Level.SEVERE, ASURLClassLoader.formatMsg("loader.asurlclassloader_error_checking_existence", new Object[]{targetPath, this.file.getAbsolutePath()}), pae.getCause());
                return null;
            }
        }

        public void setProtectionDomain(ClassLoader ejbClassLoader, Certificate[] signers) throws MalformedURLException {
            if (this.pd == null) {
                this.pd = new ProtectionDomain(new CodeSource(this.file.toURL(), signers), null, ejbClassLoader, null);
            }
        }

        public String toString() {
            return "URLEntry : " + this.source.toString();
        }

        public boolean equals(Object obj) {
            boolean tf = false;
            if (obj instanceof URLEntry) {
                URLEntry e = (URLEntry)obj;
                if (this.source.equals(e.source)) {
                    tf = true;
                }
            }
            return tf;
        }

        public int hashCode() {
            return this.source.hashCode();
        }
    }
}

