/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.introspector.jlr;

import java.lang.reflect.Field;
import javax.enterprise.inject.spi.AnnotatedField;
import org.jboss.weld.introspector.AnnotationStore;
import org.jboss.weld.introspector.WeldClass;
import org.jboss.weld.introspector.WeldField;
import org.jboss.weld.introspector.jlr.AbstractWeldMember;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeldFieldImpl<T, X>
extends AbstractWeldMember<T, X, Field>
implements WeldField<T, X> {
    private final Field field;
    private final String toString;

    public static <T, X> WeldFieldImpl<T, X> of(Field field, WeldClass<X> declaringClass, ClassTransformer classTransformer) {
        AnnotationStore annotationStore = AnnotationStore.of(field, classTransformer.getTypeStore());
        return new WeldFieldImpl<T, X>(Reflections.ensureAccessible(field), annotationStore, declaringClass, classTransformer);
    }

    public static <T, X> WeldFieldImpl<T, X> of(AnnotatedField<? super X> annotatedField, WeldClass<X> declaringClass, ClassTransformer classTransformer) {
        AnnotationStore annotationStore = AnnotationStore.of(annotatedField.getAnnotations(), annotatedField.getAnnotations(), classTransformer.getTypeStore());
        return new WeldFieldImpl<T, X>(Reflections.ensureAccessible(annotatedField.getJavaMember()), annotationStore, declaringClass, classTransformer);
    }

    private WeldFieldImpl(Field field, AnnotationStore annotationStore, WeldClass<X> declaringClass, ClassTransformer classTransformer) {
        super(annotationStore, field, field.getType(), field.getGenericType(), declaringClass);
        this.field = field;
        this.toString = "field " + declaringClass.getName() + "." + field.getName();
    }

    public Field getAnnotatedField() {
        return this.field;
    }

    @Override
    public Field getDelegate() {
        return this.field;
    }

    @Override
    public void set(Object instance, Object value) throws IllegalArgumentException, IllegalAccessException {
        this.field.set(instance, value);
    }

    public void setOnInstance(Object instance, Object value) throws IllegalArgumentException, SecurityException, IllegalAccessException, NoSuchFieldException {
        instance.getClass().getField(this.getName()).set(instance, value);
    }

    @Override
    public T get(Object instance) {
        return (T)Reflections.getAndWrap(this.getDelegate(), instance);
    }

    @Override
    public String getPropertyName() {
        return this.getName();
    }

    @Override
    public String toString() {
        return this.toString;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof WeldField) {
            WeldField that = (WeldField)other;
            return this.getDeclaringType().equals(that.getDeclaringType()) && this.getName().equals(that.getName());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getDelegate().hashCode();
    }
}

