/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.server.core;

import com.sun.enterprise.deploy.shared.ArchiveFactory;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.appclient.server.core.AppClientDeployerHelper;
import org.glassfish.appclient.server.core.jws.JavaWebStartInfo;
import org.glassfish.appclient.server.core.jws.servedcontent.ASJarSigner;
import org.glassfish.appclient.server.core.jws.servedcontent.AutoSignedContent;
import org.glassfish.appclient.server.core.jws.servedcontent.FixedContent;
import org.glassfish.appclient.server.core.jws.servedcontent.StaticContent;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationSignedJARManager {
    private final Map<URI, Collection<String>> relURIToSigningAliases = new HashMap<URI, Collection<String>>();
    private final Map<String, Collection<URI>> signingAliasToRelURIs = new HashMap<String, Collection<URI>>();
    private Map<String, Map<URI, StaticContent>> selectedAliasToContentMapping = null;
    private final ArchiveFactory archiveFactory;
    private final String autoSigningAlias;
    private final ASJarSigner jarSigner;
    private final URI EARDirectoryServerURI;
    private final DeploymentContext dc;
    private final AppClientDeployerHelper helper;
    private final Map<URI, StaticContent> relURIToContent = new HashMap<URI, StaticContent>();

    public ApplicationSignedJARManager(String autoSigningAlias, ASJarSigner jarSigner, Habitat habitat, DeploymentContext dc, AppClientDeployerHelper helper, URI EARDirectoryServerURI, URI EARDirectoryUserURI) {
        this.autoSigningAlias = autoSigningAlias;
        this.jarSigner = jarSigner;
        this.EARDirectoryServerURI = EARDirectoryServerURI;
        this.archiveFactory = habitat.getComponent(ArchiveFactory.class);
        this.dc = dc;
        this.helper = helper;
    }

    public URI addJAR(URI absJARURI) throws IOException {
        Map.Entry<URI, StaticContent> result;
        URI archiveURI = absJARURI;
        File f = new File(absJARURI);
        try {
            JarFile jf = new JarFile(f);
            jf.close();
            archiveURI = URI.create("jar:" + absJARURI.getRawSchemeSpecificPart());
        }
        catch (IOException e) {
            // empty catch block
        }
        ReadableArchive arch = this.archiveFactory.openArchive(archiveURI);
        if (!this.isArchiveSigned(arch)) {
            result = this.autoSignedAppContentEntry(absJARURI);
            this.updateAliasToURIs(result.getKey(), this.autoSigningAlias);
            this.updateURIToAliases(result.getKey(), this.autoSigningAlias);
        } else {
            result = this.developerSignedAppContentEntry(absJARURI);
            ArrayList<String> aliasesUsedToSignJAR = new ArrayList<String>();
            Enumeration entryNames = arch.entries("META-INF/");
            while (entryNames.hasMoreElements()) {
                String entryName = (String)entryNames.nextElement();
                String alias = this.signatureEntryName(entryName);
                this.updateURIToAliases(result.getKey(), alias);
            }
            this.addAliasToURIsEntry(result.getKey(), aliasesUsedToSignJAR);
        }
        arch.close();
        return result.getKey();
    }

    public Map<String, Map<URI, StaticContent>> aliasToContent() {
        if (this.selectedAliasToContentMapping == null) {
            this.selectedAliasToContentMapping = this.pruneMaps();
        }
        return this.selectedAliasToContentMapping;
    }

    private void addAliasToURIsEntry(URI relURI, Collection<String> aliases) throws IOException {
        this.relURIToSigningAliases.put(relURI, aliases);
        for (String alias : aliases) {
            this.updateAliasToURIs(relURI, alias);
        }
    }

    private void updateURIToAliases(URI relURI, String alias) throws IOException {
        Collection<String> aliasesForJAR = this.relURIToSigningAliases.get(relURI);
        if (aliasesForJAR == null) {
            aliasesForJAR = new ArrayList<String>();
            this.relURIToSigningAliases.put(relURI, aliasesForJAR);
        }
        aliasesForJAR.add(alias);
    }

    private void updateAliasToURIs(URI relURI, String alias) throws IOException {
        Collection<URI> urisForAlias = this.signingAliasToRelURIs.get(alias);
        if (urisForAlias == null) {
            urisForAlias = new ArrayList<URI>();
            this.signingAliasToRelURIs.put(alias, urisForAlias);
        }
        urisForAlias.add(relURI);
    }

    private Map.Entry<URI, StaticContent> developerSignedAppContentEntry(URI absURIToFile) {
        URI jarURIRelativeToApp = this.EARDirectoryServerURI.relativize(absURIToFile);
        StaticContent content = this.relURIToContent.get(absURIToFile);
        if (content == null) {
            content = new FixedContent(new File(absURIToFile));
            this.relURIToContent.put(jarURIRelativeToApp, content);
        }
        return new AbstractMap.SimpleEntry<URI, StaticContent>(jarURIRelativeToApp, content);
    }

    private synchronized Map.Entry<URI, StaticContent> autoSignedAppContentEntry(URI absURIToFile) {
        URI jarURIRelativeToApp = this.EARDirectoryServerURI.relativize(absURIToFile);
        StaticContent content = this.relURIToContent.get(jarURIRelativeToApp);
        if (content == null) {
            File unsignedFile = new File(absURIToFile);
            File signedFile = this.signedFileForLib(jarURIRelativeToApp, unsignedFile);
            content = new AutoSignedContent(unsignedFile, signedFile, this.autoSigningAlias, this.jarSigner);
            this.relURIToContent.put(jarURIRelativeToApp, content);
        } else if (content instanceof AutoSignedContent) {
            content = (StaticContent)AutoSignedContent.class.cast(content);
        } else {
            throw new RuntimeException(content.toString() + " != AutoSignedContent");
        }
        return new AbstractMap.SimpleEntry<URI, StaticContent>(jarURIRelativeToApp, content);
    }

    private File signedFileForLib(URI relURI, File unsignedFile) {
        return JavaWebStartInfo.signedFileForProvidedAppFile(relURI, unsignedFile, this.helper, this.dc);
    }

    private String signatureEntryName(String entryName) {
        int firstSlash = entryName.indexOf(47);
        int lastSlash = entryName.lastIndexOf(47);
        return entryName.startsWith("META-INF/") && firstSlash == lastSlash && firstSlash != -1 && entryName.endsWith(".SF") ? entryName.substring(firstSlash + 1, entryName.indexOf(".SF")) : null;
    }

    private boolean isArchiveSigned(ReadableArchive arch) throws IOException {
        Manifest archiveMF = arch.getManifest();
        Map<String, Attributes> perEntryAttrs = archiveMF.getEntries();
        boolean jarIsSigned = false;
        Iterator<Map.Entry<String, Attributes>> i$ = perEntryAttrs.entrySet().iterator();
        if (i$.hasNext()) {
            Map.Entry<String, Attributes> entry = i$.next();
            for (Object attrKey : entry.getValue().keySet()) {
                if (!((String)attrKey).contains("-Digest-")) continue;
                jarIsSigned = true;
                break;
            }
        }
        return jarIsSigned;
    }

    private Map<String, Map<URI, StaticContent>> pruneMaps() {
        HashSet<URI> processedJARs = new HashSet<URI>();
        HashMap<String, Map<URI, StaticContent>> selectedAliases = new HashMap<String, Map<URI, StaticContent>>();
        for (Map.Entry<URI, Collection<String>> entry : this.relURIToSigningAliases.entrySet()) {
            if (processedJARs.contains(entry.getKey()) || entry.getValue().size() != 1) continue;
            this.processURI(processedJARs, selectedAliases, entry.getKey(), entry.getValue().iterator().next());
        }
        for (Map.Entry<URI, Collection<String>> entry : this.relURIToSigningAliases.entrySet()) {
            if (processedJARs.contains(entry.getKey())) continue;
            this.processURI(processedJARs, selectedAliases, entry.getKey(), entry.getValue());
        }
        return selectedAliases;
    }

    private void processURI(Set<URI> processedJARs, Map<String, Map<URI, StaticContent>> selectedAliases, URI relURI, String alias) {
        Map<URI, StaticContent> urisForSelectedAlias = selectedAliases.get(alias);
        if (urisForSelectedAlias == null) {
            urisForSelectedAlias = new HashMap<URI, StaticContent>();
            selectedAliases.put(alias, urisForSelectedAlias);
        }
        urisForSelectedAlias.put(relURI, this.relURIToContent.get(relURI));
        processedJARs.add(relURI);
        for (URI otherURI : this.signingAliasToRelURIs.get(alias)) {
            urisForSelectedAlias.put(otherURI, this.relURIToContent.get(otherURI));
            processedJARs.add(otherURI);
        }
    }

    private void processURI(Set<URI> processedJARs, Map<String, Map<URI, StaticContent>> selectedAliases, URI uri, Collection<String> aliases) {
        this.processURI(processedJARs, selectedAliases, uri, aliases.iterator().next());
    }
}

