/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.server.core;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.archivist.AppClientArchivist;
import com.sun.enterprise.deployment.deploy.shared.InputJarArchive;
import com.sun.enterprise.deployment.deploy.shared.Util;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.deployment.util.XModuleType;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.glassfish.api.ActionReport;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.appclient.server.core.AppClientDeployerHelper;
import org.glassfish.appclient.server.core.ApplicationSignedJARManager;
import org.glassfish.appclient.server.core.jws.JWSAdapterManager;
import org.glassfish.appclient.server.core.jws.JavaWebStartInfo;
import org.glassfish.appclient.server.core.jws.servedcontent.ASJarSigner;
import org.glassfish.appclient.server.core.jws.servedcontent.DynamicContent;
import org.glassfish.appclient.server.core.jws.servedcontent.FixedContent;
import org.glassfish.appclient.server.core.jws.servedcontent.StaticContent;
import org.glassfish.appclient.server.core.jws.servedcontent.TokenHelper;
import org.glassfish.deployment.common.DownloadableArtifacts;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NestedAppClientDeployerHelper
extends AppClientDeployerHelper {
    private static final String V2_COMPATIBILITY = "v2";
    private static final String LIBRARY_SECURITY_PROPERTY_NAME = "library.security";
    private static final String LIBRARY_JARS_PROPERTY_NAME = "library.jars";
    private static final String LIBRARY_JNLP_PATH_PROPERTY_NAME = "library.jnlp.path";
    private static final String LIBRARY_DOCUMENT_TEMPLATE = "/org/glassfish/appclient/server/core/jws/templates/libraryJarsDocumentTemplate.jnlp";
    private StringBuilder classPathForFacade = new StringBuilder();
    private StringBuilder PUScanTargetsForFacade = new StringBuilder();
    private final URI earURI;
    private final ASJarSigner jarSigner;
    private ApplicationSignedJARManager signedJARManager;
    private StringBuilder libExtensionElementsForMainDocument = null;
    private static Logger logger = LogDomains.getLogger(NestedAppClientDeployerHelper.class, (String)"javax.enterprise.system.container.appclient");
    private final Set<DownloadableArtifacts.FullAndPartURIs> clientLevelDownloads = new HashSet<DownloadableArtifacts.FullAndPartURIs>();
    private final Set<DownloadableArtifacts.FullAndPartURIs> earLevelDownloads = new HashSet<DownloadableArtifacts.FullAndPartURIs>();
    private final Habitat habitat;
    private static final Pattern submoduleURIPattern = Pattern.compile("(.*)_([wcrj]ar)$");

    NestedAppClientDeployerHelper(DeploymentContext dc, ApplicationClientDescriptor bundleDesc, AppClientArchivist archivist, ClassLoader gfClientModuleClassLoader, Application application, Habitat habitat, ASJarSigner jarSigner) throws IOException {
        super(dc, bundleDesc, archivist, gfClientModuleClassLoader, application);
        this.habitat = habitat;
        this.jarSigner = jarSigner;
        this.earURI = dc.getSource().getParentArchive().getURI();
        this.processDependencies();
    }

    @Override
    public FixedContent fixedContentWithinEAR(String uriString) {
        return new FixedContent(new File(this.earDirUserURI(this.dc()).resolve(uriString)));
    }

    public String appLibraryExtensions() {
        return this.libExtensionElementsForMainDocument == null ? "" : this.libExtensionElementsForMainDocument.toString();
    }

    @Override
    public Map<String, Map<URI, StaticContent>> signingAliasToJar() {
        return this.signedJARManager.aliasToContent();
    }

    @Override
    public void createAndAddLibraryJNLPs(AppClientDeployerHelper helper, TokenHelper tHelper, Map<String, DynamicContent> dynamicContent) throws IOException {
        this.libExtensionElementsForMainDocument = new StringBuilder();
        for (Map.Entry<String, Map<URI, StaticContent>> aliasToContentEntry : this.signingAliasToJar().entrySet()) {
            String alias = aliasToContentEntry.getKey();
            Map<URI, StaticContent> libURIs = aliasToContentEntry.getValue();
            tHelper.setProperty(LIBRARY_SECURITY_PROPERTY_NAME, this.librarySecurity(alias));
            tHelper.setProperty(LIBRARY_JNLP_PATH_PROPERTY_NAME, this.libJNLPRelPath(alias));
            StringBuilder libJarElements = new StringBuilder();
            for (Map.Entry<URI, StaticContent> entry : libURIs.entrySet()) {
                URI uri = entry.getKey();
                libJarElements.append("<jar href=\"" + this.libJARRelPath(uri) + "\"/>");
            }
            tHelper.setProperty(LIBRARY_JARS_PROPERTY_NAME, libJarElements.toString());
            JavaWebStartInfo.createAndAddDynamicContent(tHelper, dynamicContent, this.libJNLPRelPath(alias), LIBRARY_DOCUMENT_TEMPLATE);
            this.libExtensionElementsForMainDocument.append(this.extensionElement(alias, this.libJNLPRelPath(alias)));
        }
        tHelper.setProperty("app.library.extension", this.libExtensionElementsForMainDocument.toString());
    }

    private String libJARRelPath(URI absURI) {
        return JavaWebStartInfo.relativeURIForProvidedOrGeneratedAppFile(this.dc(), absURI, this).toASCIIString();
    }

    private String extensionElement(String alias, String libURIText) {
        return "<extension name=\"libJars" + (alias == null ? "" : "-" + alias) + "\" href=\"" + libURIText + "\"/>";
    }

    private String librarySecurity(String alias) {
        return alias == null ? "" : "<security><all-permissions/></security>";
    }

    private String libJNLPRelPath(String alias) {
        return "___lib/client-libs" + (alias == null ? "" : "-" + alias) + ".jnlp";
    }

    private void processDependencies() throws IOException {
        this.signedJARManager = new ApplicationSignedJARManager(JWSAdapterManager.signingAlias(this.dc()), this.jarSigner, this.habitat, this.dc(), this, this.earURI, this.earDirUserURI(this.dc()));
        URI appClientURI = URI.create(Util.getURIName((URI)this.appClientUserURI(this.dc())));
        this.classPathForFacade.append(appClientURI);
        this.clientLevelDownloads.add(new DownloadableArtifacts.FullAndPartURIs(this.facadeServerURI(this.dc()), this.facadeUserURI(this.dc())));
        HashSet<URI> dependencyURIsProcessed = new HashSet<URI>();
        String appClientURIWithinEAR = this.appClientDesc().getModuleDescriptor().getArchiveUri();
        this.processDependencies(this.earURI, URI.create(appClientURIWithinEAR), this.earLevelDownloads, dependencyURIsProcessed, appClientURI, false);
        this.addLibraryJARs(this.classPathForFacade, this.PUScanTargetsForFacade, dependencyURIsProcessed);
        if (this.useV2Compatibility() && !this.appClientDesc().getApplication().isVirtual()) {
            this.addEJBJARs(this.classPathForFacade, dependencyURIsProcessed);
            this.addTopLevelJARs(this.classPathForFacade, this.PUScanTargetsForFacade, dependencyURIsProcessed);
        }
    }

    private boolean useV2Compatibility() {
        String compat = this.dc().getAppProps().getProperty("compatibility");
        return compat != null && compat.equals(V2_COMPATIBILITY);
    }

    private void addEJBJARs(StringBuilder cpForFacade, Set<URI> dependencyURIsProcessed) throws IOException {
        Application app = this.appClientDesc().getApplication();
        for (ModuleDescriptor<BundleDescriptor> md : app.getModuleDescriptorsByType(XModuleType.EJB)) {
            this.addJar(cpForFacade, null, new File(new File(this.earURI), md.getArchiveUri()).toURI(), dependencyURIsProcessed);
        }
    }

    private void addTopLevelJARs(StringBuilder cpForFacade, StringBuilder puScanTargets, Set<URI> dependencyURIsProcessed) throws IOException {
        final HashSet<URI> submoduleURIs = new HashSet<URI>();
        for (ModuleDescriptor<BundleDescriptor> md : this.appClientDesc().getApplication().getModules()) {
            submoduleURIs.add(URI.create(md.getArchiveUri()));
        }
        this.addJARsFromDir(cpForFacade, puScanTargets, dependencyURIsProcessed, new File(this.earURI), new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".jar") && !pathname.isDirectory() && !submoduleURIs.contains(NestedAppClientDeployerHelper.this.earURI.relativize(pathname.toURI()));
            }
        });
    }

    private void addJARsFromDir(StringBuilder cpForFacade, StringBuilder puScanTargets, Set<URI> dependencyURIsProcessed, File dirContainingJARs, FileFilter filter) throws IOException {
        if (dirContainingJARs.exists() && dirContainingJARs.isDirectory()) {
            for (File jar : dirContainingJARs.listFiles(filter)) {
                this.addJar(cpForFacade, puScanTargets, jar.toURI(), dependencyURIsProcessed);
            }
        }
    }

    private void addLibraryJARs(StringBuilder cpForFacade, StringBuilder puScanTargets, Set<URI> dependencyURIsProcessed) throws IOException {
        String libDir = this.appClientDesc().getApplication().getLibraryDirectory();
        if (libDir != null) {
            this.addJARsFromDir(cpForFacade, puScanTargets, dependencyURIsProcessed, new File(new File(this.earURI), libDir), new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.getName().endsWith(".jar") && !pathname.isDirectory();
                }
            });
        }
    }

    private void addJar(StringBuilder cpForFacade, StringBuilder puScanTargets, URI jarURI, Set<URI> dependencyURIsProcessed) throws IOException {
        URI jarURIForFacade = this.earURI.relativize(jarURI);
        URI fileURIForJAR = URI.create("file:" + jarURI.getRawSchemeSpecificPart());
        if (dependencyURIsProcessed.contains(fileURIForJAR)) {
            return;
        }
        if (cpForFacade.length() > 0) {
            cpForFacade.append(' ');
        }
        cpForFacade.append(jarURIForFacade.toASCIIString());
        if (puScanTargets != null) {
            if (puScanTargets.length() > 0) {
                puScanTargets.append(' ');
            }
            puScanTargets.append(jarURIForFacade.toASCIIString());
        }
        this.processDependencies(this.earURI, fileURIForJAR, this.earLevelDownloads, dependencyURIsProcessed, jarURIForFacade, true);
    }

    private void processDependencies(URI baseURI, URI dependencyURI, Set<DownloadableArtifacts.FullAndPartURIs> downloads, Set<URI> dependencyURIsProcessed, URI containingJARURI, boolean isDependencyALibrary) throws IOException {
        if (dependencyURIsProcessed.contains(dependencyURI)) {
            return;
        }
        URI dependencyFileURI = baseURI.resolve(dependencyURI);
        String scheme = dependencyFileURI.getScheme();
        if (scheme != null && scheme.equals("jar")) {
            dependencyFileURI = URI.create("file:" + dependencyFileURI.getRawSchemeSpecificPart());
        } else {
            if (scheme == null) {
                scheme = "file";
            }
            dependencyFileURI = URI.create(scheme + ":" + dependencyFileURI.getRawSchemeSpecificPart());
        }
        File dependentFile = new File(dependencyFileURI);
        if (!dependentFile.exists()) {
            if (this.isSubmodule(dependencyURI)) {
                dependentFile = this.JAROfExpandedSubmodule(dependencyURI);
                dependencyFileURI = dependentFile.toURI();
            } else {
                return;
            }
        }
        if (!dependentFile.exists()) {
            return;
        }
        if (dependentFile.isDirectory() && !this.isSubmodule(dependencyURI)) {
            if (!dependencyURI.getPath().endsWith("/")) {
                String format = logger.getResourceBundle().getString("enterprise.deployment.appclient.dirURLnoSlash");
                String msg = MessageFormat.format(format, dependencyURI.getPath(), containingJARURI.toASCIIString());
                logger.log(Level.WARNING, msg);
                ActionReport warning = this.dc().getActionReport();
                warning.setMessage(msg);
                warning.setActionExitCode(ActionReport.ExitCode.WARNING);
            } else {
                this.processDependentDirectory(dependentFile, baseURI, dependencyURIsProcessed, downloads);
            }
        } else {
            this.processDependentJAR(dependentFile, baseURI, dependencyURI, dependencyFileURI, dependencyURIsProcessed, downloads, containingJARURI, isDependencyALibrary);
        }
    }

    private void processDependentDirectory(File dependentDirFile, URI baseURI, Set<URI> dependencyURIsProcessed, Set<DownloadableArtifacts.FullAndPartURIs> downloads) throws IOException {
        for (File f : dependentDirFile.listFiles()) {
            if (f.isDirectory()) {
                this.processDependentDirectory(f, baseURI, dependencyURIsProcessed, downloads);
                continue;
            }
            URI dependencyFileURI = f.toURI();
            this.signedJARManager.addJAR(f.toURI());
            DownloadableArtifacts.FullAndPartURIs fileDependency = new DownloadableArtifacts.FullAndPartURIs(dependencyFileURI, this.earDirUserURI(this.dc()).resolve(this.earURI.relativize(dependencyFileURI)));
            downloads.add(fileDependency);
        }
    }

    private void processDependentJAR(File dependentFile, URI baseURI, URI dependencyURI, URI dependencyFileURI, Set<URI> dependencyURIsProcessed, Set<DownloadableArtifacts.FullAndPartURIs> downloads, URI containingJARURI, boolean isDependencyALibrary) throws IOException {
        if (isDependencyALibrary) {
            this.signedJARManager.addJAR(dependencyFileURI);
        }
        DownloadableArtifacts.FullAndPartURIs jarFileDependency = new DownloadableArtifacts.FullAndPartURIs(dependencyFileURI, this.earDirUserURI(this.dc()).resolve(this.earURI.relativize(baseURI.resolve(dependencyURI))));
        downloads.add(jarFileDependency);
        URI jarURI = URI.create("jar:" + dependencyFileURI.getRawSchemeSpecificPart());
        InputJarArchive dependentJar = new InputJarArchive();
        dependentJar.open(jarURI);
        Manifest jarManifest = dependentJar.getManifest();
        dependentJar.close();
        Attributes mainAttrs = jarManifest.getMainAttributes();
        String jarClassPath = mainAttrs.getValue(Attributes.Name.CLASS_PATH);
        if (jarClassPath != null) {
            for (String elt : jarClassPath.split(" ")) {
                URI eltURI;
                if (elt.trim().length() <= 0 || dependencyURIsProcessed.contains(eltURI = URI.create(elt))) continue;
                this.processDependencies(dependencyFileURI, URI.create(elt), downloads, dependencyURIsProcessed, containingJARURI, true);
            }
        }
    }

    private boolean isSubmodule(URI candidateURI) {
        for (ModuleDescriptor<BundleDescriptor> desc : this.appClientDesc().getApplication().getModules()) {
            if (!URI.create(desc.getArchiveUri()).equals(candidateURI)) continue;
            return true;
        }
        return false;
    }

    private boolean matchesSubmoduleURI(URI candidateURI, String submoduleURIText) {
        Matcher candidateMatcher = submoduleURIPattern.matcher(candidateURI.getPath());
        URI normalizedCandidateURI = candidateMatcher.matches() ? URI.create(candidateMatcher.group(1) + "." + candidateMatcher.group(2)) : candidateURI;
        candidateMatcher.reset(submoduleURIText);
        URI normalizedSubmoduleURI = candidateMatcher.matches() ? URI.create(candidateMatcher.group(1) + "." + candidateMatcher.group(2)) : URI.create(submoduleURIText);
        return normalizedCandidateURI.equals(normalizedSubmoduleURI);
    }

    private URI convertExpandedDirToJarURI(String submoduleURI) {
        URI result = null;
        Matcher m = submoduleURIPattern.matcher(submoduleURI);
        if (m.matches()) {
            result = URI.create(m.group(1) + "." + m.group(2));
        }
        return result;
    }

    @Override
    public URI facadeServerURI(DeploymentContext dc) {
        File genXMLDir = dc.getScratchDir("xml");
        return genXMLDir.toURI().resolve(this.relativeFacadeURI(dc));
    }

    @Override
    public Set<DownloadableArtifacts.FullAndPartURIs> earLevelDownloads() {
        return this.earLevelDownloads;
    }

    @Override
    protected Set<DownloadableArtifacts.FullAndPartURIs> clientLevelDownloads() throws IOException {
        return this.clientLevelDownloads;
    }

    @Override
    protected String facadeClassPath() {
        return this.classPathForFacade.toString();
    }

    @Override
    protected String PUScanTargets() {
        return this.PUScanTargetsForFacade.toString();
    }

    @Override
    protected void addGroupFacadeToEARDownloads() {
        DownloadableArtifacts.FullAndPartURIs earFacadeDownload = (DownloadableArtifacts.FullAndPartURIs)this.dc().getTransientAppMetaData("earFacadeDownload", DownloadableArtifacts.FullAndPartURIs.class);
        this.earLevelDownloads.add(earFacadeDownload);
    }

    private String appName(DeploymentContext dc) {
        DeployCommandParameters params = (DeployCommandParameters)dc.getCommandParameters(DeployCommandParameters.class);
        return params.name();
    }

    @Override
    public URI facadeUserURI(DeploymentContext dc) {
        return URI.create(this.appName(dc) + "Client/" + this.relativeFacadeURI(dc));
    }

    private URI relativeFacadeURI(DeploymentContext dc) {
        return this.moduleURI().resolve(this.facadeFileNameAndType(dc));
    }

    @Override
    protected String facadeFileNameAndType(DeploymentContext dc) {
        return this.moduleNameOnly() + "Client.jar";
    }

    @Override
    public URI appClientUserURI(DeploymentContext dc) {
        return this.earDirUserURI(dc).resolve(this.moduleURI());
    }

    @Override
    public URI appClientUserURIForFacade(DeploymentContext dc) {
        return URI.create(Util.getURIName((URI)this.appClientUserURI(dc)));
    }

    private URI earDirUserURI(DeploymentContext dc) {
        return URI.create(this.appName(dc) + "Client/");
    }

    @Override
    public URI appClientServerURI(DeploymentContext dc) {
        String appClientURIWithinEAR = this.appClientDesc().getModuleDescriptor().getArchiveUri();
        Matcher m = submoduleURIPattern.matcher(appClientURIWithinEAR);
        File userProvidedJarFile = new File(new File(this.earURI), appClientURIWithinEAR);
        URI result = m.matches() ? new File(dc.getScratchDir("xml"), m.group(1) + "." + m.group(2)).toURI() : (!userProvidedJarFile.exists() ? new File(dc.getScratchDir("xml"), appClientURIWithinEAR).toURI() : userProvidedJarFile.toURI());
        return result;
    }

    @Override
    public URI appClientURIWithinApp(DeploymentContext dc) {
        return URI.create(this.appClientDesc().getModuleDescriptor().getArchiveUri());
    }

    @Override
    public URI URIWithinAppDir(DeploymentContext dc, URI absoluteURI) {
        return this.earURI.relativize(absoluteURI);
    }

    @Override
    public String pathToAppclientWithinApp(DeploymentContext dc) {
        return this.appClientDesc().getModuleDescriptor().getArchiveUri();
    }

    private URI moduleURI() {
        return URI.create(this.appClientDesc().getModuleDescriptor().getArchiveUri());
    }

    private String moduleNameAndType() {
        return Util.getURIName((URI)this.moduleURI());
    }

    private String moduleNameOnly() {
        String nameAndType = this.moduleNameAndType();
        return nameAndType.substring(0, nameAndType.lastIndexOf(".jar"));
    }
}

