/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices;

import com.sun.enterprise.container.common.spi.util.InjectionException;
import com.sun.enterprise.container.common.spi.util.InjectionManager;
import com.sun.enterprise.deployment.InjectionTarget;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.logging.LogDomains;
import com.sun.xml.ws.api.server.ResourceInjector;
import com.sun.xml.ws.api.server.WSWebServiceContext;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.xml.ws.WebServiceException;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.webservices.WebServiceContextImpl;
import org.glassfish.webservices.WebServiceContractImpl;

public class ResourceInjectorImpl
extends ResourceInjector {
    private WebServiceEndpoint endpoint;
    private ComponentInvocation inv;
    private InvocationManager invMgr;
    private Logger logger = LogDomains.getLogger(((Object)((Object)this)).getClass(), (String)"javax.enterprise.webservices");
    private ResourceBundle rb = this.logger.getResourceBundle();

    public ResourceInjectorImpl(WebServiceEndpoint ep) {
        WebServiceContractImpl wscImpl = WebServiceContractImpl.getInstance();
        this.invMgr = wscImpl.getInvocationManager();
        this.inv = this.invMgr.getCurrentInvocation();
        this.endpoint = ep;
    }

    public void inject(WSWebServiceContext context, Object instance) throws WebServiceException {
        try {
            this.invMgr.preInvoke(this.inv);
            InjectionManager injManager = WebServiceContractImpl.getInstance().getHabitat().getByContract(InjectionManager.class);
            injManager.injectInstance(instance);
            WebServiceContextImpl wsc = null;
            WebBundleDescriptor bundle = (WebBundleDescriptor)this.endpoint.getBundleDescriptor();
            for (ResourceReferenceDescriptor r : bundle.getResourceReferenceDescriptors()) {
                if (!r.isWebServiceContext()) continue;
                Iterator iter = r.getInjectionTargets().iterator();
                boolean matchingClassFound = false;
                while (iter.hasNext()) {
                    InjectionTarget target = (InjectionTarget)iter.next();
                    if (!this.endpoint.getServletImplClass().equals(target.getClassName())) continue;
                    matchingClassFound = true;
                    break;
                }
                if (!matchingClassFound) continue;
                try {
                    InitialContext ic = new InitialContext();
                    wsc = (WebServiceContextImpl)ic.lookup("java:comp/env/" + r.getName());
                }
                catch (Throwable t) {
                    this.logger.fine(this.rb.getString("exception.thrown") + t);
                }
                if (wsc == null) continue;
                wsc.setContextDelegate(context);
                wsc.setServletName(bundle.getWebComponentDescriptors());
            }
        }
        catch (InjectionException ie) {
            throw new WebServiceException((Throwable)ie);
        }
        finally {
            this.invMgr.postInvoke(this.inv);
        }
    }
}

