/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.util.WebServerInfo;
import com.sun.enterprise.deployment.util.XModuleType;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.logging.LogDomains;
import com.sun.tools.ws.util.xml.XmlUtil;
import com.sun.xml.bind.api.JAXBRIContext;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.SingleThreadModel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.glassfish.api.container.RequestDispatcher;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.api.deployment.UndeployCommandParameters;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.deployment.archive.WritableArchive;
import org.glassfish.deployment.common.DeploymentException;
import org.glassfish.deployment.common.DownloadableArtifacts;
import org.glassfish.internal.api.JAXRPCCodeGenFacade;
import org.glassfish.javaee.core.deployment.JavaEEDeployer;
import org.glassfish.loader.util.ASClassLoaderUtil;
import org.glassfish.webservices.Import;
import org.glassfish.webservices.WebServiceDeploymentNotifier;
import org.glassfish.webservices.WebServiceDeploymentNotifierImpl;
import org.glassfish.webservices.WebServicesApplication;
import org.glassfish.webservices.WebServicesContainer;
import org.glassfish.webservices.WsUtil;
import org.glassfish.webservices.monitoring.Deployment109ProbeProvider;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class WebServicesDeployer
extends JavaEEDeployer<WebServicesContainer, WebServicesApplication> {
    public static final WebServiceDeploymentNotifier deploymentNotifier = new WebServiceDeploymentNotifierImpl();
    private Logger logger = LogDomains.getLogger(((Object)((Object)this)).getClass(), (String)"javax.enterprise.webservices");
    private ResourceBundle rb = this.logger.getResourceBundle();
    @Inject
    private RequestDispatcher dispatcher;
    @Inject(name="server-config")
    private Config config;
    @Inject
    private DownloadableArtifacts downloadableArtifacts;
    @Inject
    private ArchiveFactory archiveFactory;
    private Deployment109ProbeProvider probe;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(WebServicesDeployer.class);

    public static WebServiceDeploymentNotifier getDeploymentNotifier() {
        return deploymentNotifier;
    }

    protected String getModuleType() {
        return "webservices";
    }

    protected void cleanArtifacts(DeploymentContext deploymentContext) throws DeploymentException {
    }

    public boolean prepare(DeploymentContext dc) {
        try {
            Application app = (Application)dc.getModuleMetaData(Application.class);
            if (app == null) {
                this.logger.severe(this.format(this.rb.getString("failed.loading.dd"), new String[0]));
                return false;
            }
            BundleDescriptor bundle = (BundleDescriptor)dc.getModuleMetaData(BundleDescriptor.class);
            String moduleCP = this.getModuleClassPath(dc);
            List moduleCPUrls = ASClassLoaderUtil.getURLsFromClasspath((String)moduleCP, (String)File.pathSeparator, null);
            ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
            URLClassLoader newCl = new URLClassLoader(ASClassLoaderUtil.convertURLListToArray((List)moduleCPUrls), oldCl);
            Thread.currentThread().setContextClassLoader(newCl);
            WebServicesDescriptor wsDesc = bundle.getWebServices();
            for (WebService ws : wsDesc.getWebServices()) {
                if (new WsUtil().isJAXWSbasedService(ws)) {
                    this.setupJaxWSServiceForDeployment(dc, ws);
                    continue;
                }
                JAXRPCCodeGenFacade facade = this.habitat.getByContract(JAXRPCCodeGenFacade.class);
                if (facade != null) {
                    facade.run(this.habitat, dc, moduleCP);
                    continue;
                }
                throw new DeploymentException(this.rb.getString("jaxrpc.codegen.fail"));
            }
            this.doWebServicesDeployment(app, dc);
            this.populateWsdlFilesForPublish(dc, wsDesc);
            Thread.currentThread().setContextClassLoader(oldCl);
            return true;
        }
        catch (Exception ex) {
            RuntimeException re = new RuntimeException(ex.getMessage());
            re.initCause(ex);
            throw re;
        }
    }

    protected void setupJaxWSServiceForDeployment(DeploymentContext dc, WebService ws) throws DeploymentException {
        BundleDescriptor bundle = (BundleDescriptor)dc.getModuleMetaData(BundleDescriptor.class);
        File moduleDir = dc.getSourceDir();
        File wsdlDir = dc.getScratchDir("xml");
        wsdlDir.mkdirs();
        File stubsDir = dc.getScratchDir("ejb");
        stubsDir.mkdirs();
        String webinfLibDir = null;
        if (!XModuleType.WAR.equals((Object)bundle.getModuleType()) && !XModuleType.EJB.equals((Object)bundle.getModuleType())) {
            return;
        }
        if (XModuleType.WAR.equals((Object)bundle.getModuleType())) {
            webinfLibDir = moduleDir.getAbsolutePath() + File.separator + "WEB-INF" + File.separator + "lib";
        }
        wsdlDir = new File(wsdlDir, bundle.getWsdlDir().replaceAll("/", "\\" + File.separator));
        try {
            this.checkCatalog(bundle, ws, moduleDir);
        }
        catch (DeploymentException e) {
            this.logger.log(Level.SEVERE, "Error in resolving the catalog");
        }
        if (ws.hasWsdlFile()) {
            if (ws.getWsdlFileUri().startsWith("http")) {
                try {
                    this.downloadWsdlsAndSchemas(new URL(ws.getWsdlFileUri()), wsdlDir);
                }
                catch (Exception e) {
                    throw new DeploymentException(e.toString(), (Throwable)e);
                }
                String wsdlFileUri = ws.getWsdlFileUri().substring(ws.getWsdlFileUri().lastIndexOf("/") + 1);
                File wsdlFile = new File(wsdlDir, wsdlFileUri);
            } else {
                String wsdlFileUri = ws.getWsdlFileUri();
                File wsdlFile = wsdlFileUri.startsWith("/") ? new File(wsdlFileUri) : new File(moduleDir, wsdlFileUri);
                if (!wsdlFile.exists()) {
                    String errorMessage = this.format(this.rb.getString("wsdl.notfound"), ws.getWsdlFileUri(), bundle.getModuleDescriptor().getArchiveUri());
                    this.logger.severe(errorMessage);
                    throw new DeploymentException(errorMessage);
                }
            }
        } else {
            String wsdlFileUri = JAXBRIContext.mangleNameToClassName((String)ws.getName()) + ".wsdl";
            wsdlDir.mkdirs();
            File wsdlFile = new File(wsdlDir, wsdlFileUri);
        }
    }

    public Object loadMetaData(Class type, DeploymentContext dc) {
        return true;
    }

    public MetaData getMetaData() {
        return new MetaData(false, null, new Class[]{Application.class});
    }

    private void downloadWsdlsAndSchemas(URL httpUrl, File wsdlDir) throws Exception {
        wsdlDir.mkdirs();
        String fileName = httpUrl.toString().substring(httpUrl.toString().lastIndexOf("/") + 1);
        File toFile = new File(wsdlDir.getAbsolutePath() + File.separator + fileName);
        this.downloadFile(httpUrl, toFile);
        HashSet wsdlRelativeImports = new HashSet();
        HashSet schemaRelativeImports = new HashSet();
        HashSet wsdlIncludes = new HashSet();
        HashSet schemaIncludes = new HashSet();
        this.parseRelativeImports(httpUrl, wsdlRelativeImports, wsdlIncludes, schemaRelativeImports, schemaIncludes);
        wsdlRelativeImports.addAll(wsdlIncludes);
        schemaRelativeImports.addAll(schemaIncludes);
        String urlWithoutFileName = httpUrl.toString().substring(0, httpUrl.toString().lastIndexOf("/"));
        for (Import next : schemaRelativeImports) {
            String location = next.getLocation();
            if ((location = location.replaceAll("/", "\\" + File.separator)).lastIndexOf(File.separator) != -1) {
                File newDir = new File(wsdlDir.getAbsolutePath() + File.separator + location.substring(0, location.lastIndexOf(File.separator)));
                newDir.mkdirs();
            }
            this.downloadFile(new URL(urlWithoutFileName + "/" + next.getLocation()), new File(wsdlDir.getAbsolutePath() + File.separator + location));
        }
        for (Import next : wsdlRelativeImports) {
            String newWsdlLocation = next.getLocation();
            File newWsdlDir = (newWsdlLocation = newWsdlLocation.replaceAll("/", "\\" + File.separator)).lastIndexOf(File.separator) != -1 ? new File(wsdlDir.getAbsolutePath() + File.separator + newWsdlLocation.substring(0, newWsdlLocation.lastIndexOf(File.separator))) : wsdlDir;
            this.downloadWsdlsAndSchemas(new URL(urlWithoutFileName + "/" + next.getLocation()), newWsdlDir);
        }
    }

    private void checkCatalog(BundleDescriptor bundle, WebService ws, File moduleDir) throws DeploymentException {
        File catalogFile = new File(moduleDir, bundle.getDeploymentDescriptorDir() + File.separator + "jax-ws-catalog.xml");
        if (!catalogFile.exists()) {
            return;
        }
        this.resolveCatalog(catalogFile, ws.getWsdlFileUri(), ws);
    }

    public URL resolveCatalog(File catalogFile, String wsdlFile, WebService ws) throws DeploymentException {
        try {
            URL retVal = null;
            EntityResolver resolver = XmlUtil.createEntityResolver((URL)catalogFile.toURL());
            InputSource source = resolver.resolveEntity(null, wsdlFile);
            if (source != null) {
                String mappedEntry = source.getSystemId();
                if (mappedEntry.startsWith("file:")) {
                    File f = new File(mappedEntry.substring(mappedEntry.indexOf(":") + 1));
                    if (!f.exists()) {
                        throw new DeploymentException(this.format(this.rb.getString("catalog.resolver.error"), mappedEntry));
                    }
                    retVal = f.toURI().toURL();
                    if (ws != null) {
                        ws.setWsdlFileUri(f.getAbsolutePath());
                        ws.setWsdlFileUrl(retVal);
                    }
                } else if (mappedEntry.startsWith("http")) {
                    retVal = new URL(mappedEntry);
                    if (ws != null) {
                        ws.setWsdlFileUrl(retVal);
                    }
                }
            }
            return retVal;
        }
        catch (Throwable t) {
            throw new DeploymentException(this.format(this.rb.getString("catalog.error"), t.getMessage(), catalogFile.getAbsolutePath()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadFile(URL httpUrl, File toFile) throws Exception {
        InputStream is = null;
        OutputStream os = null;
        try {
            int readCount;
            if (!toFile.createNewFile()) {
                throw new Exception(localStrings.getLocalString("filecreation.error", "Unable to create new File", new Object[]{toFile.getAbsolutePath()}));
            }
            is = httpUrl.openStream();
            os = new FileOutputStream(toFile, true);
            byte[] buffer = new byte[10240];
            while ((readCount = is.read(buffer, 0, 10240)) != -1) {
                ((FileOutputStream)os).write(buffer, 0, readCount);
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.flush();
                ((FileOutputStream)os).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseRelativeImports(URL wsdlFileUrl, Collection wsdlRelativeImports, Collection wsdlIncludes, Collection schemaRelativeImports, Collection schemaIncludes) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        InputStream is = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            is = wsdlFileUrl.openStream();
            Document document = builder.parse(is);
            this.procesSchemaImports(document, schemaRelativeImports);
            this.procesWsdlImports(document, wsdlRelativeImports);
            this.procesSchemaIncludes(document, schemaIncludes);
            this.procesWsdlIncludes(document, wsdlIncludes);
        }
        catch (SAXParseException spe) {
            this.logger.severe(this.format(this.rb.getString("parsing.error"), "" + spe.getLineNumber(), spe.getSystemId()));
            Exception x = spe;
            if (spe.getException() != null) {
                x = spe.getException();
            }
            this.logger.log(Level.SEVERE, "Error occured", x);
        }
        catch (Exception sxe) {
            this.logger.severe(this.format(this.rb.getString("wsdl.parsing.error"), sxe.getMessage()));
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException io) {
                this.logger.fine(io.getMessage());
            }
        }
    }

    private void procesSchemaImports(Document document, Collection schemaImportCollection) throws SAXException, ParserConfigurationException, IOException {
        NodeList schemaImports = document.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "import");
        this.addImportsAndIncludes(schemaImports, schemaImportCollection, "namespace", "schemaLocation");
    }

    private void procesWsdlImports(Document document, Collection wsdlImportCollection) throws SAXException, ParserConfigurationException, IOException {
        NodeList wsdlImports = document.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "import");
        this.addImportsAndIncludes(wsdlImports, wsdlImportCollection, "namespace", "location");
    }

    private void procesSchemaIncludes(Document document, Collection schemaIncludeCollection) throws SAXException, ParserConfigurationException, IOException {
        NodeList schemaIncludes = document.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "include");
        this.addImportsAndIncludes(schemaIncludes, schemaIncludeCollection, null, "schemaLocation");
    }

    private void procesWsdlIncludes(Document document, Collection wsdlIncludesCollection) throws SAXException, ParserConfigurationException, IOException {
        NodeList wsdlIncludes = document.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "include");
        this.addImportsAndIncludes(wsdlIncludes, wsdlIncludesCollection, null, "location");
    }

    private void addImportsAndIncludes(NodeList list, Collection result, String namespace, String location) throws SAXException, ParserConfigurationException, IOException {
        for (int i = 0; i < list.getLength(); ++i) {
            String givenLocation = null;
            Node element = list.item(i);
            NamedNodeMap attrs = element.getAttributes();
            Node n = attrs.getNamedItem(location);
            if (n != null) {
                givenLocation = n.getNodeValue();
            }
            if (givenLocation == null || givenLocation != null && givenLocation.startsWith("http")) continue;
            Import imp = new Import();
            imp.setLocation(givenLocation);
            if (namespace != null && (n = attrs.getNamedItem(namespace)) != null) {
                imp.setNamespace(n.getNodeValue());
            }
            result.add(imp);
        }
    }

    private void doWebServicesDeployment(Application app, DeploymentContext dc) throws Exception {
        WebBundleDescriptor webBundleDesc = (WebBundleDescriptor)dc.getModuleMetaData(WebBundleDescriptor.class);
        HashSet webServices = new HashSet();
        WebServicesDescriptor wsDesc = (WebServicesDescriptor)dc.getModuleMetaData(WebServicesDescriptor.class);
        if (wsDesc != null) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("In doWebServicesDeployment: using local web services. There are " + wsDesc.getWebServices().size() + ". The app has total of " + app.getWebServiceDescriptors().size());
            }
            webServices.addAll(wsDesc.getWebServices());
        } else {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("In doWebServicesDeployment: using app web  services, local ws descriptor is null. Total numer: " + app.getWebServiceDescriptors().size());
            }
            webServices.addAll(app.getWebServiceDescriptors());
        }
        if (dc.getAppProps().get("context-root") != null && app.isVirtual() && webBundleDesc != null) {
            String contextRoot = (String)dc.getAppProps().get("context-root");
            webBundleDesc.setContextRoot(contextRoot);
        }
        Iterator i$ = webServices.iterator();
        while (i$.hasNext()) {
            WsUtil wsUtil = new WsUtil();
            WebService next = (WebService)i$.next();
            if (wsUtil.isJAXWSbasedService(next) && !next.hasFilePublishing()) {
                for (WebServiceEndpoint wsep : next.getEndpoints()) {
                    wsep.composeFinalWsdlUrl(wsUtil.getWebServerInfoForDAS().getWebServerRootURL(wsep.isSecure()));
                }
                continue;
            }
            URL url = next.getWsdlFileUrl();
            if (url == null) {
                File f = new File(dc.getSourceDir(), next.getWsdlFileUri());
                url = f.toURL();
            }
            File genXmlDir = dc.getScratchDir("xml");
            String wsdlFileDir = next.getWsdlFileUri().substring(0, next.getWsdlFileUri().lastIndexOf(47));
            new File(genXmlDir, wsdlFileDir).mkdirs();
            File genWsdlFile = new File(genXmlDir, next.getWsdlFileUri());
            wsUtil.generateFinalWsdl(url, next, wsUtil.getWebServerInfoForDAS(), genWsdlFile);
        }
        if (webBundleDesc != null) {
            this.doWebServiceDeployment(webBundleDesc);
        }
    }

    private void doWebServiceDeployment(WebBundleDescriptor webBunDesc) throws DeploymentException, MalformedURLException {
        WebServiceDeploymentNotifier notifier = WebServicesDeployer.getDeploymentNotifier();
        Collection endpoints = webBunDesc.getWebServices().getEndpoints();
        ClassLoader cl = webBunDesc.getClassLoader();
        WsUtil wsutil = new WsUtil();
        for (WebServiceEndpoint nextEndpoint : endpoints) {
            WebComponentDescriptor webComp = nextEndpoint.getWebComponentImpl();
            if (!nextEndpoint.hasServletImplClass()) {
                throw new DeploymentException(this.format(this.rb.getString("enterprise.deployment.backend.cannot_find_servlet"), nextEndpoint.getEndpointName()));
            }
            String servletImplClass = nextEndpoint.getServletImplClass();
            if (!nextEndpoint.getWebService().hasFilePublishing()) {
                String publishingUri = nextEndpoint.getPublishingUri();
                String publishingUrlPattern = publishingUri.charAt(0) == '/' ? publishingUri : "/" + publishingUri + "/*";
                webComp.addUrlPattern(publishingUrlPattern);
            }
            try {
                Class<?> servletImplClazz = cl.loadClass(servletImplClass);
                String containerServlet = wsutil.isJAXWSbasedService(nextEndpoint.getWebService()) ? "org.glassfish.webservices.JAXWSServlet" : (SingleThreadModel.class.isAssignableFrom(servletImplClazz) ? "org.glassfish.webservices.SingleThreadJAXRPCServlet" : "org.glassfish.webservices.JAXRPCServlet");
                webComp.setWebComponentImplementation(containerServlet);
                if (notifier != null) {
                    notifier.notifyDeployed(nextEndpoint);
                }
            }
            catch (ClassNotFoundException cex) {
                throw new DeploymentException(this.format(this.rb.getString("enterprise.deployment.backend.cannot_find_servlet"), nextEndpoint.getEndpointName()));
            }
            WebServerInfo wsi = new WsUtil().getWebServerInfoForDAS();
            URL rootURL = wsi.getWebServerRootURL(nextEndpoint.isSecure());
            String contextRoot = webBunDesc.getContextRoot();
            URL actualAddress = nextEndpoint.composeEndpointAddress(rootURL, contextRoot);
            this.logger.info(this.format(this.rb.getString("enterprise.deployment.endpoint.registration"), nextEndpoint.getEndpointName(), actualAddress.toString()));
        }
    }

    private String format(String key, String ... values) {
        return MessageFormat.format(key, values);
    }

    public static void moveFile(String sourceFile, String destFile) throws IOException {
        FileUtils.copy((String)sourceFile, (String)destFile);
        new File(sourceFile).delete();
    }

    public void unload(WebServicesApplication container, DeploymentContext context) {
        WebServiceDeploymentNotifier notifier = WebServicesDeployer.getDeploymentNotifier();
        Application app = container.getApplication();
        for (WebService svc : app.getWebServiceDescriptors()) {
            for (WebServiceEndpoint endpoint : svc.getEndpoints()) {
                this.probe.undeploy(endpoint);
                if (notifier == null) continue;
                notifier.notifyUndeployed(endpoint);
            }
        }
    }

    public void clean(DeploymentContext dc) {
        String name;
        super.clean(dc);
        UndeployCommandParameters params = (UndeployCommandParameters)dc.getCommandParameters(UndeployCommandParameters.class);
        if (params != null && this.downloadableArtifacts.getArtifacts(name = params.name()).size() > 0) {
            this.downloadableArtifacts.clearArtifacts(name);
        }
    }

    public WebServicesApplication load(WebServicesContainer container, DeploymentContext context) {
        this.probe = container.getDeploymentProbeProvider();
        Application app = (Application)context.getModuleMetaData(Application.class);
        for (WebService svc : app.getWebServiceDescriptors()) {
            for (WebServiceEndpoint endpoint : svc.getEndpoints()) {
                this.probe.deploy(endpoint);
            }
        }
        return new WebServicesApplication(context, this.env, this.dispatcher, this.config, this.habitat);
    }

    private void populateWsdlFilesForPublish(DeploymentContext dc, WebServicesDescriptor wsDesc) throws IOException {
        for (WebService webService : wsDesc.getWebServices()) {
            File parent;
            if (!webService.hasFilePublishing()) continue;
            this.copyExtraFilesToGeneratedFolder(dc);
            BundleDescriptor bundle = webService.getBundleDescriptor();
            XModuleType moduleType = bundle.getModuleType();
            if (!(XModuleType.EAR.equals((Object)moduleType) || XModuleType.WAR.equals((Object)moduleType) || XModuleType.EJB.equals((Object)moduleType))) {
                return;
            }
            String moduleName = bundle.getApplication().getAppName();
            File sourceDir = dc.getScratchDir("xml");
            try {
                URI clientPublishURI = webService.getClientPublishUrl().toURI();
                parent = !clientPublishURI.isOpaque() ? new File(clientPublishURI) : new File(webService.getClientPublishUrl().getPath());
            }
            catch (URISyntaxException e) {
                this.logger.warning(this.rb.getString("exception.thrown") + e);
                parent = new File(webService.getClientPublishUrl().getPath());
            }
            FileArchive archive = new FileArchive();
            archive.open(sourceDir.toURI());
            Enumeration entries = archive.entries(bundle.getWsdlDir());
            ArrayList<DownloadableArtifacts.FullAndPartURIs> alist = new ArrayList<DownloadableArtifacts.FullAndPartURIs>();
            while (entries.hasMoreElements()) {
                String name = (String)entries.nextElement();
                String wsdlName = this.stripWsdlDir(name, bundle);
                URI clientwsdl = new File(parent, wsdlName).toURI();
                alist.add(new DownloadableArtifacts.FullAndPartURIs(new File(sourceDir, name).toURI(), clientwsdl));
            }
            this.downloadableArtifacts.addArtifacts(moduleName, alist);
        }
    }

    private void copyExtraFilesToGeneratedFolder(DeploymentContext context) throws IOException {
        Archivist archivist = this.habitat.getByContract(Archivist.class);
        ReadableArchive archive = this.archiveFactory.openArchive(context.getSourceDir());
        WritableArchive archive2 = this.archiveFactory.createArchive(context.getScratchDir("xml"));
        archivist.copyExtraElements(archive, archive2);
    }

    private String stripWsdlDir(String entry, BundleDescriptor bundle) {
        String wsdlDir = bundle.getWsdlDir();
        return entry.substring(wsdlDir.length() + 1);
    }
}

