/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices.monitoring;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.xml.ws.transport.http.servlet.ServletAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import org.glassfish.external.probe.provider.annotations.ProbeListener;
import org.glassfish.external.probe.provider.annotations.ProbeParam;
import org.glassfish.external.statistics.Statistic;
import org.glassfish.external.statistics.Stats;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedData;
import org.glassfish.gmbal.ManagedObject;
import org.glassfish.gmbal.ManagedOperation;
import org.glassfish.webservices.monitoring.DeployedEndpointData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@AMXMetadata(type="web-service-mon", group="monitoring")
@ManagedObject
@Description(value="Stats for Web Services deployed")
public class WebServiceStatsProvider {
    private final Map<String, DeployedEndpointData> endpoints = new HashMap<String, DeployedEndpointData>();
    private final Map<Servlet109Endpoint, DeployedEndpointData> servletEndpoints = new HashMap<Servlet109Endpoint, DeployedEndpointData>();
    private final Map<EJB109Endpoint, DeployedEndpointData> ejbEndpoints = new HashMap<EJB109Endpoint, DeployedEndpointData>();
    private final Map<String, List<DeployedEndpointData>> riEndpoints = new HashMap<String, List<DeployedEndpointData>>();

    @ProbeListener(value="glassfish:webservices:deployment-109:deploy")
    public synchronized void eeDeploy(@ProbeParam(value="endpoint") WebServiceEndpoint endpoint) {
        Application app = endpoint.getBundleDescriptor().getApplication();
        String path = endpoint.getEndpointAddressPath();
        DeployedEndpointData data = this.endpoints.get(path);
        if (data == null) {
            data = new DeployedEndpointData(path, app, endpoint);
            this.endpoints.put(path, data);
        }
        String appName = app.getAppName();
        String moduleName = endpoint.getBundleDescriptor().getModuleName();
        String endpointName = endpoint.getEndpointName();
        if (endpoint.getWebComponentLink() != null) {
            Servlet109Endpoint se = new Servlet109Endpoint(appName, moduleName, endpoint.getWebComponentLink());
            if (!this.servletEndpoints.containsKey(se)) {
                this.servletEndpoints.put(se, data);
            }
        } else if (endpoint.getEjbLink() != null) {
            EJB109Endpoint ee = new EJB109Endpoint(appName, moduleName, endpoint.getEjbLink());
            if (!this.ejbEndpoints.containsKey(ee)) {
                this.ejbEndpoints.put(ee, data);
            }
        } else {
            throw new RuntimeException("Both servlet-link and ejb-link are null for appName=" + appName + " moduleName=" + moduleName + " endpointName=" + endpointName);
        }
    }

    @ProbeListener(value="glassfish:webservices:deployment-109:undeploy")
    public synchronized void eeUndeploy(@ProbeParam(value="endpoint") WebServiceEndpoint endpoint) {
        String path = endpoint.getEndpointAddressPath();
        this.endpoints.remove(path);
        Application app = endpoint.getBundleDescriptor().getApplication();
        String appName = app.getAppName();
        String moduleName = endpoint.getBundleDescriptor().getModuleName();
        String endpointName = endpoint.getEndpointName();
        if (endpoint.getWebComponentLink() != null) {
            Servlet109Endpoint se = new Servlet109Endpoint(appName, moduleName, endpoint.getWebComponentLink());
            this.servletEndpoints.remove(se);
        } else if (endpoint.getEjbLink() != null) {
            EJB109Endpoint ee = new EJB109Endpoint(appName, moduleName, endpoint.getEjbLink());
            this.ejbEndpoints.remove(ee);
        } else {
            throw new RuntimeException("Both servlet-link and ejb-link are null for appName=" + appName + " moduleName=" + moduleName + " endpointName=" + endpointName);
        }
    }

    @ProbeListener(value="glassfish:webservices:deployment-ri:deploy")
    public synchronized void riDeploy(@ProbeParam(value="adapter") ServletAdapter adapter) {
        List<DeployedEndpointData> ri;
        String contextPath = adapter.getServletContext().getContextPath();
        String path = contextPath + adapter.getValidPath();
        DeployedEndpointData data = this.endpoints.get(path);
        if (data == null) {
            data = new DeployedEndpointData(path, adapter);
            this.endpoints.put(path, data);
        }
        if ((ri = this.riEndpoints.get(contextPath)) == null) {
            ri = new ArrayList<DeployedEndpointData>();
            this.riEndpoints.put(contextPath, ri);
        }
        ri.add(data);
    }

    @ProbeListener(value="glassfish:webservices:deployment-ri:undeploy")
    public synchronized void riUndeploy(@ProbeParam(value="adapter") ServletAdapter adapter) {
        ServletContext ctxt = adapter.getServletContext();
        String name = ctxt.getContextPath() + adapter.getValidPath();
        DeployedEndpointData data = this.endpoints.remove(name);
        String contextPath = adapter.getServletContext().getContextPath();
        List<DeployedEndpointData> ri = this.riEndpoints.get(contextPath);
        if (ri != null) {
            ri.remove((Object)data);
            if (ri.isEmpty()) {
                this.riEndpoints.remove(contextPath);
            }
        }
    }

    @ManagedAttribute
    @Description(value="Deployed Web Service Endpoints")
    public synchronized MyStats getEndpoints() {
        return new MyStats(this.endpoints);
    }

    @ManagedOperation
    public synchronized Map<String, String> getServlet109Endpoint(String appName, String moduleName, String servletLink) {
        Servlet109Endpoint endpoint = new Servlet109Endpoint(appName, moduleName, servletLink);
        DeployedEndpointData data = this.servletEndpoints.get(endpoint);
        return data == null ? Collections.emptyMap() : data.getStaticAsMap();
    }

    @ManagedOperation
    public synchronized Map<String, String> getEjb109Endpoint(String appName, String moduleName, String ejbLink) {
        EJB109Endpoint endpoint = new EJB109Endpoint(appName, moduleName, ejbLink);
        DeployedEndpointData data = this.ejbEndpoints.get(endpoint);
        return data == null ? Collections.emptyMap() : data.getStaticAsMap();
    }

    @ManagedOperation
    public synchronized List<Map<String, String>> getRiEndpoint(String contextPath) {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        List<DeployedEndpointData> ri = this.riEndpoints.get(contextPath);
        if (ri != null) {
            for (DeployedEndpointData de : ri) {
                list.add(de.getStaticAsMap());
            }
        }
        return list;
    }

    private static class EJB109Endpoint {
        final String appName;
        final String moduleName;
        final String ejbLink;

        EJB109Endpoint(String appName, String moduleName, String ejbLink) {
            this.appName = appName;
            this.moduleName = moduleName;
            this.ejbLink = ejbLink;
        }

        public boolean equals(Object obj) {
            if (obj instanceof EJB109Endpoint) {
                EJB109Endpoint other = (EJB109Endpoint)obj;
                if (this.appName.equals(other.appName) && this.moduleName.equals(other.moduleName) && this.ejbLink.equals(other.ejbLink)) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return this.appName.hashCode() + this.moduleName.hashCode() + this.ejbLink.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @ManagedData
    private static class MyStats
    implements Stats {
        final Map<String, DeployedEndpointData> endpoints = new HashMap<String, DeployedEndpointData>();
        final DeployedEndpointData[] data;

        MyStats(Map<String, DeployedEndpointData> curEndpoints) {
            this.endpoints.putAll(curEndpoints);
            this.data = this.endpoints.values().toArray(new DeployedEndpointData[this.endpoints.size()]);
        }

        public Statistic getStatistic(String s) {
            return (Statistic)this.endpoints.get(s);
        }

        public String[] getStatisticNames() {
            Set<String> names = this.endpoints.keySet();
            return names.toArray(new String[names.size()]);
        }

        @ManagedAttribute
        public DeployedEndpointData[] getStatistics() {
            return this.data;
        }
    }

    private static class Servlet109Endpoint {
        final String appName;
        final String moduleName;
        final String servletLink;

        Servlet109Endpoint(String appName, String moduleName, String servletLink) {
            this.appName = appName;
            this.moduleName = moduleName;
            this.servletLink = servletLink;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Servlet109Endpoint) {
                Servlet109Endpoint other = (Servlet109Endpoint)obj;
                if (this.appName.equals(other.appName) && this.moduleName.equals(other.moduleName) && this.servletLink.equals(other.servletLink)) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return this.appName.hashCode() + this.moduleName.hashCode() + this.servletLink.hashCode();
        }
    }
}

