/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.legacy.connection;

import com.sun.corba.ee.impl.logging.ORBUtilSystemException;
import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.spi.legacy.connection.LegacyServerSocketEndPointInfo;
import com.sun.corba.ee.spi.legacy.connection.LegacyServerSocketManager;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.transport.CorbaAcceptor;
import java.util.Collection;
import java.util.Iterator;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;

public class LegacyServerSocketManagerImpl
implements LegacyServerSocketManager {
    protected ORB orb;
    private ORBUtilSystemException wrapper;

    public LegacyServerSocketManagerImpl(ORB orb) {
        this.orb = orb;
        this.wrapper = orb.getLogWrapperTable().get_RPC_TRANSPORT_ORBUtil();
    }

    @Override
    public int legacyGetTransientServerPort(String type) {
        return this.legacyGetServerPort(type, false);
    }

    @Override
    public synchronized int legacyGetPersistentServerPort(String socketType) {
        if (this.orb.getORBData().getServerIsORBActivated()) {
            return this.legacyGetServerPort(socketType, true);
        }
        if (this.orb.getORBData().getPersistentPortInitialized()) {
            return this.orb.getORBData().getPersistentServerPort();
        }
        throw this.wrapper.persistentServerportNotSet(CompletionStatus.COMPLETED_MAYBE);
    }

    @Override
    public synchronized int legacyGetTransientOrPersistentServerPort(String socketType) {
        return this.legacyGetServerPort(socketType, this.orb.getORBData().getServerIsORBActivated());
    }

    @Override
    public synchronized LegacyServerSocketEndPointInfo legacyGetEndpoint(String name) {
        Iterator iterator = this.getAcceptorIterator();
        while (iterator.hasNext()) {
            LegacyServerSocketEndPointInfo endPoint = this.cast(iterator.next());
            if (endPoint == null || !name.equals(endPoint.getName())) continue;
            return endPoint;
        }
        throw new INTERNAL("No acceptor for: " + name);
    }

    @Override
    public boolean legacyIsLocalServerPort(int port) {
        Iterator iterator = this.getAcceptorIterator();
        while (iterator.hasNext()) {
            LegacyServerSocketEndPointInfo endPoint = this.cast(iterator.next());
            if (endPoint == null || endPoint.getPort() != port) continue;
            return true;
        }
        return false;
    }

    private int legacyGetServerPort(String socketType, boolean isPersistent) {
        Iterator endpoints = this.getAcceptorIterator();
        while (endpoints.hasNext()) {
            LegacyServerSocketEndPointInfo ep = this.cast(endpoints.next());
            if (ep == null || !ep.getType().equals(socketType)) continue;
            if (isPersistent) {
                return ep.getLocatorPort();
            }
            return ep.getPort();
        }
        return -1;
    }

    private Iterator getAcceptorIterator() {
        Collection<CorbaAcceptor> acceptors = this.orb.getCorbaTransportManager().getAcceptors(null, null);
        if (acceptors != null) {
            return acceptors.iterator();
        }
        throw this.wrapper.getServerPortCalledBeforeEndpointsInitialized();
    }

    private LegacyServerSocketEndPointInfo cast(Object o) {
        if (o instanceof LegacyServerSocketEndPointInfo) {
            return (LegacyServerSocketEndPointInfo)o;
        }
        return null;
    }

    protected void dprint(String msg) {
        ORBUtility.dprint("LegacyServerSocketManagerImpl", msg);
    }
}

