/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.util;

import com.sun.grizzly.util.FixedThreadPool;
import com.sun.grizzly.util.LinkedTransferQueue;
import com.sun.grizzly.util.WorkerThreadImpl;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PipelineThreadPool
extends FixedThreadPool {
    private final AtomicInteger queueSize = new AtomicInteger();
    protected final int corePoolsize;
    protected final long idleTimeout;
    protected final TimeUnit timeUnit;

    public PipelineThreadPool() {
        this("Grizzly", 8, 64, 30L, TimeUnit.SECONDS);
    }

    public PipelineThreadPool(final String name, int corePoolsize, int maxPoolSize, long keepAliveTime, TimeUnit timeUnit) {
        this(corePoolsize, maxPoolSize, keepAliveTime, timeUnit, new ThreadFactory(){
            private final AtomicInteger c = new AtomicInteger();

            public Thread newThread(Runnable r) {
                WorkerThreadImpl t = new WorkerThreadImpl(null, name + "-" + this.c.incrementAndGet(), r, 0);
                t.setDaemon(true);
                return t;
            }
        });
        this.name = name;
    }

    public PipelineThreadPool(int corePoolsize, int maxPoolSize, long keepAliveTime, TimeUnit timeUnit, ThreadFactory threadFactory) {
        this(corePoolsize, maxPoolSize, keepAliveTime, timeUnit, threadFactory, new LinkedTransferQueue<Runnable>());
    }

    public PipelineThreadPool(int corePoolsize, int maxPoolSize, long keepAliveTime, TimeUnit timeUnit, ThreadFactory threadFactory, BlockingQueue<Runnable> workQueue) {
        super(workQueue, threadFactory);
        this.validateNewPoolsize(corePoolsize, maxPoolSize);
        if (keepAliveTime < 0L) {
            throw new IllegalArgumentException("keepAliveTime < 0");
        }
        if (timeUnit == null) {
            throw new IllegalArgumentException("timeUnit == null");
        }
        this.corePoolsize = corePoolsize;
        this.maxPoolSize = maxPoolSize;
        this.idleTimeout = keepAliveTime;
        this.timeUnit = timeUnit;
        this.aliveworkerCount.set(corePoolsize);
        while (corePoolsize-- > 0) {
            this.startWorker(new Worker(null, true));
        }
    }

    private void validateNewPoolsize(int corePoolsize, int maxPoolSize) {
        if (maxPoolSize < 1) {
            throw new IllegalArgumentException("maxPoolsize < 1");
        }
        if (corePoolsize < 1) {
            throw new IllegalArgumentException("corePoolsize < 1");
        }
        if (corePoolsize > maxPoolSize) {
            throw new IllegalArgumentException("corePoolsize > maxPoolSize");
        }
    }

    @Override
    public void execute(Runnable task) {
        int ac;
        if (task == null) {
            throw new IllegalArgumentException("Runnable task is null");
        }
        while ((ac = this.aliveworkerCount.get()) < this.maxPoolSize && (this.queueSize.get() > 0 || !this.hasIdleWorkersApproximately()) && this.running) {
            if (!this.aliveworkerCount.compareAndSet(ac, ac + 1)) continue;
            this.startWorker(new Worker(task, false));
            return;
        }
        if (this.running) {
            this.workQueue.offer(task);
            this.queueSize.incrementAndGet();
        }
    }

    private boolean hasIdleWorkersApproximately() {
        return this.aliveworkerCount.get() > this.approximateRunningWorkerCount.get();
    }

    @Override
    public int getQueueSize() {
        return this.queueSize.get();
    }

    @Override
    public int getCorePoolSize() {
        return this.corePoolsize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaximumPoolSize(int maxPoolSize) {
        Object object = this.statelock;
        synchronized (object) {
            this.validateNewPoolsize(this.corePoolsize, maxPoolSize);
            this.maxPoolSize = maxPoolSize;
        }
    }

    @Override
    public int getMaximumPoolSize() {
        return this.maxPoolSize;
    }

    @Override
    public long getKeepAliveTime(TimeUnit unit) {
        return unit.convert(this.idleTimeout, this.timeUnit);
    }

    protected class Worker
    extends FixedThreadPool.BasicWorker {
        private final boolean core;
        private Runnable firstTask;

        public Worker(Runnable firstTask, boolean core) {
            this.core = core;
            this.firstTask = firstTask;
        }

        protected Runnable getTask() throws InterruptedException {
            Runnable r;
            if (this.firstTask != null) {
                r = this.firstTask;
                this.firstTask = null;
            } else {
                if (!this.core && PipelineThreadPool.this.aliveworkerCount.get() > PipelineThreadPool.this.maxPoolSize) {
                    return null;
                }
                Runnable runnable = r = this.core ? (Runnable)PipelineThreadPool.this.workQueue.take() : (Runnable)PipelineThreadPool.this.workQueue.poll(PipelineThreadPool.this.idleTimeout, PipelineThreadPool.this.timeUnit);
                if (r != null) {
                    PipelineThreadPool.this.queueSize.decrementAndGet();
                }
            }
            return r;
        }
    }
}

