/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.monitor;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ModuleMonitoringLevels;
import com.sun.enterprise.config.serverbeans.MonitoringService;
import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.ModuleLifecycleListener;
import com.sun.enterprise.module.ModuleState;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import org.glassfish.admin.monitor.FutureStatsProviders;
import org.glassfish.admin.monitor.StatsProviderManagerDelegateImpl;
import org.glassfish.admin.monitor.StatsProviderRegistry;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.api.monitoring.ContainerMonitoring;
import org.glassfish.external.amx.AMXGlassfish;
import org.glassfish.external.amx.MBeanListener;
import org.glassfish.external.probe.provider.StatsProviderInfo;
import org.glassfish.external.probe.provider.StatsProviderManager;
import org.glassfish.external.probe.provider.StatsProviderManagerDelegate;
import org.glassfish.flashlight.MonitoringRuntimeDataRegistry;
import org.glassfish.flashlight.client.ProbeClientMediator;
import org.glassfish.flashlight.impl.client.FlashlightProbeClientMediator;
import org.glassfish.flashlight.provider.ProbeProviderFactory;
import org.glassfish.flashlight.provider.ProbeRegistry;
import org.glassfish.internal.api.Init;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.PreDestroy;
import org.jvnet.hk2.component.Singleton;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

@Service
@Scoped(value=Singleton.class)
public class MonitoringBootstrap
implements Init,
PostConstruct,
PreDestroy,
EventListener,
ModuleLifecycleListener,
ConfigListener {
    @Inject
    private MonitoringRuntimeDataRegistry mrdr;
    @Inject
    private Domain domain;
    @Inject
    private ModulesRegistry registry;
    @Inject
    protected ProbeProviderFactory probeProviderFactory;
    @Inject
    protected ProbeClientMediator pcm;
    @Inject
    Events events;
    @Inject(optional=true)
    MonitoringService monitoringService = null;
    @Inject
    private ProbeRegistry probeRegistry;
    Map<String, Module> map = Collections.synchronizedMap(new WeakHashMap());
    private static final String INSTALL_ROOT_URI_PROPERTY_NAME = "com.sun.aas.installRootURI";
    private static final Logger logger = LogDomains.getLogger(MonitoringBootstrap.class, (String)"javax.enterprise.system.tools.monitor");
    public static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(MonitoringBootstrap.class);
    private final String PROBE_PROVIDER_CLASS_NAMES = "probe-provider-class-names";
    private final String PROBE_PROVIDER_XML_FILE_NAMES = "probe-provider-xml-file-names";
    private final String DELIMITER = ",";
    private StatsProviderManagerDelegateImpl spmd;
    private boolean monitoringEnabled;
    private boolean hasDiscoveredXMLProviders = false;

    public void postConstruct() {
        this.monitoringEnabled = this.monitoringService != null ? Boolean.parseBoolean(this.monitoringService.getMonitoringEnabled()) : false;
        if (!this.monitoringEnabled) {
            return;
        }
        this.events.register((EventListener)this);
        boolean isDiscoverXMLProbeProviders = false;
        this.enableMonitoringForProbeProviders(isDiscoverXMLProbeProviders);
    }

    private void discoverProbeProviders() {
        if (logger.isLoggable(Level.FINEST)) {
            this.printd(localStrings.getLocalString("discoveringProbeProviders", "Discovering the ProbeProviders"));
        }
        for (Module m : this.registry.getModules()) {
            if (m.getState() != ModuleState.READY && m.getState() != ModuleState.RESOLVED) continue;
            if (logger.isLoggable(Level.FINEST)) {
                this.printd(" In (discoverProbeProviders) ModuleState - " + (Object)((Object)m.getState()) + " : " + m.getName());
            }
            this.verifyModule(m);
        }
    }

    public void preDestroy() {
        ProbeRegistry.cleanup();
        if (this.spmd != null) {
            this.spmd = new StatsProviderManagerDelegateImpl(this.pcm, this.probeRegistry, this.mrdr, this.domain, this.monitoringService);
            StatsProviderManager.setStatsProviderManagerDelegate((StatsProviderManagerDelegate)this.spmd);
        }
    }

    public void event(EventListener.Event event) {
        if (event.is(EventTypes.SERVER_READY)) {
            String msg = localStrings.getLocalString("discoveringXmlProbeProviders", "Discovering the XML ProbeProviders from lib/monitor");
            if (logger.isLoggable(Level.FINEST)) {
                this.printd(msg);
            }
            this.discoverXMLProviders();
        }
    }

    public void setStatsProviderManagerDelegate() {
        if (this.spmd != null) {
            return;
        }
        this.spmd = new StatsProviderManagerDelegateImpl(this.pcm, this.probeRegistry, this.mrdr, this.domain, this.monitoringService);
        StatsProviderManager.setStatsProviderManagerDelegate((StatsProviderManagerDelegate)this.spmd);
        if (logger.isLoggable(Level.FINEST)) {
            this.printd(" StatsProviderManagerDelegate is assigned");
        }
        AMXGlassfish amxg = AMXGlassfish.DEFAULT;
        amxg.listenForDomainRoot((MBeanServerConnection)ManagementFactory.getPlatformMBeanServer(), (MBeanListener.Callback)this.spmd);
    }

    public void moduleResolved(Module module) {
        if (module == null) {
            return;
        }
        this.verifyModule(module);
    }

    public synchronized void moduleStarted(Module module) {
        if (module == null) {
            return;
        }
        this.verifyModule(module);
    }

    private synchronized void verifyModule(Module module) {
        if (module == null) {
            return;
        }
        String str = module.getName();
        if (!this.map.containsKey(str)) {
            this.map.put(str, module);
            this.addProvider(module);
        }
    }

    public synchronized void moduleStopped(Module module) {
        if (module == null) {
            return;
        }
        String str = module.getName();
    }

    private void addProvider(Module module) {
        if (logger.isLoggable(Level.FINEST)) {
            this.printd(" Adding the Provider - verified the module");
        }
        String mname = module.getName();
        ClassLoader mcl = module.getClassLoader();
        ModuleDefinition md = module.getModuleDefinition();
        Manifest mf = null;
        if (md != null) {
            mf = md.getManifest();
        }
        if (mf != null) {
            Attributes attrs = mf.getMainAttributes();
            String cnames = null;
            String xnames = null;
            if (attrs != null) {
                StringTokenizer st;
                cnames = attrs.getValue("probe-provider-class-names");
                if (cnames != null) {
                    if (logger.isLoggable(Level.FINEST)) {
                        this.printd("probe providers = " + cnames);
                    }
                    st = new StringTokenizer(cnames, ",");
                    while (st.hasMoreTokens()) {
                        try {
                            String clStr = st.nextToken();
                            if (clStr != null) {
                                clStr = clStr.trim();
                            }
                            if (mcl == null) continue;
                            this.processProbeProviderClass(mcl.loadClass(clStr));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                if ((xnames = attrs.getValue("probe-provider-xml-file-names")) != null) {
                    if (logger.isLoggable(Level.FINEST)) {
                        this.printd("xnames = " + xnames);
                    }
                    st = new StringTokenizer(xnames, ",");
                    while (st.hasMoreTokens()) {
                        this.processProbeProviderXML(mcl, st.nextToken(), true);
                    }
                }
            }
        }
        this.handleFutureStatsProviders();
    }

    public void handleFutureStatsProviders() {
        if (FutureStatsProviders.isEmpty()) {
            return;
        }
        ArrayList<StatsProviderInfo> removeList = new ArrayList<StatsProviderInfo>();
        Iterator<StatsProviderInfo> it = FutureStatsProviders.iterator();
        while (it.hasNext()) {
            StatsProviderInfo spInfo = it.next();
            try {
                this.spmd.tryToRegister(spInfo);
                removeList.add(spInfo);
            }
            catch (RuntimeException re) {}
        }
        for (StatsProviderInfo spInfo : removeList) {
            FutureStatsProviders.remove(spInfo);
        }
    }

    private void discoverXMLProviders() {
        if (this.hasDiscoveredXMLProviders) {
            return;
        }
        try {
            URI xmlProviderDirStr = new URI(System.getProperty(INSTALL_ROOT_URI_PROPERTY_NAME) + "/" + "lib" + "/" + "monitor");
            if (logger.isLoggable(Level.FINEST)) {
                this.printd("ProviderXML's Dir = " + xmlProviderDirStr.getPath());
            }
            File xmlProviderDir = new File(xmlProviderDirStr.getPath());
            if (logger.isLoggable(Level.FINEST)) {
                this.printd("ProviderXML's Dir exists = " + xmlProviderDir.exists());
                this.printd("ProviderXML's Dir path - " + xmlProviderDir.getAbsolutePath());
            }
            this.loadXMLProviders(xmlProviderDir);
            this.hasDiscoveredXMLProviders = true;
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(MonitoringBootstrap.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void loadXMLProviders(File xmlProvidersDir) {
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".xml");
            }
        };
        File[] files = xmlProvidersDir.listFiles(filter);
        if (files == null) {
            return;
        }
        HashMap<String, File> providerMap = new HashMap<String, File>();
        for (File file : files) {
            Module module;
            int index;
            if (logger.isLoggable(Level.FINEST)) {
                this.printd("Found the provider xml - " + file.getAbsolutePath());
            }
            if ((index = file.getName().indexOf("-:")) == -1) continue;
            String moduleName = file.getName().substring(0, index);
            providerMap.put(moduleName, file);
            if (logger.isLoggable(Level.FINEST)) {
                this.printd(" The provider xml belongs to - \"" + moduleName + "\"");
            }
            if (!this.map.containsKey(moduleName)) continue;
            if (logger.isLoggable(Level.FINEST)) {
                this.printd(" Module found (containsKey)");
            }
            if ((module = this.map.get(moduleName)) == null) {
                logger.log(Level.SEVERE, localStrings.getLocalString("monitoringMissingModuleFromXmlProbeProviders", "Couldn't find the module, when loading the monitoring providers from XML directory : {0}", new Object[]{moduleName}));
                continue;
            }
            ClassLoader mcl = module.getClassLoader();
            if (logger.isLoggable(Level.FINEST)) {
                this.printd("ModuleClassLoader = " + mcl);
                this.printd("XML File path = " + file.getAbsolutePath());
            }
            this.processProbeProviderXML(mcl, file.getAbsolutePath(), false);
        }
    }

    private void removeProvider(Module module) {
        if (logger.isLoggable(Level.FINEST)) {
            this.printd("removeProvider ...");
        }
    }

    private void processProbeProviderClass(Class cls) {
        if (logger.isLoggable(Level.FINEST)) {
            this.printd("processProbeProviderClass for " + cls);
        }
        try {
            this.probeProviderFactory.getProbeProvider(cls);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(MonitoringBootstrap.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(MonitoringBootstrap.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void processProbeProviderXML(ClassLoader mcl, String xname, boolean inBundle) {
        this.probeProviderFactory.processXMLProbeProviders(mcl, xname, inBundle);
    }

    public UnprocessedChangeEvents changed(PropertyChangeEvent[] propertyChangeEvents) {
        StatsProviderRegistry spr;
        if (logger.isLoggable(Level.FINEST)) {
            this.printd(" spmd = " + (Object)((Object)this.spmd));
        }
        StatsProviderRegistry statsProviderRegistry = spr = this.spmd == null ? null : this.spmd.getStatsProviderRegistry();
        if (logger.isLoggable(Level.FINEST)) {
            this.printd("spr = " + spr);
        }
        for (PropertyChangeEvent event : propertyChangeEvents) {
            boolean oldEnabled;
            if (event == null) continue;
            String propName = event.getPropertyName();
            Object oldVal = event.getOldValue();
            Object newVal = event.getNewValue();
            if (newVal == null || newVal.equals(oldVal) || !this.ok(propName)) continue;
            if (event.getSource() instanceof ModuleMonitoringLevels) {
                String oldEnabled2;
                String newEnabled = newVal.toString().toUpperCase();
                String string = oldEnabled2 = oldVal == null ? "OFF" : oldVal.toString().toUpperCase();
                if (logger.isLoggable(Level.FINEST)) {
                    this.printd(localStrings.getLocalString("levelChangeEventReceived", "Level change event received, {0} New Level = {1}, Old Level = {2}", new Object[]{propName, newEnabled, oldEnabled2}));
                }
                if (newEnabled.equals(oldEnabled2) || spr == null) continue;
                this.handleLevelChange(propName, newEnabled);
                continue;
            }
            if (event.getSource() instanceof ContainerMonitoring) {
                String oldEnabled3;
                ContainerMonitoring cm = (ContainerMonitoring)event.getSource();
                String newEnabled = newVal.toString().toUpperCase();
                String string = oldEnabled3 = oldVal == null ? "OFF" : oldVal.toString().toUpperCase();
                if (logger.isLoggable(Level.FINEST)) {
                    this.printd(localStrings.getLocalString("levelChangeEventReceived", "Level change event received, {0} New Level = {1}, Old Level = {2}", new Object[]{propName, newEnabled, oldEnabled3}));
                }
                if (newEnabled.equals(oldEnabled3) || spr == null) continue;
                this.handleLevelChange(cm.getName(), newEnabled);
                continue;
            }
            if (!(event.getSource() instanceof MonitoringService)) continue;
            boolean newEnabled = Boolean.parseBoolean(newVal.toString());
            boolean bl = oldVal == null ? !newEnabled : (oldEnabled = Boolean.parseBoolean(oldVal.toString()));
            if (logger.isLoggable(Level.FINEST)) {
                this.printd(localStrings.getLocalString("levelChangeEventReceived", "Level change event received, {0} New Level = {1}, Old Level = {2}", new Object[]{propName, newEnabled, oldEnabled}));
            }
            if (newEnabled == oldEnabled) continue;
            this.handleServiceChange(spr, propName, newEnabled);
        }
        return null;
    }

    private void handleLevelChange(String propName, String enabledStr) {
        if (logger.isLoggable(Level.FINEST)) {
            this.printd("In handleLevelChange(), spmd = " + (Object)((Object)this.spmd) + "  Enabled=" + enabledStr);
        }
        if (!this.ok(propName)) {
            return;
        }
        if (this.spmd == null) {
            return;
        }
        if (this.parseLevelsBoolean(enabledStr)) {
            logger.log(Level.INFO, localStrings.getLocalString("enableStatsMonitoring", "Enabling the monitoring for all the stats with level = {0}", new Object[]{enabledStr}));
            this.spmd.enableStatsProviders(propName);
        } else {
            localStrings.getLocalString("disableStatsMonitoring", "Disabling the monitoring for all the stats");
            this.spmd.disableStatsProviders(propName);
        }
    }

    private void handleServiceChange(StatsProviderRegistry spr, String propName, boolean enabled) {
        if (!this.ok(propName)) {
            return;
        }
        if (propName.equals("mbean-enabled")) {
            if (spr == null) {
                return;
            }
            if (enabled) {
                logger.log(Level.INFO, localStrings.getLocalString("mbeanEnabled", "mbean-enabled flag is turned on. Enabling all the MBeans"));
                this.spmd.registerAllGmbal();
            } else {
                logger.log(Level.INFO, localStrings.getLocalString("mbeanDisabled", "mbean-enabled flag is turned off. Disabling all the MBeans"));
                this.spmd.unregisterAllGmbal();
            }
        } else if (propName.equals("dtrace-enabled")) {
            this.probeProviderFactory.dtraceEnabledChanged(enabled);
        } else if (propName.equals("monitoring-enabled")) {
            this.probeProviderFactory.monitoringEnabledChanged(enabled);
            if (enabled) {
                logger.log(Level.INFO, localStrings.getLocalString("monitoringEnabled", "monitoring-enabled flag is turned on. Enabling all the Probes and Stats"));
                FlashlightProbeClientMediator.attachAgent();
                this.enableMonitoringForProbeProviders(true);
                this.spmd.updateAllStatsProviders();
            } else {
                logger.log(Level.INFO, localStrings.getLocalString("monitoringDisabled", "monitoring-enabled flag is turned off. Disabling all the Stats"));
                this.disableMonitoringForProbeProviders();
                this.spmd.disableAllStatsProviders();
            }
        }
    }

    private void enableMonitoringForProbeProviders(boolean isDiscoverXMLProviders) {
        this.discoverProbeProviders();
        this.registry.register(this);
        if (isDiscoverXMLProviders) {
            this.discoverXMLProviders();
        }
        this.setStatsProviderManagerDelegate();
    }

    private void disableMonitoringForProbeProviders() {
        this.registry.unregister(this);
    }

    private boolean ok(String s) {
        return s != null && s.length() > 0;
    }

    private boolean parseLevelsBoolean(String s) {
        return !this.ok(s) || !s.equals("OFF");
    }

    private void printd(String pstring) {
        logger.log(Level.FINEST, pstring);
    }
}

