/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.monitor.jvm;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.List;
import org.glassfish.admin.monitor.jvm.JVMClassLoadingStatsProvider;
import org.glassfish.admin.monitor.jvm.JVMCompilationStatsProvider;
import org.glassfish.admin.monitor.jvm.JVMGCStatsProvider;
import org.glassfish.admin.monitor.jvm.JVMMemoryStatsProvider;
import org.glassfish.admin.monitor.jvm.JVMOSStatsProvider;
import org.glassfish.admin.monitor.jvm.JVMRuntimeStatsProvider;
import org.glassfish.admin.monitor.jvm.JVMThreadInfoStatsProvider;
import org.glassfish.admin.monitor.jvm.JVMThreadSystemStatsProvider;
import org.glassfish.external.probe.provider.PluginPoint;
import org.glassfish.external.probe.provider.StatsProviderManager;
import org.glassfish.internal.api.PostStartup;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;

@Service
public class JVMStatsProviderBootstrap
implements PostStartup,
PostConstruct {
    private JVMClassLoadingStatsProvider clStatsProvider = new JVMClassLoadingStatsProvider();
    private JVMCompilationStatsProvider compileStatsProvider = new JVMCompilationStatsProvider();
    private JVMMemoryStatsProvider memoryStatsProvider = new JVMMemoryStatsProvider();
    private JVMOSStatsProvider osStatsProvider = new JVMOSStatsProvider();
    private JVMRuntimeStatsProvider runtimeStatsProvider = new JVMRuntimeStatsProvider();
    private JVMThreadSystemStatsProvider threadSysStatsProvider = new JVMThreadSystemStatsProvider();
    private List<JVMGCStatsProvider> jvmStatsProviderList = new ArrayList<JVMGCStatsProvider>();
    private ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
    public static final String JVM = "jvm";

    public void postConstruct() {
        StatsProviderManager.register((String)JVM, (PluginPoint)PluginPoint.SERVER, (String)"jvm/class-loading-system", (Object)this.clStatsProvider, (String)"LOW");
        StatsProviderManager.register((String)JVM, (PluginPoint)PluginPoint.SERVER, (String)"jvm/compilation-system", (Object)this.compileStatsProvider, (String)"LOW");
        for (GarbageCollectorMXBean gc : ManagementFactory.getGarbageCollectorMXBeans()) {
            JVMGCStatsProvider jvmStatsProvider = new JVMGCStatsProvider(gc.getName());
            this.jvmStatsProviderList.add(jvmStatsProvider);
            StatsProviderManager.register((String)JVM, (PluginPoint)PluginPoint.SERVER, (String)("jvm/garbage-collectors/" + gc.getName()), (Object)jvmStatsProvider, (String)"LOW");
        }
        StatsProviderManager.register((String)JVM, (PluginPoint)PluginPoint.SERVER, (String)"jvm/memory", (Object)this.memoryStatsProvider, (String)"LOW");
        StatsProviderManager.register((String)JVM, (PluginPoint)PluginPoint.SERVER, (String)"jvm/operating-system", (Object)this.osStatsProvider, (String)"LOW");
        StatsProviderManager.register((String)JVM, (PluginPoint)PluginPoint.SERVER, (String)"jvm/runtime", (Object)this.runtimeStatsProvider, (String)"LOW");
        StatsProviderManager.register((String)JVM, (PluginPoint)PluginPoint.SERVER, (String)"jvm/thread-system", (Object)this.threadSysStatsProvider, (String)"LOW");
        for (ThreadInfo t : this.threadBean.getThreadInfo(this.threadBean.getAllThreadIds(), 5)) {
            JVMThreadInfoStatsProvider threadInfoStatsProvider = new JVMThreadInfoStatsProvider(t);
            StatsProviderManager.register((String)JVM, (PluginPoint)PluginPoint.SERVER, (String)("jvm/thread-system/thread-" + t.getThreadId()), (Object)threadInfoStatsProvider, (String)"HIGH");
        }
    }
}

