/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl.monitor;

import com.sun.enterprise.v3.services.impl.monitor.GrizzlyMonitoring;
import com.sun.enterprise.v3.services.impl.monitor.MonitorableWorkerThread;
import com.sun.enterprise.v3.services.impl.monitor.probes.ThreadPoolProbeProvider;
import com.sun.enterprise.v3.services.impl.monitor.stats.StatsProvider;
import com.sun.grizzly.http.StatsThreadPool;
import com.sun.grizzly.util.AbstractThreadPool;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class MonitorableThreadPool
extends StatsThreadPool {
    private final GrizzlyMonitoring monitoring;
    private final String monitoringId;

    public MonitorableThreadPool(GrizzlyMonitoring monitoring, String monitoringId, String threadPoolName, int corePoolSize, int maximumPoolSize, int maxTasksCount, long keepAliveTime, TimeUnit unit) {
        super(threadPoolName, corePoolSize, maximumPoolSize, maxTasksCount, keepAliveTime, unit);
        this.monitoring = monitoring;
        this.monitoringId = monitoringId;
        if (monitoring != null) {
            StatsProvider statsProvider = monitoring.getThreadPoolStatsProvider(monitoringId);
            if (statsProvider != null) {
                statsProvider.setStatsObject((Object)this);
            }
            if ((statsProvider = monitoring.getConnectionQueueStatsProvider(monitoringId)) != null) {
                statsProvider.setStatsObject((Object)this);
            }
        }
        this.setThreadFactory(new ProbeWorkerThreadFactory());
        ThreadPoolProbeProvider threadPoolProbeProvider = monitoring.getThreadPoolProbeProvider();
        threadPoolProbeProvider.setCoreThreadsEvent(monitoringId, threadPoolName, this.corePoolSize);
        threadPoolProbeProvider.setMaxThreadsEvent(monitoringId, threadPoolName, this.maxPoolSize);
        monitoring.getConnectionQueueProbeProvider().setMaxTaskQueueSizeEvent(monitoringId, this.getMaxQueuedTasksCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCorePoolSize(int corePoolSize) {
        Object object = this.statelock;
        synchronized (object) {
            super.setCorePoolSize(corePoolSize);
            if (this.monitoring == null) {
                return;
            }
            this.monitoring.getThreadPoolProbeProvider().setCoreThreadsEvent(this.monitoringId, this.getName(), corePoolSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaximumPoolSize(int maxPoolSize) {
        Object object = this.statelock;
        synchronized (object) {
            super.setMaximumPoolSize(maxPoolSize);
            if (this.monitoring == null) {
                return;
            }
            this.monitoring.getThreadPoolProbeProvider().setMaxThreadsEvent(this.monitoringId, this.getName(), maxPoolSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setPoolSizes(int corePoolSize, int maxPoolSize) {
        Object object = this.statelock;
        synchronized (object) {
            super.setPoolSizes(corePoolSize, maxPoolSize);
            if (this.monitoring == null) {
                return;
            }
            ThreadPoolProbeProvider threadPoolProbeProvider = this.monitoring.getThreadPoolProbeProvider();
            threadPoolProbeProvider.setCoreThreadsEvent(this.monitoringId, this.getName(), corePoolSize);
            threadPoolProbeProvider.setMaxThreadsEvent(this.monitoringId, this.getName(), maxPoolSize);
        }
    }

    protected void beforeExecute(Thread thread, Runnable runnable) {
        super.beforeExecute(thread, runnable);
        this.monitoring.getThreadPoolProbeProvider().threadDispatchedFromPoolEvent(this.monitoringId, this.getName(), thread.getName());
    }

    protected void afterExecute(Runnable r, Throwable t) {
        this.monitoring.getThreadPoolProbeProvider().threadReturnedToPoolEvent(this.monitoringId, this.getName(), Thread.currentThread().getName());
        super.afterExecute(r, t);
    }

    protected void onWorkerStarted(AbstractThreadPool.Worker worker) {
        super.onWorkerStarted(worker);
        this.monitoring.getThreadPoolProbeProvider().threadAllocatedEvent(this.monitoringId, this.getName(), Thread.currentThread().getName());
    }

    protected void onWorkerExit(AbstractThreadPool.Worker worker) {
        this.monitoring.getThreadPoolProbeProvider().threadReleasedEvent(this.monitoringId, this.getName(), Thread.currentThread().getName());
        super.onWorkerExit(worker);
    }

    protected void onMaxNumberOfThreadsReached() {
        this.monitoring.getThreadPoolProbeProvider().maxNumberOfThreadsReachedEvent(this.monitoringId, this.getName(), this.getMaximumPoolSize());
        super.onMaxNumberOfThreadsReached();
    }

    protected void onTaskQueued(Runnable task) {
        this.monitoring.getConnectionQueueProbeProvider().onTaskQueuedEvent(this.monitoringId, task);
        super.onTaskQueued(task);
    }

    protected void onTaskDequeued(Runnable task) {
        this.monitoring.getConnectionQueueProbeProvider().onTaskDequeuedEvent(this.monitoringId, task);
        super.onTaskDequeued(task);
    }

    protected void onTaskQueueOverflow() {
        this.monitoring.getConnectionQueueProbeProvider().onTaskQueueOverflowEvent(this.monitoringId);
        super.onTaskQueueOverflow();
    }

    public class ProbeWorkerThreadFactory
    implements ThreadFactory {
        public Thread newThread(Runnable r) {
            MonitorableWorkerThread thread = new MonitorableWorkerThread(MonitorableThreadPool.this, r, MonitorableThreadPool.this.name + "-(" + MonitorableThreadPool.this.nextThreadId() + ")", MonitorableThreadPool.this.initialByteBufferSize, MonitorableThreadPool.this.monitoring);
            return thread;
        }
    }
}

