/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.jruby;

import com.sun.grizzly.jruby.JRubyGrizzlyConfigImpl;
import com.sun.grizzly.jruby.Messages;
import com.sun.grizzly.jruby.rack.AbstractRackApplication;
import com.sun.grizzly.jruby.rack.ErrorApplication;
import com.sun.grizzly.jruby.rack.RackApplicationPool;
import com.sun.grizzly.jruby.rack.RackApplicationPoolFactory;
import com.sun.grizzly.tcp.http11.GrizzlyAdapter;
import com.sun.grizzly.tcp.http11.GrizzlyRequest;
import com.sun.grizzly.tcp.http11.GrizzlyResponse;
import com.sun.grizzly.util.buf.ByteChunk;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jruby.runtime.Constants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RackGrizzlyAdapter
extends GrizzlyAdapter {
    private final Logger logger;
    private final int numThreads;
    private final boolean asyncExecution;
    final String jrubyVersion;
    private RackApplicationPool<AbstractRackApplication> pool;
    private ErrorApplication errorApp;
    public final JRubyGrizzlyConfigImpl config;
    private FutureTask<RackApplicationPool<AbstractRackApplication>> jrubyStartUp;
    private static final String CSS = "H1 {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:22px;} H2 {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:16px;} H3 {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:14px;} BODY {font-family:Tahoma,Arial,sans-serif;color:black;background-color:white;} B {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;} P {font-family:Tahoma,Arial,sans-serif;background:white;color:black;font-size:12px;}A {color : black;}HR {color : #525D76;}";

    public RackGrizzlyAdapter(JRubyGrizzlyConfigImpl config, boolean asyncExecution) {
        super(config.appRoot());
        this.config = config;
        this.asyncExecution = asyncExecution;
        this.logger = config.getLogger();
        this.jrubyVersion = Constants.VERSION;
        this.logger.log(Level.INFO, Messages.format("jruby.version", this.jrubyVersion));
        this.numThreads = Math.min(Runtime.getRuntime().availableProcessors(), config.runtimeConfig().getInitRuntime());
    }

    public boolean async() {
        return this.asyncExecution;
    }

    public int getNumThreads() {
        return this.numThreads;
    }

    private void startThread() {
        ExecutorService exec = Executors.newSingleThreadExecutor();
        this.jrubyStartUp = new FutureTask<RackApplicationPool<AbstractRackApplication>>(new Callable<RackApplicationPool<AbstractRackApplication>>(){

            @Override
            public RackApplicationPool<AbstractRackApplication> call() throws Exception {
                return RackGrizzlyAdapter.this.startJRubyRuntime();
            }
        });
        exec.submit(this.jrubyStartUp, RackApplicationPool.class);
    }

    public void start() {
        this.startThread();
    }

    private RackApplicationPool<AbstractRackApplication> startJRubyRuntime() {
        return RackApplicationPoolFactory.getRackApplocationPool(this);
    }

    public void destroy() {
        if (this.errorApp != null) {
            this.errorApp.destroy();
        }
        if (this.pool != null) {
            this.pool.shutdown();
        }
    }

    private byte[] getHtmlPage(String text) {
        StringBuffer sb = new StringBuffer();
        sb.append("<html><head>");
        sb.append("<style><!--");
        sb.append(CSS);
        sb.append("--></style> ");
        sb.append("</head><body>");
        sb.append(text);
        sb.append("<hr/>");
        sb.append("<span\n style=\"font-style: italic;\">Powered by GlassFish v3</span>");
        sb.append("</body></html>");
        return sb.toString().getBytes();
    }

    private void writeHtml(byte[] bytes, GrizzlyResponse res) {
        ByteChunk chunk = new ByteChunk();
        chunk.setBytes(bytes, 0, bytes.length);
        res.setContentLength(bytes.length);
        res.setContentType("text/html");
        try {
            res.getResponse().sendHeaders();
            res.getResponse().doWrite(chunk);
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private void throwError(StringBuffer text, Exception e, GrizzlyResponse res) {
        res.setStatus(500);
        if (this.config.environment().equals("development") || this.config.environment().equals("test")) {
            text.append("<p>");
            text.append(e.getMessage()).append("<br/>");
            for (StackTraceElement el : e.getStackTrace()) {
                text.append(el.toString() + "<br/>");
            }
            text.append("</p>");
        }
        byte[] bytes = this.getHtmlPage(text.toString());
        this.writeHtml(bytes, res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(GrizzlyRequest req, GrizzlyResponse res) {
        this.config.jrubyHttpProbeProvider.requestStartEvent(this.config.contextRoot(), req.getServerName(), req.getServerPort());
        if (!this.jrubyStartUp.isDone()) {
            res.setStatus(503);
            byte[] bytes = this.getHtmlPage("<h3>Server is busy loading the application... </h3>");
            String delta = System.getProperty("jruby.http.retry-after");
            if (delta == null) {
                delta = "3";
            }
            res.setHeader("Retry-After", delta);
            this.writeHtml(bytes, res);
            return;
        }
        try {
            this.pool = this.jrubyStartUp.get();
        }
        catch (InterruptedException e) {
            this.logger.log(Level.SEVERE, Messages.format("rackgrizzlyadapter.service.jrubyinstance.failed", new Object[0]), e);
            StringBuffer text = new StringBuffer();
            text.append("<h3>Something went wrong on the server.<br/>Check the server log for details!</h3>");
            this.throwError(text, e, res);
            return;
        }
        catch (ExecutionException e) {
            this.logger.log(Level.SEVERE, Messages.format("rackgrizzlyadapter.service.jrubyinstance.failed", new Object[0]), e);
            StringBuffer text = new StringBuffer();
            text.append("<h3>Something went wrong on the server.<br/>Check the server log for details!</h3>");
            this.throwError(text, e, res);
            return;
        }
        if (this.pool == null) {
            this.logger.log(Level.SEVERE, Messages.format("rackgrizzlyadapter.service.jrubyinstance.failed", new Object[0]));
            StringBuffer text = new StringBuffer();
            text.append("<h3>Something went wrong on the server.<br/>Check the server log for details!</h3>");
            res.setStatus(500);
            byte[] bytes = this.getHtmlPage(text.toString());
            this.writeHtml(bytes, res);
            return;
        }
        AbstractRackApplication serviceApp = null;
        try {
            serviceApp = this.pool.getApp();
            if (serviceApp == null) {
                throw new IllegalStateException(Messages.format("jruby.runtime.notavailable", new Object[0]));
            }
            this.dispatchRequest(serviceApp, req, res);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (serviceApp != null) {
                this.pool.returnApp(serviceApp);
            }
            this.config.jrubyHttpProbeProvider.requestEndEvent(this.config.contextRoot(), res.getStatus());
        }
    }

    private void dispatchRequest(AbstractRackApplication app, GrizzlyRequest req, GrizzlyResponse res) throws IOException {
        try {
            app.call(req).respond(res);
        }
        catch (Exception e) {
            res.setError();
            if (res.isCommitted()) {
                this.logger.log(Level.WARNING, Messages.format("rackgrizzlyadapter.service.canthandle.rescomit", new Object[0]), e);
                return;
            }
            res.reset();
            try {
                this.createErrorApp(app);
                req.setAttribute("rack.exception", (Object)e);
                this.logger.log(Level.WARNING, e.getMessage(), e);
                this.errorApp.call(req).respond(res);
            }
            catch (Exception ex) {
                this.logger.log(Level.WARNING, Messages.format("rackgrizzlyadapter.service.canthandle", ex.getMessage()), ex);
                res.sendError(500);
            }
        }
    }

    private synchronized void createErrorApp(AbstractRackApplication app) {
        if (this.errorApp == null) {
            this.errorApp = new ErrorApplication(app.runtime, this);
        }
    }
}

