/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.jms.spi.xa.JMSXAConnectionFactory;
import com.sun.jms.spi.xa.JMSXATopicConnection;
import com.sun.jms.spi.xa.JMSXATopicSession;
import com.sun.messaging.jmq.jmsclient.JMSXAWrappedConnectionFactoryImpl;
import com.sun.messaging.jmq.jmsclient.JMSXAWrappedTopicSessionImpl;
import java.util.Vector;
import javax.jms.Connection;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.TopicConnection;

public class JMSXAWrappedTopicConnectionImpl
implements JMSXATopicConnection {
    private static final boolean debug = JMSXAWrappedConnectionFactoryImpl.debug;
    private Connection wrapped_connection;
    private JMSXAWrappedConnectionFactoryImpl wcf_ = null;
    private String username_ = null;
    private String password_ = null;
    private Vector sessions_ = new Vector();
    private boolean markClosed_ = false;
    private boolean closed_ = false;

    private JMSXAWrappedTopicConnectionImpl() {
    }

    public JMSXAWrappedTopicConnectionImpl(TopicConnection topicConnection, JMSXAWrappedConnectionFactoryImpl jMSXAWrappedConnectionFactoryImpl, String string, String string2) throws JMSException {
        this.wrapped_connection = topicConnection;
        this.wcf_ = jMSXAWrappedConnectionFactoryImpl;
        this.username_ = string;
        this.password_ = string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JMSXATopicSession createXATopicSession(boolean bl, int n) throws JMSException {
        Vector vector = this.sessions_;
        synchronized (vector) {
            if (this.closed_) {
                throw new IllegalStateException("JMSXWrapped Connection has been closed");
            }
            if (this.markClosed_) {
                throw new IllegalStateException("JMSXAWrapped Connection is closed");
            }
            JMSXAWrappedTopicSessionImpl jMSXAWrappedTopicSessionImpl = new JMSXAWrappedTopicSessionImpl((TopicConnection)this.wrapped_connection, bl, n, this);
            if (jMSXAWrappedTopicSessionImpl.delaySessionClose()) {
                this.sessions_.add(jMSXAWrappedTopicSessionImpl);
            }
            return jMSXAWrappedTopicSessionImpl;
        }
    }

    public TopicConnection getTopicConnection() {
        return (TopicConnection)this.wrapped_connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        JMSXAWrappedTopicConnectionImpl.dlog("closing " + this.wrapped_connection + " " + this.wrapped_connection.getClass().getName());
        Vector vector = this.sessions_;
        synchronized (vector) {
            if (this.sessions_.isEmpty()) {
                this.closed_ = true;
            } else {
                this.markClosed_ = true;
            }
        }
        if (this.closed_) {
            this.hardClose();
        }
    }

    private void hardClose() throws JMSException {
        JMSXAWrappedTopicConnectionImpl.dlog("hard closing " + this.wrapped_connection + " " + this.wrapped_connection.getClass().getName());
        this.wrapped_connection.close();
        this.closed_ = true;
        JMSXAWrappedTopicConnectionImpl.dlog("hard closed " + this.wrapped_connection + " " + this.wrapped_connection.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSession(JMSXAWrappedTopicSessionImpl jMSXAWrappedTopicSessionImpl) {
        Vector vector = this.sessions_;
        synchronized (vector) {
            this.sessions_.remove(jMSXAWrappedTopicSessionImpl);
            if (this.sessions_.isEmpty() && this.markClosed_) {
                JMSXAWrappedTopicConnectionImpl.dlog("All sessions closed, hard close connection " + this.wrapped_connection + " " + this.wrapped_connection.getClass().getName());
                this.closed_ = true;
            }
        }
        if (this.closed_) {
            try {
                this.hardClose();
            }
            catch (JMSException jMSException) {
                JMSXAWrappedTopicConnectionImpl.log("Warning:", jMSException);
            }
        }
    }

    protected JMSXAConnectionFactory getJMSXAWrappedConnectionFactory() {
        return this.wcf_;
    }

    protected String getUsername() {
        return this.username_;
    }

    protected String getPassword() {
        return this.password_;
    }

    private static final void dlog(String string) {
        if (debug) {
            JMSXAWrappedTopicConnectionImpl.log("Info:", string);
        }
    }

    private static final void dlogStack(Exception exception) {
        if (debug) {
            exception.printStackTrace();
        }
    }

    private static final void log(String string, Exception exception) {
        JMSXAWrappedTopicConnectionImpl.log(string, exception.getMessage());
        exception.printStackTrace();
    }

    private static final void log(String string, String string2) {
        System.out.println(string + " " + "JMSXAWrappedTopicConnectionImpl: " + string2);
    }
}

